/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.config.palette;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_10321;
import net.minecraft.class_10322;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2202;
import net.minecraft.class_2211;
import net.minecraft.class_2215;
import net.minecraft.class_2217;
import net.minecraft.class_2221;
import net.minecraft.class_2222;
import net.minecraft.class_2237;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2258;
import net.minecraft.class_2261;
import net.minecraft.class_2266;
import net.minecraft.class_2276;
import net.minecraft.class_2279;
import net.minecraft.class_2282;
import net.minecraft.class_2283;
import net.minecraft.class_2297;
import net.minecraft.class_2298;
import net.minecraft.class_2299;
import net.minecraft.class_2301;
import net.minecraft.class_2320;
import net.minecraft.class_2323;
import net.minecraft.class_2328;
import net.minecraft.class_2333;
import net.minecraft.class_2344;
import net.minecraft.class_2346;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2358;
import net.minecraft.class_2360;
import net.minecraft.class_2362;
import net.minecraft.class_2369;
import net.minecraft.class_2384;
import net.minecraft.class_2391;
import net.minecraft.class_2393;
import net.minecraft.class_2476;
import net.minecraft.class_2496;
import net.minecraft.class_2510;
import net.minecraft.class_2518;
import net.minecraft.class_2523;
import net.minecraft.class_2525;
import net.minecraft.class_2533;
import net.minecraft.class_2541;
import net.minecraft.class_2542;
import net.minecraft.class_2544;
import net.minecraft.class_2553;
import net.minecraft.class_2577;
import net.minecraft.class_2667;
import net.minecraft.class_2671;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_3736;
import net.minecraft.class_3749;
import net.minecraft.class_4775;
import net.minecraft.class_4776;
import net.minecraft.class_4863;
import net.minecraft.class_5543;
import net.minecraft.class_5544;
import net.minecraft.class_5552;
import net.minecraft.class_5553;
import net.minecraft.class_5554;
import net.minecraft.class_5556;
import net.minecraft.class_5689;
import net.minecraft.class_5801;
import net.minecraft.class_5802;
import net.minecraft.class_5803;
import net.minecraft.class_5806;
import net.minecraft.class_5809;
import net.minecraft.class_7113;
import net.minecraft.class_7923;
import net.minecraft.class_8238;
import net.minecraft.class_8960;
import net.minecraft.class_9197;
import net.minecraft.class_9366;
import net.minecraft.class_9797;
import rh.maparthelper.MapartHelper;
import rh.maparthelper.colors.MapColorEntry;
import rh.maparthelper.config.CommonConfiguration;
import rh.maparthelper.config.palette.PaletteColors;
import rh.maparthelper.config.palette.PaletteConfigManager;
import rh.maparthelper.config.palette.PalettePresetsConfig;

public class PaletteGenerator {
    private static final Class<?>[] NEED_WATER_BLOCKS = new Class[]{class_2298.class, class_2301.class, class_2297.class, class_2299.class, class_2393.class, class_2476.class, class_2525.class, class_2391.class};
    private static final Class<?>[] MEANINGLESS_BLOCKS = new Class[]{class_2244.class, class_2323.class, class_2360.class, class_2258.class, class_7113.class, class_2553.class, class_8238.class, class_2542.class, class_2362.class, class_4776.class, class_5803.class, class_5809.class, class_2671.class, class_2667.class, class_2266.class, class_2282.class, class_2358.class, class_4775.class, class_2283.class, class_2279.class, class_5802.class, class_10321.class, class_5806.class, class_5553.class, class_5556.class, class_2344.class, class_2369.class, class_9366.class};
    private static final Class<?>[] CREATIVE_BLOCKS = new Class[]{class_5552.class, class_2518.class, class_2496.class, class_8960.class, class_9197.class, class_2333.class, class_9797.class, class_5543.class, class_2328.class, class_2384.class};
    private static final Class<?>[] GROWABLE_BLOCKS = new Class[]{class_2261.class, class_4863.class, class_2211.class, class_2202.class, class_2523.class, class_2541.class};
    private static final Class<?>[] GRASS_LIKE_BLOCKS = new Class[]{class_2261.class, class_2320.class, class_2301.class, class_2297.class, class_2299.class, class_2217.class, class_2221.class, class_2222.class, class_5801.class, class_5689.class};
    private static final Class<?>[] BUILD_DECOR_BLOCKS = new Class[]{class_2354.class, class_2349.class, class_2544.class, class_2215.class, class_2510.class, class_2533.class, class_3749.class, class_5544.class, class_5554.class, class_2276.class};
    private static final List<class_2248> FUNCTIONAL_BLOCKS = List.of(class_2246.field_9980, class_2246.field_10535, class_2246.field_10105, class_2246.field_10414, class_2246.field_16337, class_2246.field_16335, class_2246.field_10179, class_2246.field_10083, class_2246.field_16336, class_2246.field_16331, class_2246.field_16329, class_2246.field_10181);

    public static void initColors(Map<Integer, List<class_2248>> palette) {
        palette.clear();
        PaletteColors.argbMapColors.clear();
        for (class_2248 block : class_7923.field_41175) {
            class_2680 state = block.method_9564();
            class_3620 color = state.method_26205(null, null);
            if (color == class_3620.field_16008 || color == null) continue;
            boolean useCreativeBlocks = MapartHelper.commonConfig.useInPalette.creativeBlocks;
            if (!PaletteGenerator.useBlockInPalette(block) || !useCreativeBlocks && (block == class_2246.field_9987 || block == class_2246.field_38420 || block == class_2246.field_10298)) continue;
            if (!palette.containsKey(color.field_16021)) {
                palette.put(color.field_16021, new ArrayList());
            }
            palette.get(color.field_16021).add(block);
        }
        PaletteGenerator.initARGBMapColor(palette);
        class_1799[] toolItems = new class_1799[]{new class_1799((class_1935)class_1802.field_22022), new class_1799((class_1935)class_1802.field_22025), new class_1799((class_1935)class_1802.field_22024), new class_1799((class_1935)class_1802.field_22023), new class_1799((class_1935)class_1802.field_22026), new class_1799((class_1935)class_1802.field_8868)};
        for (int colorId : palette.keySet()) {
            palette.get(colorId).sort(Comparator.comparingDouble(b -> PaletteGenerator.getBlockScore(b, toolItems)));
        }
    }

    public static void initARGBMapColor(Map<Integer, List<class_2248>> palette) {
        for (int colorId : palette.keySet()) {
            if (palette.get(colorId).isEmpty()) continue;
            PaletteGenerator.addARGBMapColorEntries(class_3620.method_38479((int)colorId));
        }
    }

    private static void addARGBMapColorEntries(class_3620 mapColor) {
        if (mapColor == class_3620.field_16019) {
            PaletteColors.argbMapColors.put(mapColor.method_15820(class_3620.class_6594.field_34760), new MapColorEntry(mapColor, class_3620.class_6594.field_34760));
        } else {
            class_3620.class_6594[] brightnesses;
            for (class_3620.class_6594 brightness : brightnesses = new class_3620.class_6594[]{class_3620.class_6594.field_34759, class_3620.class_6594.field_34760, class_3620.class_6594.field_34761}) {
                int argb = mapColor.method_15820(brightness);
                MapColorEntry entry = new MapColorEntry(mapColor, brightness);
                PaletteColors.argbMapColors.put(argb, entry);
            }
        }
    }

    private static boolean useBlockInPalette(class_2248 block) {
        CommonConfiguration.UseInBlockPalette useInPalette = MapartHelper.commonConfig.useInPalette;
        if (useInPalette.anyBlocks) {
            return true;
        }
        if (PaletteGenerator.matchesAny(block, MEANINGLESS_BLOCKS)) {
            return false;
        }
        if (useInPalette.onlySolid) {
            return block.getClass() == class_2248.class;
        }
        if (useInPalette.onlyCarpets) {
            return PaletteGenerator.matchesAny(block, class_2577.class, class_10322.class);
        }
        if (!useInPalette.blocksWithEntities && block instanceof class_2237) {
            return false;
        }
        if (!useInPalette.buildDecorBlocks && PaletteGenerator.matchesAny(block, BUILD_DECOR_BLOCKS)) {
            return false;
        }
        if (!useInPalette.creativeBlocks && PaletteGenerator.matchesAny(block, CREATIVE_BLOCKS)) {
            return false;
        }
        if (!useInPalette.needWaterBlocks && PaletteGenerator.matchesAny(block, NEED_WATER_BLOCKS)) {
            return false;
        }
        if (!useInPalette.growableBlocks && PaletteGenerator.matchesAny(block, GROWABLE_BLOCKS)) {
            return false;
        }
        return useInPalette.grassLikeBlocks || !PaletteGenerator.matchesAny(block, GRASS_LIKE_BLOCKS);
    }

    public static class_2680 getDefaultPaletteState(class_2248 block) {
        class_2680 state = block.method_9564();
        state = (class_2680)state.method_47968((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
        state = (class_2680)state.method_47968((class_2769)class_2741.field_12546, (Comparable)Boolean.valueOf(true));
        state = (class_2680)state.method_47968((class_2769)class_2741.field_12514, (Comparable)Boolean.valueOf(true));
        return state;
    }

    private static float getBlockScore(class_2248 block, class_1799[] tools) {
        float breakTime = PaletteGenerator.getRoughMinBreakingSpeed(block, tools);
        float typePenalty = 0.0f;
        class_2680 blockState = block.method_9564();
        if (block == class_2246.field_10225) {
            typePenalty -= 3.0f;
        }
        if (block == class_2246.field_10508) {
            typePenalty -= 3.0f;
        } else if (PaletteGenerator.isWool(blockState)) {
            typePenalty -= 5.0f;
        } else if (blockState.method_26164(class_3481.field_36265)) {
            typePenalty -= 4.5f;
        } else if (blockState.method_26164(class_3481.field_15503)) {
            typePenalty -= 3.0f;
        }
        if (blockState.method_26164(class_3481.field_15471) || blockState.method_26164(class_3481.field_15468)) {
            typePenalty -= 0.1f;
        } else if (block == class_2246.field_10580) {
            typePenalty += 0.5f;
        } else if (block instanceof class_3736) {
            typePenalty += 2.0f;
        } else if (block instanceof class_2577) {
            typePenalty += 1.0f;
        } else if (block instanceof class_2346) {
            typePenalty += 1.5f;
        } else if (blockState.method_26164(class_3481.field_24076)) {
            typePenalty += 0.3f;
        } else if (blockState.method_26164(class_3481.field_15469)) {
            typePenalty += 2.0f;
        } else if (FUNCTIONAL_BLOCKS.contains(block) || block instanceof class_2237) {
            typePenalty += 4.0f;
        }
        return breakTime + typePenalty;
    }

    private static boolean isWool(class_2680 blockState) {
        return blockState.method_26164(class_3481.field_15481) || blockState.method_26164(class_3481.field_15479);
    }

    private static float getRoughMinBreakingSpeed(class_2248 block, class_1799[] tools) {
        class_2680 state = block.method_9564();
        float hardness = block.method_36555();
        if (hardness < 0.0f) {
            return Float.POSITIVE_INFINITY;
        }
        double[] toolsSpeed = Arrays.stream(tools).mapToDouble(t -> t.method_7924(state)).toArray();
        float maxSpeed = (float)Arrays.stream(toolsSpeed).max().orElse(0.0);
        if (maxSpeed <= 0.0f) {
            return Float.POSITIVE_INFINITY;
        }
        return hardness / maxSpeed;
    }

    private static boolean matchesAny(class_2248 block, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            if (!clazz.isInstance(block)) continue;
            return true;
        }
        return false;
    }

    public static PalettePresetsConfig.PalettePreset getDefaultPreset() {
        Map<Integer, List<class_2248>> completePalette = PaletteConfigManager.completePalette.palette;
        Map<class_3620, class_2248> palette = completePalette.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).collect(Collectors.toMap(entry -> class_3620.method_38479((int)((Integer)entry.getKey())), entry -> ((List)entry.getValue()).isEmpty() ? class_2246.field_10124 : (class_2248)((List)entry.getValue()).getFirst()));
        palette.remove(class_3620.field_16019);
        List<class_2248> blocks = completePalette.get(class_3620.field_15999.field_16021);
        if (blocks != null && blocks.contains(class_2246.field_10219)) {
            palette.replace(class_3620.field_15999, class_2246.field_10219);
        }
        if ((blocks = completePalette.get(class_3620.field_15996.field_16021)) != null && blocks.contains(class_2246.field_10161)) {
            palette.replace(class_3620.field_15996, class_2246.field_10161);
        }
        if ((blocks = completePalette.get(class_3620.field_15994.field_16021)) != null && blocks.contains(class_2246.field_10224)) {
            palette.replace(class_3620.field_15994, class_2246.field_10224);
        }
        if ((blocks = completePalette.get(class_3620.field_16017.field_16021)) != null && blocks.contains(class_2246.field_9975)) {
            palette.replace(class_3620.field_16017, class_2246.field_9975);
        }
        return new PalettePresetsConfig.PalettePreset(palette);
    }
}

