/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.conversion.mapart;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1043;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import rh.maparthelper.MapartHelper;
import rh.maparthelper.conversion.CurrentConversionSettings;
import rh.maparthelper.conversion.mapart.MapartImage;
import rh.maparthelper.conversion.mapart.ProcessingMapartImage;
import rh.maparthelper.util.Utils;

@Environment(value=EnvType.CLIENT)
public final class ConvertedMapartImage
extends MapartImage {
    private boolean reset = true;

    public ConvertedMapartImage update(ProcessingMapartImage mapart) {
        this.colorsCounter = mapart.colorsCounter;
        this.nativeImage = mapart.nativeImage;
        this.original = mapart.original;
        this.imagePath = mapart.imagePath;
        this.mapartName = mapart.mapartName;
        this.width = mapart.width;
        this.height = mapart.height;
        this.insertionX = mapart.insertionX;
        this.insertionY = mapart.insertionY;
        this.scaledImage = mapart.scaledImage;
        this.scale = mapart.scale;
        this.croppingFrame.setX(mapart.croppingFrame.getX());
        this.croppingFrame.setY(mapart.croppingFrame.getY());
        this.croppingFrame.setWidth(mapart.croppingFrame.getWidth());
        this.croppingFrame.setHeight(mapart.croppingFrame.getHeight());
        return this;
    }

    public void setMapartSize(int width, int height) {
        if (this.reset) {
            this.width = width;
            this.height = height;
        }
    }

    public void reset() {
        this.reset = true;
    }

    public void reset(boolean isReset) {
        this.reset = isReset;
    }

    public boolean isReset() {
        return this.reset;
    }

    public MapColorCount[] getColorCounts() {
        MapColorCount[] countsSorted = new MapColorCount[63];
        for (int id = 1; id < 64; ++id) {
            countsSorted[id - 1] = new MapColorCount(id, this.colorsCounter.get(id));
        }
        Arrays.sort(countsSorted, Comparator.comparingInt(MapColorCount::amount).reversed());
        return countsSorted;
    }

    private boolean saveMapartImage(Path imagePath) {
        try {
            class_1043 mapartTexture = CurrentConversionSettings.guiMapartImage;
            if (mapartTexture == null || mapartTexture.method_4525() == null) {
                return false;
            }
            mapartTexture.method_4525().method_4314(imagePath);
        }
        catch (InvalidPathException e) {
            MapartHelper.LOGGER.error("Invalid path for saving the map:\n{}", (Object)e.toString());
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            MapartHelper.LOGGER.error("Error occurred while saving the image to \"{}\"", (Object)imagePath, (Object)e);
            throw new RuntimeException(e);
        }
        return true;
    }

    public void saveMapartImage(class_1657 player) {
        try {
            String filename = Utils.makeUniqueFilename(SAVED_MAPS_DIR, this.mapartName, "png");
            Path filepath = SAVED_MAPS_DIR.resolve(filename);
            if (this.saveMapartImage(filepath) && player != null) {
                class_5250 mapartFile = class_2561.method_43470((String)filename).method_27694(style -> style.method_10977(class_124.field_1060).method_10958((class_2558)new class_2558.class_10607(filepath.toFile())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"maparthelper.open_image_file"))).method_30938(Boolean.valueOf(true)));
                player.method_7353((class_2561)class_2561.method_43469((String)"maparthelper.mapart_saved", (Object[])new Object[]{mapartFile}).method_27692(class_124.field_1060), false);
            }
        }
        catch (InvalidPathException e) {
            player.method_7353((class_2561)class_2561.method_43471((String)"maparthelper.saving_path_error").method_27692(class_124.field_1061), false);
            MapartHelper.LOGGER.error("Invalid path for saving the map:\n{}", (Object)e.toString());
        }
        catch (Exception e) {
            player.method_7353((class_2561)class_2561.method_43471((String)"maparthelper.saving_error").method_27692(class_124.field_1061), false);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record MapColorCount(int id, int amount) {
    }
}

