/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.conversion.staircases;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rh.maparthelper.conversion.staircases.IMapartStaircase;

public class Waves3DStaircase
implements IMapartStaircase {
    @Override
    public List<List<Integer>> getStaircase(int[][] colors) {
        int z;
        int[][] brights = this.getBrightnesses(colors);
        int height = colors.length + 1;
        int width = colors[0].length;
        int[] negativeHeights = new int[width];
        ArrayList<List<Integer>> staircase = new ArrayList<List<Integer>>();
        for (z = 0; z < height; ++z) {
            ArrayList<Integer> row = new ArrayList<Integer>(Collections.nCopies(width, 0));
            staircase.add(row);
        }
        for (int x = 0; x < width; ++x) {
            for (int z2 = height - 2; z2 >= 0; --z2) {
                if (z2 > 0 && colors[z2 - 1][x] == 0) continue;
                int y = (Integer)((List)staircase.get(z2 + 1)).get(x) + Waves3DStaircase.getHeightAlt(brights, x, z2);
                ((List)staircase.get(z2)).set(x, y);
                negativeHeights[x] = Math.min(negativeHeights[x], y);
            }
        }
        for (z = 0; z < height; ++z) {
            for (int x = 0; x < width; ++x) {
                if (z == 0 && colors[z][x] == 0) {
                    ((List)staircase.get(z)).set(x, 0);
                    continue;
                }
                ((List)staircase.get(z)).set(x, (Integer)((List)staircase.get(z)).get(x) - negativeHeights[x]);
            }
        }
        return staircase;
    }

    private static int getHeightAlt(int[][] brights, int x, int z) {
        if (z == brights.length) {
            return 0;
        }
        int brightness = brights[z][x];
        if (brightness == 0) {
            return 1;
        }
        if (brightness == 2) {
            return -1;
        }
        return 0;
    }
}

