/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.minecraft.class_7528;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ScrollableGridWidget
extends class_7528
implements class_8133 {
    @Nullable
    private final class_364 parentWidget;
    public final InnerGridWidget grid;
    private final int scrollWidth;
    private int visibleTopY;
    private boolean needRelayout = false;
    protected boolean leftScroll = false;
    private int scrollBarColor = -3618616;

    public ScrollableGridWidget(@Nullable class_364 parentWidget, int x, int y, int width, int height, int scrollWidth) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.parentWidget = parentWidget;
        this.grid = new InnerGridWidget(x, y);
        this.scrollWidth = scrollWidth;
        this.visibleTopY = y;
    }

    public void setLeftScroll(boolean leftScroll) {
        this.leftScroll = leftScroll;
    }

    public void setScrollBarColor(int color) {
        this.scrollBarColor = color;
    }

    public void method_48227(Consumer<class_8021> consumer) {
    }

    public void method_48206(Consumer<class_339> consumer) {
    }

    public int method_25364() {
        return Math.min(this.field_22759, this.grid.method_25364());
    }

    public void method_48222() {
        this.grid.method_48222();
        super.method_48222();
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.needRelayout = true;
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.visibleTopY = y;
        this.needRelayout = true;
    }

    public Optional<class_8021> hoveredElement(double mouseX, double mouseY) {
        boolean onScroll;
        boolean bl = onScroll = this.method_44392() && mouseX >= (double)this.method_65507() && mouseX <= (double)(this.method_65507() + this.scrollWidth) && mouseY >= (double)this.method_46427() && mouseY < (double)this.method_55443();
        if (onScroll) {
            return Optional.of(this);
        }
        return this.grid.children.stream().filter(w -> {
            if (w instanceof class_339) {
                class_339 cw = (class_339)w;
                if (!cw.field_22763) return false;
                if (!cw.field_22764) return false;
            }
            if (!(mouseX >= (double)w.method_46426())) return false;
            if (!(mouseX < (double)(w.method_46426() + w.method_25368()))) return false;
            if (!(mouseY >= (double)w.method_46427())) return false;
            if (!(mouseY < (double)(w.method_46427() + w.method_25364()))) return false;
            return true;
        }).findFirst();
    }

    protected int method_44395() {
        return this.grid.method_25364();
    }

    protected double method_44393() {
        return 15.0;
    }

    public void method_44382(double scrollY) {
        super.method_44382(scrollY);
        this.grid.method_46419((int)((double)this.method_46427() - this.method_44387()));
        this.grid.method_48222();
    }

    protected int method_65507() {
        return this.leftScroll ? this.method_46426() : this.method_55442() - this.scrollWidth;
    }

    public boolean isOverScroll(double x, double y) {
        return this.method_44392() && x >= (double)this.method_65507() && x <= (double)(this.method_65507() + this.scrollWidth) && y >= (double)this.method_46427() && y < (double)this.method_55443();
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if ((this.parentWidget == null || this.parentWidget.method_25405(mouseX, mouseY)) && this.method_44392()) {
            return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return this.parentWidget != null && this.parentWidget.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        class_364 class_3642;
        if (this.needRelayout) {
            this.grid.method_46421(this.method_46426());
            this.grid.method_46419((int)((double)this.method_46427() - this.method_44387()));
            this.grid.method_48222();
            this.needRelayout = false;
        }
        if ((class_3642 = this.parentWidget) instanceof class_8021) {
            class_8021 w2 = (class_8021)class_3642;
            context.method_44379(this.method_46426(), Math.max(this.visibleTopY, w2.method_46427()), this.method_55442(), Math.min(this.visibleTopY + this.method_25364(), w2.method_46427() + w2.method_25364()));
        } else {
            context.method_44379(this.method_46426(), this.visibleTopY, this.method_55442(), this.visibleTopY + this.method_25364());
        }
        this.grid.method_48206(w -> w.method_25394(context, mouseX, mouseY, deltaTicks));
        this.method_44396(context);
        context.method_44380();
    }

    protected void method_44396(class_332 context) {
        if (this.method_44392()) {
            int i = this.method_65507();
            int j = this.method_44394();
            int k = this.method_65508();
            context.method_25294(i, this.method_46427(), i + this.scrollWidth, this.method_46427() + this.method_25364(), -11184811);
            context.method_25294(i, k, i + this.scrollWidth, k + j, this.scrollBarColor);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseY < (double)this.visibleTopY || mouseY > (double)(this.visibleTopY + this.method_25364()) || !this.method_25405(mouseX, mouseY)) {
            return false;
        }
        if (this.method_65505(mouseX, mouseY, button)) {
            return true;
        }
        for (class_8021 w : this.grid.children) {
            if (!(w instanceof class_339)) continue;
            class_339 child = (class_339)w;
            if (!child.field_22764 || !child.method_25405(mouseX, mouseY)) continue;
            class_437 currentScreen = class_310.method_1551().field_1755;
            if (currentScreen != null) {
                currentScreen.method_25395((class_364)child);
                currentScreen.method_25398(true);
            }
            return child.method_25402(mouseX, mouseY, button);
        }
        return true;
    }

    protected void method_47399(class_6382 builder) {
    }

    @Environment(value=EnvType.CLIENT)
    public static class InnerGridWidget
    extends class_7845 {
        private final List<class_8021> children = new ArrayList<class_8021>();

        public InnerGridWidget(int x, int y) {
            super(x, y);
        }

        public boolean isChild(class_8021 widget) {
            return this.children.contains(widget);
        }

        public <T extends class_8021> T method_46454(T widget, int row, int column, int occupiedRows, int occupiedColumns, class_7847 positioner) {
            if (widget instanceof class_8133) {
                class_8133 layoutWidget = (class_8133)widget;
                layoutWidget.method_48206(this.children::add);
            } else {
                this.children.add(widget);
            }
            return (T)super.method_46454(widget, row, column, occupiedRows, occupiedColumns, positioner);
        }
    }
}

