/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.command;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_3620;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5575;
import rh.maparthelper.MapartHelper;
import rh.maparthelper.command.ClientCommandsContext;
import rh.maparthelper.util.Utils;

@Environment(value=EnvType.CLIENT)
public class MapartToFile {
    private static final Path SAVE_MAPS_DIR = FabricLoader.getInstance().getGameDir().resolve("saved_maps");

    public static void initializeSavesDir() {
        try {
            if (Files.exists(SAVE_MAPS_DIR, new LinkOption[0])) {
                return;
            }
            Files.createDirectories(SAVE_MAPS_DIR, new FileAttribute[0]);
            MapartHelper.LOGGER.info("Created a directory for saved maps: \"{}\"", (Object)SAVE_MAPS_DIR);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveImageFromItemFramesArea(class_1657 player, class_1937 world, String filename) {
        class_243 pos1 = ClientCommandsContext.selectedPos1;
        class_243 pos2 = ClientCommandsContext.selectedPos2;
        int width = ClientCommandsContext.selectionWidth;
        int height = ClientCommandsContext.selectionHeight;
        int size = width * height;
        class_238 area = new class_238(pos1, pos2);
        List itemFrames = world.method_18023((class_5575)class_1299.field_6043, area, class_1533::method_43273);
        itemFrames.addAll(world.method_18023((class_5575)class_1299.field_28401, area, class_1533::method_43273));
        if (itemFrames.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"maparthelper.selection_has_no_maps").method_27692(class_124.field_1061), true);
            return;
        }
        if (itemFrames.size() != size) {
            player.method_7353((class_2561)class_2561.method_43471((String)"maparthelper.selection_has_empty_places").method_27692(class_124.field_1061), true);
            return;
        }
        itemFrames = itemFrames.stream().sorted((if1, if2) -> {
            int heightCompare;
            class_2338 p1 = if1.method_24515();
            class_2338 p2 = if2.method_24515();
            if (ClientCommandsContext.selectedDirection.method_10166() != class_2350.class_2351.field_11052 && (heightCompare = Integer.compare(p2.method_10264(), p1.method_10264())) != 0) {
                return heightCompare;
            }
            return switch (ClientCommandsContext.selectedDirection) {
                default -> throw new MatchException(null, null);
                case class_2350.field_11034 -> Integer.compare(p2.method_10260(), p1.method_10260());
                case class_2350.field_11039 -> Integer.compare(p1.method_10260(), p2.method_10260());
                case class_2350.field_11043 -> Integer.compare(p2.method_10263(), p1.method_10263());
                case class_2350.field_11035 -> Integer.compare(p1.method_10263(), p2.method_10263());
                case class_2350.field_11036, class_2350.field_11033 -> {
                    int zCompare = ClientCommandsContext.selectedDirection == class_2350.field_11033 ? Integer.compare(p2.method_10260(), p1.method_10260()) : Integer.compare(p1.method_10260(), p2.method_10260());
                    if (zCompare != 0) {
                        yield zCompare;
                    }
                    yield Integer.compare(p1.method_10263(), p2.method_10263());
                }
            };
        }).toList();
        int mapartWidth = width * 128;
        int mapartHeight = height * 128;
        try (class_1011 mapart = new class_1011(mapartWidth, mapartHeight, false);){
            for (int ind = 0; ind < itemFrames.size(); ++ind) {
                byte[] map;
                byte[] mapColors = MapartToFile.getMapColorsFromItemFrame((class_1533)itemFrames.get(ind));
                byte[] byArray = map = mapColors != null ? mapColors : new byte[16384];
                if (mapColors == null) {
                    Arrays.fill(map, (byte)0);
                }
                int mapX = ind % width;
                int mapY = ind / width;
                for (int j = 0; j < map.length; ++j) {
                    int localX = j % 128;
                    int localY = j / 128;
                    int resultX = mapX * 128 + localX;
                    int resultY = mapY * 128 + localY;
                    mapart.method_61941(resultX, resultY, class_3620.method_38480((int)map[j]));
                }
            }
            ClientCommandsContext.resetSelection();
            MapartToFile.saveMapartFile(player, filename, mapart);
        }
        catch (InvalidPathException e) {
            player.method_7353((class_2561)class_2561.method_43471((String)"maparthelper.saving_path_error").method_27692(class_124.field_1061), false);
            MapartHelper.LOGGER.error("Invalid path for saving the map:\n{}", (Object)e.toString());
        }
        catch (Exception e) {
            player.method_7353((class_2561)class_2561.method_43471((String)"maparthelper.saving_error").method_27692(class_124.field_1061), false);
            MapartHelper.LOGGER.error("An error occurred during saving the map:\n{}", (Object)e.toString());
        }
    }

    public static void saveImageFromMapColors(class_1657 player, byte[] mapColors, String filename) {
        try (class_1011 image = new class_1011(128, 128, false);){
            for (int i = 0; i < mapColors.length; ++i) {
                image.method_61941(i % 128, i / 128, class_3620.method_38480((int)mapColors[i]));
            }
            MapartToFile.saveMapartFile(player, filename, image);
        }
        catch (Exception e) {
            MapartHelper.LOGGER.error("An error occurred during saving the map:\n{}", (Object)e.toString());
            throw new RuntimeException(e);
        }
    }

    private static void saveMapartFile(class_1657 player, String filename, class_1011 image) throws IOException {
        filename = Utils.makeUniqueFilename(SAVE_MAPS_DIR, filename, "png");
        Path filePath = SAVE_MAPS_DIR.resolve(filename);
        image.method_4314(filePath);
        class_5250 mapartFile = class_2561.method_43470((String)filename).method_27694(style -> style.method_10977(class_124.field_1060).method_10958((class_2558)new class_2558.class_10607(filePath.toAbsolutePath().toString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"maparthelper.open_image_file"))).method_30938(Boolean.valueOf(true)));
        player.method_7353((class_2561)class_2561.method_43469((String)"maparthelper.mapart_saved", (Object[])new Object[]{mapartFile}).method_27692(class_124.field_1060), false);
    }

    public static void saveImageFromMapColors(class_1657 player, byte[] mapColors) {
        MapartToFile.saveImageFromMapColors(player, mapColors, "New map");
    }

    public static byte[] getMapColorsFromItemFrame(class_1533 itemFrame) {
        if (!itemFrame.method_43273()) {
            return null;
        }
        class_22 mapState = class_1806.method_8001((class_1799)itemFrame.method_6940(), (class_1937)itemFrame.method_73183());
        assert (mapState != null);
        return MapartToFile.rotateMap((byte[])mapState.field_122.clone(), itemFrame.method_6934());
    }

    public static byte[] getMapColorsFromItemFrame() {
        class_239 target = class_310.method_1551().field_1765;
        if (!(target instanceof class_3966)) {
            return null;
        }
        class_3966 entity = (class_3966)target;
        class_1297 class_12972 = entity.method_17782();
        if (class_12972 instanceof class_1533) {
            class_1533 itemFrame = (class_1533)class_12972;
            if (!itemFrame.method_43273()) {
                return null;
            }
            class_22 mapState = class_1806.method_8001((class_1799)itemFrame.method_6940(), (class_1937)itemFrame.method_73183());
            assert (mapState != null);
            return MapartToFile.rotateMap((byte[])mapState.field_122.clone(), itemFrame.method_6934());
        }
        return null;
    }

    private static byte[] rotateMap(byte[] input, int rotation) {
        byte[] output = new byte[16384];
        for (int y = 0; y < 128; ++y) {
            for (int x = 0; x < 128; ++x) {
                int fromIndex = y * 128 + x;
                switch (rotation % 4) {
                    case 0: {
                        int toIndex = y * 128 + x;
                        break;
                    }
                    case 1: {
                        int toIndex = x * 128 + (127 - y);
                        break;
                    }
                    case 2: {
                        int toIndex = (127 - y) * 128 + (127 - x);
                        break;
                    }
                    case 3: {
                        int toIndex = (127 - x) * 128 + y;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid rotation");
                    }
                }
                output[toIndex] = input[fromIndex];
            }
        }
        return output;
    }
}

