/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.conversion;

import com.google.common.util.concurrent.AtomicDouble;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_3620;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import rh.maparthelper.MapartHelper;
import rh.maparthelper.colors.ColorUtils;
import rh.maparthelper.colors.MapColorEntry;
import rh.maparthelper.config.palette.PaletteColors;
import rh.maparthelper.config.palette.PaletteConfigManager;
import rh.maparthelper.conversion.CroppingMode;
import rh.maparthelper.conversion.CurrentConversionSettings;
import rh.maparthelper.conversion.ImageChangeResult;
import rh.maparthelper.conversion.MapartImageResizer;
import rh.maparthelper.conversion.MapartImageUpdater;
import rh.maparthelper.conversion.NativeImageUtils;
import rh.maparthelper.conversion.dithering.DitheringAlgorithms;
import rh.maparthelper.conversion.mapart.ColorsCounter;
import rh.maparthelper.conversion.mapart.ConvertedMapartImage;
import rh.maparthelper.conversion.mapart.ProcessingMapartImage;
import rh.maparthelper.gui.MapartEditorScreen;

@Environment(value=EnvType.CLIENT)
public class MapartImageConverter {
    private static volatile AtomicDouble conversionProgress = new AtomicDouble(0.0);
    private static final ExecutorService convertingExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Mapart Helper/Image Converter").build());
    private static Future<?> currentConvertingFuture;

    public static void readAndUpdateMapartImage(ConvertedMapartImage updatingMapart, ProcessingMapartImage processingMapart, Path path, ImageChangeResult imageChangeResult) {
        FutureTask<Void> future = MapartImageConverter.getVoidFutureTask(updatingMapart, processingMapart, path, imageChangeResult);
        if (currentConvertingFuture != null) {
            currentConvertingFuture.cancel(true);
        }
        currentConvertingFuture = convertingExecutor.submit(future);
    }

    @NotNull
    private static FutureTask<Void> getVoidFutureTask(ConvertedMapartImage updatingMapart, ProcessingMapartImage processingMapart, Path path, ImageChangeResult imageChangeResult) {
        boolean logExecutionTime = MapartHelper.commonConfig.mapartEditor.logConversionTime;
        FutureTask<Object> future = !updatingMapart.isReset() && path.equals(processingMapart.getImagePath()) ? new FutureTask<Object>(new ConvertImageFileRunnable(updatingMapart, processingMapart, null, logExecutionTime, imageChangeResult), null) : new FutureTask<Object>(new ConvertImageFileRunnable(updatingMapart, processingMapart, path, logExecutionTime, imageChangeResult), null);
        return future;
    }

    public static boolean isConverting() {
        double d = conversionProgress.get();
        return d > 0.0 && d < 1.0;
    }

    public static double getConversionProgress() {
        return conversionProgress.get();
    }

    private static BufferedImage preprocessImage(BufferedImage image) {
        float brightness = CurrentConversionSettings.brightness;
        float contrast = CurrentConversionSettings.contrast;
        float saturation = CurrentConversionSettings.saturation;
        return ColorUtils.preprocessImage(image, brightness, contrast, saturation);
    }

    private static void convertToBlocksPalette(BufferedImage image, MapColorEntry bgColor, boolean use3D, ColorsCounter colorsCounter) {
        boolean useDithering;
        int width = image.getWidth();
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        double progressStep = 1.0 / (double)pixels.length;
        int[] errorsArray = new int[]{};
        DitheringAlgorithms ditherAlg = MapartHelper.conversionSettings.ditheringAlgorithm;
        boolean bl = useDithering = ditherAlg != DitheringAlgorithms.NONE;
        if (useDithering) {
            errorsArray = new int[ditherAlg.rowsNumber * width * 3];
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < width; ++x) {
                MapColorEntry color;
                if (Thread.currentThread().isInterrupted()) {
                    PaletteColors.clearColorCache();
                    colorsCounter.clear();
                    return;
                }
                int argb = pixels[x + y * width];
                if (argb == 0 && bgColor == MapColorEntry.CLEAR) continue;
                if (useDithering) {
                    int ind = x * 3;
                    int[] argb0 = ColorUtils.getARGB(argb);
                    argb0[1] = Math.clamp((long)(argb0[1] + errorsArray[ind]), 0, 255);
                    argb0[2] = Math.clamp((long)(argb0[2] + errorsArray[ind + 1]), 0, 255);
                    argb0[3] = Math.clamp((long)(argb0[3] + errorsArray[ind + 2]), 0, 255);
                    argb = ColorUtils.getARGB(argb0);
                }
                if ((color = PaletteColors.getClosestColor(argb, use3D, useDithering)) == MapColorEntry.CLEAR) {
                    color = bgColor;
                }
                if (useDithering && color != MapColorEntry.CLEAR) {
                    ditherAlg.spreadDiffusionError(errorsArray, width, x, color.distError());
                }
                int newArgb = y > 0 && pixels[x + (y - 1) * width] == 0 ? color.mapColor().method_15820(class_3620.class_6594.field_34761) : (use3D ? color.getRenderColor() : color.mapColor().method_15820(class_3620.class_6594.field_34760));
                pixels[x + y * width] = newArgb;
                if (color != MapColorEntry.CLEAR) {
                    colorsCounter.increment(color.mapColor().field_16021);
                }
                conversionProgress.addAndGet(progressStep);
            }
            if (!useDithering) continue;
            for (int row = 1; row < ditherAlg.rowsNumber; ++row) {
                System.arraycopy(errorsArray, row * width * 3, errorsArray, (row - 1) * width * 3, width * 3);
            }
            Arrays.fill(errorsArray, (ditherAlg.rowsNumber - 1) * width * 3, ditherAlg.rowsNumber * width * 3, 0);
        }
        conversionProgress.set(1.0);
        PaletteColors.clearColorCache();
    }

    private static BufferedImage cropAndScaleToMapSize(ProcessingMapartImage mapart, boolean rescale) {
        BufferedImage bufferedImage;
        int mapartWidth = mapart.getWidth() * 128;
        int mapartHeight = mapart.getHeight() * 128;
        if (!rescale) {
            return MapartImageResizer.placeOnMapartCanvas(mapart, mapartWidth, mapartHeight);
        }
        switch (CurrentConversionSettings.cropMode) {
            default: {
                throw new MatchException(null, null);
            }
            case NO_CROP: {
                bufferedImage = MapartImageResizer.scaleImage(mapart, mapartWidth, mapartHeight);
                break;
            }
            case AUTO_CROP: 
            case FIT: {
                if (CurrentConversionSettings.cropMode == CroppingMode.FIT) {
                    mapart.fitOriginalCroppingFrame();
                } else {
                    mapart.autoCropOriginalImage();
                }
            }
            case USER_CROP: {
                bufferedImage = MapartImageResizer.adjustToMapartSize(mapart);
            }
        }
        return bufferedImage;
    }

    @Environment(value=EnvType.CLIENT)
    private static class ConvertImageFileRunnable
    implements Runnable {
        private final ConvertedMapartImage updatingMapart;
        private final ProcessingMapartImage mapart;
        private final Path newImagePath;
        private final boolean logExecutionTime;
        private final ImageChangeResult imageChangeResult;

        public ConvertImageFileRunnable(ConvertedMapartImage updatingMapart, ProcessingMapartImage mapart, Path path, boolean logExecutionTime, ImageChangeResult imageChangeResult) {
            this.updatingMapart = updatingMapart;
            this.mapart = mapart;
            this.newImagePath = path;
            this.logExecutionTime = logExecutionTime;
            this.imageChangeResult = imageChangeResult;
        }

        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                conversionProgress = new AtomicDouble(0.0);
                boolean showOriginalImage = MapartHelper.conversionSettings.showOriginalImage;
                MapColorEntry bgColor = MapartHelper.conversionSettings.backgroundColor;
                if (this.newImagePath != null) {
                    this.mapart.setImagePath(null);
                    this.mapart.setOriginal(ImageIO.read(this.newImagePath.toFile()));
                    this.mapart.setImagePath(this.newImagePath);
                    this.mapart.autoCropOriginalImage();
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                boolean needReconvertingColors = this.imageChangeResult != ImageChangeResult.SIMPLE && (this.imageChangeResult == ImageChangeResult.NEED_RESCALE || bgColor == MapColorEntry.CLEAR && !showOriginalImage);
                BufferedImage bufferedImage = MapartImageConverter.cropAndScaleToMapSize(this.mapart, needReconvertingColors);
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (this.imageChangeResult != ImageChangeResult.SIMPLE) {
                    if (needReconvertingColors) {
                        bufferedImage = MapartImageConverter.preprocessImage(bufferedImage);
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    PaletteColors.clearColorCache();
                    this.mapart.getColorsCounter().clear();
                    if (!showOriginalImage) {
                        if (PaletteConfigManager.presetsConfig.getCurrentPresetColors().isEmpty()) {
                            bufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
                        } else {
                            MapartImageConverter.convertToBlocksPalette(bufferedImage, bgColor, MapartHelper.conversionSettings.use3D(), this.mapart.getColorsCounter());
                        }
                    }
                    if (CurrentConversionSettings.cropMode == CroppingMode.USER_CROP) {
                        this.mapart.setScaledImage(bufferedImage.getSubimage(this.mapart.getInsertionX(), this.mapart.getInsertionY(), this.mapart.getScaledImage().getWidth(), this.mapart.getScaledImage().getHeight()));
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                }
                this.mapart.setNativeImage(NativeImageUtils.convertBufferedImageToNativeImage(bufferedImage, bgColor, CurrentConversionSettings.doShowTransparent));
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                ConvertedMapartImage result = this.mapart.release(this.updatingMapart);
                class_310.method_1551().execute(() -> NativeImageUtils.updateMapartImageTexture(result.getNativeImage()));
                MapartImageUpdater.scale = 0.0;
                MapartImageUpdater.moveDx = 0.0;
                MapartImageUpdater.moveDy = 0.0;
                if (this.logExecutionTime) {
                    double timeLeft = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                    MapartHelper.LOGGER.info("Image preprocessing and conversion took {} seconds", (Object)timeLeft);
                }
            }
            catch (Exception e) {
                CurrentConversionSettings.resetMapart();
                MapartHelper.LOGGER.error("Error occurred while reading and converting an image: ", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                class_310.method_1551().execute(() -> {
                    class_437 patt0$temp = class_310.method_1551().field_1755;
                    if (patt0$temp instanceof MapartEditorScreen) {
                        MapartEditorScreen editorScreen = (MapartEditorScreen)patt0$temp;
                        editorScreen.updateMaterialList();
                        editorScreen.updateMapartOutputButtons();
                    }
                });
            }
        }
    }
}

