/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.conversion;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_310;
import rh.maparthelper.colors.MapColorEntry;
import rh.maparthelper.conversion.CurrentConversionSettings;
import rh.maparthelper.conversion.mapart.ConvertedMapartImage;

@Environment(value=EnvType.CLIENT)
public class NativeImageUtils {
    public static synchronized void updateMapartImageTexture(class_1011 image) {
        class_1043 backedTexture = new class_1043(() -> "mapart_gui_texture", image);
        class_1060 textureManager = class_310.method_1551().method_1531();
        textureManager.method_4616(CurrentConversionSettings.guiMapartId, (class_1044)backedTexture);
        CurrentConversionSettings.guiMapartImage = backedTexture;
    }

    public static int[][] divideMapartByMaps(ConvertedMapartImage mapart) {
        if (CurrentConversionSettings.guiMapartImage == null || CurrentConversionSettings.guiMapartImage.method_4525() == null) {
            return null;
        }
        int width = mapart.getWidth();
        int height = mapart.getHeight();
        int imageWidth = width * 128;
        int[] pixels = mapart.getNativeImage().method_61942();
        int[][] maps = new int[width * height][];
        for (int i = 0; i < maps.length; ++i) {
            maps[i] = new int[16384];
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int i = 0; i < 128; ++i) {
                    int rowStart = x * 128 + (y * 128 + i) * imageWidth;
                    System.arraycopy(pixels, rowStart, maps[x + y * width], i * 128, 128);
                }
            }
        }
        return maps;
    }

    public static class_1011 convertBufferedImageToNativeImage(BufferedImage image, MapColorEntry bgColor, boolean useTransparent) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        class_1011 nativeImage = new class_1011(width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = pixels[x + y * width];
                if (useTransparent ? argb == 0 : (argb >> 24 & 0xFF) < 80) {
                    nativeImage.method_61941(x, y, bgColor.getRenderColor());
                } else {
                    nativeImage.method_61941(x, y, useTransparent ? argb : argb | 0xFF000000);
                }
                if (useTransparent) {
                    if (argb == 0) continue;
                    nativeImage.method_61941(x, y, argb);
                    continue;
                }
                if ((argb >> 24 & 0xFF) < 80) {
                    nativeImage.method_61941(x, y, bgColor.getRenderColor());
                    continue;
                }
                nativeImage.method_61941(x, y, argb | 0xFF000000);
            }
        }
        return nativeImage;
    }
}

