/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.conversion.schematic;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import rh.maparthelper.MapartHelper;
import rh.maparthelper.conversion.CurrentConversionSettings;
import rh.maparthelper.conversion.NativeImageUtils;
import rh.maparthelper.conversion.schematic.NbtSchematicUtils;
import rh.maparthelper.util.Utils;

@Environment(value=EnvType.CLIENT)
public class MapartToNBT {
    private static final Path SCHEMATICS = FabricLoader.getInstance().getGameDir().resolve("schematics");
    private static final ExecutorService nbtBuilderExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Mapart Helper/Schematic").build());

    private static void saveNBT(boolean asSingleFile, ZipOutputStream zipOut, File zipFile) {
        assert (CurrentConversionSettings.guiMapartImage.method_4525() != null);
        try {
            if (!Files.exists(SCHEMATICS, new LinkOption[0])) {
                Files.createDirectory(SCHEMATICS, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            MapartHelper.LOGGER.error("Failed to write schematics directory", (Throwable)e);
        }
        Object maps = asSingleFile ? (Object)new int[][]{CurrentConversionSettings.guiMapartImage.method_4525().method_61942()} : NativeImageUtils.divideMapartByMaps(CurrentConversionSettings.mapart);
        assert (maps != null);
        for (int i = 0; i < ((int[][])maps).length; ++i) {
            class_2487 mapartNbt;
            Object filename = CurrentConversionSettings.mapart.mapartName;
            if (asSingleFile) {
                mapartNbt = NbtSchematicUtils.createMapartNbt();
            } else {
                mapartNbt = NbtSchematicUtils.createMapartNbt(maps[i], 1, 1);
                filename = (String)filename + " (" + i % CurrentConversionSettings.getMapartWidth() + "_" + i / CurrentConversionSettings.getMapartWidth() + ")";
            }
            String writeFilename = Utils.makeUniqueFilename(SCHEMATICS, (String)filename, "nbt");
            try {
                if (zipOut == null) {
                    class_2507.method_30614((class_2487)mapartNbt, (Path)SCHEMATICS.resolve(writeFilename));
                    continue;
                }
                ZipEntry zipEntry = new ZipEntry((String)filename + ".nbt");
                zipOut.putNextEntry(zipEntry);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                class_2507.method_10634((class_2487)mapartNbt, (OutputStream)out);
                out.writeTo(zipOut);
                continue;
            }
            catch (IOException e) {
                MapartHelper.LOGGER.error("An error occurred during saving NBT file", (Throwable)e);
                return;
            }
        }
        String mapartName = CurrentConversionSettings.mapart.mapartName;
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            class_5250 openFile = zipOut == null ? class_2561.method_43470((String)"schematics").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10607(SCHEMATICS)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"maparthelper.open_folder"))).method_30938(Boolean.valueOf(true))) : class_2561.method_43470((String)zipFile.getName()).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10607(zipFile)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"maparthelper.open_file"))).method_30938(Boolean.valueOf(true)));
            class_5250 message = asSingleFile ? class_2561.method_43469((String)"maparthelper.nbt_file_saved", (Object[])new Object[]{mapartName, openFile}) : (zipOut == null ? class_2561.method_43469((String)"maparthelper.nbt_files_saved", (Object[])new Object[]{((int[][])maps).length, mapartName, openFile}) : class_2561.method_43469((String)"maparthelper.nbt_zip_saved", (Object[])new Object[]{((int[][])maps).length, mapartName, openFile}));
            player.method_7353((class_2561)message.method_27692(class_124.field_1060), false);
        }
        MapartHelper.LOGGER.info("{} NBT file(s) for \"{}\" successfully saved", (Object)((int[][])maps).length, (Object)mapartName);
    }

    public static void saveNBT(boolean asSingleFile) {
        if (CurrentConversionSettings.guiMapartImage == null) {
            return;
        }
        nbtBuilderExecutor.execute(() -> MapartToNBT.saveNBT(asSingleFile, null, null));
    }

    public static void saveNBTAsZip() {
        if (CurrentConversionSettings.guiMapartImage == null) {
            return;
        }
        String filename = Utils.makeUniqueFilename(SCHEMATICS, CurrentConversionSettings.mapart.mapartName, "zip");
        File fileToZip = SCHEMATICS.resolve(filename).toFile();
        nbtBuilderExecutor.execute(() -> {
            try (FileOutputStream fos = new FileOutputStream(fileToZip);
                 ZipOutputStream zipOut = new ZipOutputStream(fos);){
                MapartToNBT.saveNBT(false, zipOut, fileToZip);
            }
            catch (IOException e) {
                MapartHelper.LOGGER.error("An error occurred during saving zip", (Throwable)e);
            }
        });
    }
}

