/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.conversion.schematic;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3620;
import net.minecraft.class_4538;
import rh.maparthelper.MapartHelper;
import rh.maparthelper.config.UseAuxBlocks;
import rh.maparthelper.config.palette.PaletteColors;
import rh.maparthelper.config.palette.PaletteConfigManager;
import rh.maparthelper.config.palette.PaletteGenerator;
import rh.maparthelper.conversion.CurrentConversionSettings;
import rh.maparthelper.conversion.schematic.DummyWorldView;
import rh.maparthelper.conversion.staircases.StaircaseStyles;

@Environment(value=EnvType.CLIENT)
public class NbtSchematicUtils {
    private static final List<class_2248> blocks_list = new ArrayList<class_2248>();

    private static int getBlockMaterialId(class_2248 block) {
        int ind = blocks_list.indexOf(block);
        if (ind != -1) {
            return ind;
        }
        blocks_list.add(block);
        return blocks_list.size() - 1;
    }

    private static class_2487 createMapartBaseNbt() {
        class_2487 nbt = new class_2487();
        String author = class_310.method_1551().method_1548().method_1676() + " // by Mapart Helper";
        nbt.method_10582("author", author);
        class_2512.method_48310((class_2487)nbt);
        return nbt;
    }

    private static void addSizeToNbt(class_2487 nbt, int x, int y, int z) {
        class_2499 size = new class_2499();
        size.add((Object)class_2497.method_23247((int)x));
        size.add((Object)class_2497.method_23247((int)y));
        size.add((Object)class_2497.method_23247((int)z));
        nbt.method_10566("size", (class_2520)size);
    }

    private static void addPaletteToNbt(class_2487 nbt) {
        class_2499 palette = new class_2499();
        for (class_2248 block : blocks_list) {
            class_2680 blockState = PaletteGenerator.getDefaultPaletteState(block);
            class_2487 blockEntry = class_2512.method_10686((class_2680)blockState);
            palette.add((Object)blockEntry);
        }
        nbt.method_10566("palette", (class_2520)palette);
    }

    protected static void addBlockToNbt(class_2487 nbt, int x, int y, int z, class_2248 block) {
        class_2499 blocks = nbt.method_10545("blocks") ? Objects.requireNonNull(nbt.method_10580("blocks")).method_68592().orElse(new class_2499()) : new class_2499();
        class_2487 entry = new class_2487();
        class_2499 pos = new class_2499();
        pos.add((Object)class_2497.method_23247((int)x));
        pos.add((Object)class_2497.method_23247((int)y));
        pos.add((Object)class_2497.method_23247((int)z));
        entry.method_10566("pos", (class_2520)pos);
        int blockId = NbtSchematicUtils.getBlockMaterialId(block);
        entry.method_10566("state", (class_2520)class_2497.method_23247((int)blockId));
        blocks.add((Object)entry);
        nbt.method_10566("blocks", (class_2520)blocks);
    }

    protected static void addColorToNbt(class_2487 nbt, int x, int y, int z, class_3620 color) {
        class_2248 block = PaletteConfigManager.presetsConfig.getBlockOfMapColor(color);
        NbtSchematicUtils.addBlockToNbt(nbt, x, y, z, block);
        if (y == 0) {
            return;
        }
        if (NbtSchematicUtils.needsAuxBlock(block)) {
            NbtSchematicUtils.addBlockToNbt(nbt, x, y - 1, z, MapartHelper.conversionSettings.auxBlock);
        }
    }

    protected static class_2487 createMapartNbt(int[] map, int mapsWidth, int mapsHeight) {
        blocks_list.clear();
        class_2487 nbt = NbtSchematicUtils.createMapartBaseNbt();
        int width = mapsWidth * 128;
        int height = mapsHeight * 128;
        int[][] colors = new int[height][width];
        for (int y = 0; y < height; ++y) {
            System.arraycopy(map, y * width, colors[y], 0, width);
        }
        StaircaseStyles staircase = MapartHelper.conversionSettings.staircaseStyle;
        if (staircase == StaircaseStyles.FLAT_2D) {
            for (int x = 0; x < width; ++x) {
                NbtSchematicUtils.addBlockToNbt(nbt, x, 0, 0, MapartHelper.conversionSettings.auxBlock);
            }
            for (int z = 1; z < height + 1; ++z) {
                for (int x = 0; x < width; ++x) {
                    class_3620 color = PaletteColors.getMapColorEntryByARGB(colors[z - 1][x]).mapColor();
                    if (color == class_3620.field_16008) continue;
                    NbtSchematicUtils.addColorToNbt(nbt, x, 0, z, color);
                }
            }
            NbtSchematicUtils.addSizeToNbt(nbt, width, 1, height + 1);
        } else {
            int maxHeight = 1;
            List<List<Integer>> converted = staircase.getStaircase(colors);
            for (int x = 0; x < converted.getFirst().size(); ++x) {
                int y = converted.getFirst().get(x);
                maxHeight = Math.max(y, maxHeight);
                NbtSchematicUtils.addBlockToNbt(nbt, x, y, 0, MapartHelper.conversionSettings.auxBlock);
            }
            for (int z = 1; z < converted.size(); ++z) {
                for (int x = 0; x < converted.getFirst().size(); ++x) {
                    int y = converted.get(z).get(x);
                    maxHeight = Math.max(y, maxHeight);
                    class_3620 color = PaletteColors.getMapColorEntryByARGB(colors[z - 1][x]).mapColor();
                    if (color == class_3620.field_16008) continue;
                    NbtSchematicUtils.addColorToNbt(nbt, x, y, z, color);
                }
            }
            NbtSchematicUtils.addSizeToNbt(nbt, width, maxHeight + 1, height + 1);
        }
        NbtSchematicUtils.addPaletteToNbt(nbt);
        return nbt;
    }

    protected static class_2487 createMapartNbt() {
        int mapsWidth = CurrentConversionSettings.getMapartWidth();
        int mapsHeight = CurrentConversionSettings.getMapartHeight();
        if (CurrentConversionSettings.guiMapartImage.method_4525() != null) {
            return NbtSchematicUtils.createMapartNbt(CurrentConversionSettings.guiMapartImage.method_4525().method_61942(), mapsWidth, mapsHeight);
        }
        return NbtSchematicUtils.createMapartBaseNbt();
    }

    public static boolean needsAuxBlock(class_2248 block) {
        if (MapartHelper.conversionSettings.useAuxBlocks == UseAuxBlocks.NO_AUX) {
            return false;
        }
        boolean canPlaceAtAir = block.method_9564().method_26184((class_4538)DummyWorldView.getInstance(), class_2338.field_10980);
        boolean hasNoCollision = block.method_9564().method_26220(null, null) == class_259.method_1073();
        return !canPlaceAtAir || block instanceof class_2346 || hasNoCollision;
    }
}

