/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.gui;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3620;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7842;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import org.joml.Matrix3x2fStack;
import rh.maparthelper.config.palette.PaletteConfigManager;
import rh.maparthelper.config.palette.PalettePresetsConfig;
import rh.maparthelper.conversion.MapartImageUpdater;
import rh.maparthelper.gui.MapartEditorScreen;
import rh.maparthelper.gui.ScreenAdapted;
import rh.maparthelper.gui.widget.BlockItemWidget;
import rh.maparthelper.gui.widget.MapColorWidget;
import rh.maparthelper.gui.widget.PresetsDropdownMenuWidget;
import rh.maparthelper.gui.widget.ScrollableGridWidget;
import rh.maparthelper.util.RenderUtils;

@Environment(value=EnvType.CLIENT)
public class PresetsEditorScreen
extends ScreenAdapted {
    private final MapartEditorScreen parent;
    private final int boxX;
    private final int boxY;
    private final int marginRight;
    private final int marginBottom;
    private int boxWidth;
    private int boxHeight;
    private PalettePresetsConfig.Editable presetsConfig = PaletteConfigManager.presetsConfig.getEditable();
    private String editingPreset = this.presetsConfig.getCurrentPresetFilename();
    private final Set<String> deletedPresets = new HashSet<String>();
    private final Set<String> updatedPresets = new HashSet<String>();
    private PresetsDropdownMenuWidget presetsListDropdown;
    private class_342 presetNameField;
    private ScrollableGridWidget colorsEditor;

    protected PresetsEditorScreen(MapartEditorScreen parent, int x, int y, int marginRight, int marginBottom) {
        super((class_2561)class_2561.method_43471((String)"maparthelper.gui.presets_editor_screen"));
        this.parent = parent;
        this.boxX = x;
        this.boxY = y;
        this.marginRight = marginRight;
        this.marginBottom = marginBottom;
    }

    @Override
    protected void method_25426() {
        class_3620 mapColor;
        this.parent.field_22789 = this.field_22789;
        this.parent.field_22790 = this.field_22790;
        this.parent.method_37067();
        this.parent.method_25426();
        this.boxWidth = this.parent.field_22789 - this.boxX - this.marginRight;
        this.boxHeight = this.parent.field_22790 - this.boxY - this.marginBottom;
        class_8667 presetBarLeft = class_8667.method_52742();
        presetBarLeft.method_48229(this.boxX + 5, this.boxY + 5);
        class_7847 presetBarLeftPositioner = presetBarLeft.method_52740().method_46474();
        class_7842 presetNameLabel = new class_7842((class_2561)class_2561.method_43471((String)"maparthelper.gui.preset"), this.field_22793);
        presetBarLeft.method_52737((class_8021)presetNameLabel, presetBarLeftPositioner.method_46478().method_46473(5));
        this.presetNameField = new class_342(this.field_22793, (int)((double)this.boxWidth * 0.35), 20, (class_2561)class_2561.method_43473());
        this.presetNameField.method_1852((String)this.presetsConfig.presetFiles.get(this.editingPreset));
        presetBarLeft.method_52736((class_8021)this.presetNameField);
        this.presetsListDropdown = new PresetsDropdownMenuWidget(this, 0, 0, 20, 20, this.presetNameField.method_25368() + 20, class_2561.method_30163((String)"\u2630"));
        this.presetsListDropdown.setMenuXOffset(-this.presetNameField.method_25368());
        this.presetsListDropdown.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"maparthelper.gui.presets.choose_preset")));
        this.presetsListDropdown.addEntries(this::changeEditingPreset, this.presetsConfig.presetFiles);
        presetBarLeft.method_52736((class_8021)this.presetsListDropdown);
        this.presetNameField.method_1863(value -> {
            if (value.isBlank()) {
                this.presetNameField.method_1887(class_2561.method_43471((String)"maparthelper.gui.presets.preset_name").getString());
                return;
            }
            this.presetNameField.method_1887(null);
            this.presetsConfig.presetFiles.put(this.editingPreset, value);
            if (this.presetsListDropdown != null) {
                this.presetsListDropdown.updateNames(this.presetsConfig.presetFiles.values());
            }
        });
        class_4185 createEmptyPreset = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\ud83d\uddcb"), b -> this.createNewPreset(false)).method_46437(17, 20).method_46431();
        createEmptyPreset.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"maparthelper.gui.presets.createEmptyPreset_tooltip")));
        presetBarLeft.method_52736((class_8021)createEmptyPreset);
        class_4185 createDefaultPreset = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u2795"), b -> this.createNewPreset(true)).method_46437(17, 20).method_46431();
        createDefaultPreset.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"maparthelper.gui.presets.createDefaultPreset_tooltip")));
        presetBarLeft.method_52736((class_8021)createDefaultPreset);
        class_4185 duplicatePreset = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\ud83d\uddd0"), b -> this.duplicatePreset()).method_46437(17, 20).method_46431();
        duplicatePreset.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"maparthelper.gui.presets.duplicatePreset_tooltip")));
        presetBarLeft.method_52736((class_8021)duplicatePreset);
        class_4185 deletePreset = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\ud83d\uddd1"), b -> this.deletePreset()).method_46437(17, 20).method_46431();
        deletePreset.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"maparthelper.gui.presets.deletePreset_tooltip")));
        presetBarLeft.method_52736((class_8021)deletePreset);
        presetBarLeft.method_48222();
        presetBarLeft.method_48206(this::method_37063);
        class_8667 presetBarRight = class_8667.method_52742();
        presetBarRight.method_48229(0, this.boxY + 5);
        presetBarRight.method_52740().method_46474().method_46473(1);
        class_4185 updateFiles = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u27f2").method_27692(class_124.field_1067), b -> this.updateFiles()).method_46437(18, 20).method_46431();
        updateFiles.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"maparthelper.gui.presets.updateFiles_tooltip")));
        presetBarRight.method_52736((class_8021)updateFiles);
        class_4185 save = class_4185.method_46430((class_2561)class_2561.method_43471((String)"maparthelper.gui.save"), b -> this.saveChanges()).method_46437(60, 20).method_46431();
        presetBarRight.method_52736((class_8021)save);
        class_4185 close = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u274c"), b -> this.method_25419()).method_46437(20, 20).method_46431();
        presetBarRight.method_52736((class_8021)close);
        presetBarRight.method_48222();
        presetBarRight.method_46421(this.boxX + this.boxWidth - presetBarRight.method_25368());
        presetBarRight.method_48206(this::method_37063);
        int squareSize = 24;
        int columns = (this.boxWidth - 5) / (squareSize + 5);
        this.colorsEditor = new ScrollableGridWidget(null, this.boxX, this.boxY + 31, this.boxWidth, this.boxHeight - 31, 6);
        ScrollableGridWidget.InnerGridWidget colorsGrid = this.colorsEditor.grid;
        colorsGrid.method_46453((class_8021)class_7852.method_46512((int)(this.boxWidth - 11)), 0, 0, 1, columns);
        colorsGrid.method_46458().method_46467().method_46466(0, 4, 0, 0);
        for (int i = 0; i < 63 && (mapColor = class_3620.method_38479((int)(i + 1))) != class_3620.field_16008; ++i) {
            MapColorWidget color = new MapColorWidget(0, 0, squareSize, squareSize, mapColor, false);
            color.showColorName(true);
            int row = 2 * columns * (i / columns);
            if (row == 0) {
                colorsGrid.method_46452((class_8021)color, row, i % columns);
            } else {
                colorsGrid.method_46455((class_8021)color, row, i % columns, colorsGrid.method_46457().method_46471(10));
            }
            ScrollableGridWidget blocksList = new ScrollableGridWidget((class_364)this.colorsEditor, 0, 0, squareSize + 5, 150, 3);
            blocksList.grid.method_46458().method_46467().method_46474();
            class_7845.class_7939 adder = blocksList.grid.method_47610(1);
            adder.method_47612((class_8021)class_7852.method_46512((int)blocksList.method_25368()));
            MapColorBlockWidget noneBlock = new MapColorBlockWidget(0, 0, squareSize, class_2246.field_10499, mapColor, (click, doubled) -> {
                this.presetsConfig.getPreset(this.editingPreset).removeColor(mapColor);
                this.updatedPresets.add(this.editingPreset);
            });
            noneBlock.setTooltip((class_2561)class_2561.method_43471((String)"maparthelper.gui.presets.remove_color"));
            adder.method_47615((class_8021)noneBlock, blocksList.grid.method_46457().method_46467());
            List<class_2248> blocks = PaletteConfigManager.completePalette.palette.get(mapColor.field_16021);
            if (blocks != null) {
                for (class_2248 block : blocks) {
                    MapColorBlockWidget blockWidget = new MapColorBlockWidget(0, 0, squareSize, block, mapColor, (click, doubled) -> {
                        this.presetsConfig.getPreset(this.editingPreset).updateColor(mapColor, block);
                        this.updatedPresets.add(this.editingPreset);
                    });
                    adder.method_47615((class_8021)blockWidget, blocksList.grid.method_46457().method_46467());
                }
            }
            colorsGrid.method_46455((class_8021)blocksList, row + columns, i % columns, colorsGrid.method_46457().method_46467());
            this.method_37063(blocksList);
        }
        this.colorsEditor.method_48222();
        this.method_37063(this.colorsEditor);
    }

    private void createNewPreset(boolean createDefault) {
        String newPreset = this.presetsConfig.createNewPreset(createDefault, this.updatedPresets, this.deletedPresets);
        this.presetsListDropdown = null;
        this.changeEditingPreset(newPreset);
        this.method_41843();
    }

    private void deletePreset() {
        boolean configEmptied;
        PalettePresetsConfig.Editable updatedConfig = this.presetsConfig.deletePreset(this.editingPreset, this.updatedPresets, this.deletedPresets);
        boolean bl = configEmptied = updatedConfig != this.presetsConfig;
        if (configEmptied) {
            this.presetsConfig = updatedConfig;
        } else {
            this.updatedPresets.remove(this.editingPreset);
        }
        this.presetsListDropdown = null;
        this.changeEditingPreset(this.presetsConfig.getCurrentPresetFilename());
        this.method_41843();
    }

    private void duplicatePreset() {
        String newPreset = this.presetsConfig.duplicatePreset(this.editingPreset, this.updatedPresets, this.deletedPresets);
        this.presetsListDropdown = null;
        this.changeEditingPreset(newPreset);
        this.method_41843();
    }

    private void changeEditingPreset(String presetFile) {
        this.editingPreset = presetFile;
        this.presetNameField.method_1852((String)this.presetsConfig.presetFiles.get(presetFile));
    }

    private void updateFiles() {
        PaletteConfigManager.updateCompletePalette();
        PaletteConfigManager.readPresetsConfigFile();
        this.presetsConfig = PaletteConfigManager.presetsConfig.getEditable();
        this.editingPreset = this.presetsConfig.getCurrentPresetFilename();
        this.deletedPresets.clear();
        this.updatedPresets.clear();
        this.method_41843();
    }

    private void saveChanges() {
        boolean updateMapart = !this.presetsConfig.getCurrentPresetFilename().equals(PaletteConfigManager.presetsConfig.getCurrentPresetFilename());
        updateMapart |= this.updatedPresets.contains(this.presetsConfig.getCurrentPresetFilename());
        PaletteConfigManager.presetsConfig = this.presetsConfig;
        if (!this.updatedPresets.isEmpty()) {
            for (String filename : this.updatedPresets) {
                PaletteConfigManager.savePresetFile(filename);
            }
            this.updatedPresets.clear();
        }
        if (!this.deletedPresets.isEmpty()) {
            for (String filename : this.deletedPresets) {
                PaletteConfigManager.deletePresetFile(filename);
            }
            this.deletedPresets.clear();
        }
        if (updateMapart) {
            MapartImageUpdater.updateMapart(this.parent.mapart);
        }
        PaletteConfigManager.savePresetsConfigFile();
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        return this.colorsEditor.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        Matrix3x2fStack matrixStack = context.method_51448();
        matrixStack.pushMatrix();
        this.parent.method_25394(context, 0, 0, deltaTicks);
        matrixStack.popMatrix();
        context.field_59826.method_71059();
        this.method_57734(context);
        this.method_57735(context);
        int w = this.boxWidth;
        int h = this.boxHeight;
        context.method_25294(this.boxX, this.boxY, this.boxX + w, this.boxY + h, 0x77000000);
        context.method_25294(this.boxX, this.boxY, this.boxX + w, this.boxY + 30, 0x44000000);
        RenderUtils.drawBorder(context, this.boxX - 1, this.boxY - 1, w + 2, h + 2, 0x44FFFFFF);
        context.method_51738(this.boxX, this.boxX + w - 1, this.boxY + 30, 0x77FFFFFF);
        super.method_25394(context, mouseX, mouseY, deltaTicks);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float deltaTicks) {
    }

    @Override
    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507((class_437)this.parent);
    }

    @Environment(value=EnvType.CLIENT)
    private class MapColorBlockWidget
    extends BlockItemWidget {
        private final class_3620 mapColor;
        private final ClickAction clickAction;

        private MapColorBlockWidget(int x, int y, int squareSize, class_2248 block, class_3620 mapColor, ClickAction clickAction) {
            super(x, y, squareSize, block, true);
            this.mapColor = mapColor;
            this.clickAction = clickAction;
        }

        public void method_25348(class_11909 click, boolean doubled) {
            this.clickAction.click(click, doubled);
        }

        @Override
        public boolean method_25402(class_11909 click, boolean doubled) {
            return super.method_25402(click, doubled);
        }

        @Override
        protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
            super.method_48579(context, mouseX, mouseY, deltaTicks);
            PalettePresetsConfig.PalettePreset preset = PresetsEditorScreen.this.presetsConfig.getPreset(PresetsEditorScreen.this.editingPreset);
            class_2248 presetBlock = preset.colors.get(this.mapColor);
            boolean flag = presetBlock == null && this.getBlock() == class_2246.field_10499;
            boolean bl = flag = flag || presetBlock != null && presetBlock == this.getBlock();
            if (flag) {
                context.field_59826.method_71059();
                RenderUtils.drawBorder(context, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), -11010079);
            }
        }

        @Environment(value=EnvType.CLIENT)
        static interface ClickAction {
            public void click(class_11909 var1, boolean var2);
        }
    }
}

