/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.gui.widget;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_357;

@Environment(value=EnvType.CLIENT)
public class ImageAdjustmentSliderWidget
extends class_357 {
    private final float min;
    private final float max;
    private final boolean isDecimalValue;
    private final float diffByKey;
    private final Consumer<Double> onValueChanged;
    private final Function<Double, String> formatter;
    private static boolean shiftPressed = false;
    private static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private static ScheduledFuture<?> scheduledTask;

    public ImageAdjustmentSliderWidget(int width, int height, float min, float max, boolean isDecimalValue, double initialValue, Consumer<Double> onValueChanged, Function<Double, String> formatter) {
        super(0, 0, width, height, (class_2561)class_2561.method_43473(), (initialValue - (double)min) / (double)(max - min));
        this.min = min;
        this.max = max;
        this.isDecimalValue = isDecimalValue;
        this.diffByKey = (isDecimalValue ? 0.01f : 1.0f) / (max - min);
        this.onValueChanged = onValueChanged;
        this.formatter = formatter;
        this.method_25346();
    }

    protected void method_25346() {
        this.method_25355((class_2561)class_2561.method_43470((String)this.formatter.apply(this.getRealValue())));
    }

    protected void method_25344() {
        double value = this.getRealValue();
        if (scheduledTask != null && !scheduledTask.isDone()) {
            scheduledTask.cancel(true);
        }
        scheduledTask = EXECUTOR.schedule(() -> this.onValueChanged.accept(value), 50L, TimeUnit.MILLISECONDS);
    }

    public double getRealValue() {
        double value = (double)this.min + (double)(this.max - this.min) * this.field_22753;
        if (!this.isDecimalValue) {
            return Math.floor(value);
        }
        return (this.field_22753 < 0.5 ? Math.floor(value * 100.0) : Math.ceil(value * 100.0)) / 100.0;
    }

    public boolean method_25404(class_11908 input) {
        boolean bl;
        if (input.method_74229()) {
            this.method_25365(!this.method_25370());
            return true;
        }
        if (input.method_74239()) {
            shiftPressed = true;
        } else if (this.method_25370() && ((bl = input.method_74232()) || input.method_74233())) {
            float diff;
            float f = diff = bl ? -this.diffByKey : this.diffByKey;
            if (shiftPressed) {
                diff *= 10.0f;
            }
            this.setValue(this.field_22753 + (double)diff);
            return true;
        }
        return false;
    }

    public boolean method_16803(class_11908 input) {
        if (input.method_74239()) {
            shiftPressed = false;
            return true;
        }
        return false;
    }

    public void setValue(double value) {
        double d = this.field_22753;
        this.field_22753 = class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        if (d != this.field_22753) {
            this.method_25344();
        }
        this.method_25346();
    }
}

