/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.config.palette;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3620;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import rh.maparthelper.MapartHelper;
import rh.maparthelper.config.adapter.BlockTypeAdapter;
import rh.maparthelper.config.adapter.MapColorBlockAdapter;
import rh.maparthelper.config.palette.CompletePalette;
import rh.maparthelper.config.palette.PaletteGenerator;
import rh.maparthelper.config.palette.PalettePresetsConfig;

public class PaletteConfigManager {
    static final Path PRESETS_PATH = MapartHelper.CONFIG_PATH.resolve("presets");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(class_2248.class, (Object)new BlockTypeAdapter()).registerTypeAdapter(new TypeToken<Map<class_3620, class_2248>>(){}.getType(), (Object)new MapColorBlockAdapter()).create();
    @NotNull
    public static PalettePresetsConfig presetsConfig = new PalettePresetsConfig();
    @NotNull
    public static CompletePalette completePalette = new CompletePalette();

    public static void regenerateCompletePalette() {
        completePalette = CompletePalette.generate();
        PaletteConfigManager.saveCompletePalette();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean readCompletePalette() {
        Path completePaletepath = MapartHelper.CONFIG_PATH.resolve("complete_palette.json");
        if (!Files.exists(completePaletepath, new LinkOption[0])) {
            return false;
        }
        try (FileReader reader = new FileReader(completePaletepath.toFile());){
            completePalette = (CompletePalette)gson.fromJson((Reader)reader, CompletePalette.class);
            if (completePalette == null) return false;
            PaletteConfigManager.completePalette.palette.replaceAll((color, blocks) -> blocks.stream().filter(b -> b != class_2246.field_10124).toList());
            PaletteGenerator.initARGBMapColor(PaletteConfigManager.completePalette.palette);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            MapartHelper.LOGGER.error("Failed to read JSON syntax \"{}\": {}", new Object[]{completePaletepath, e.getMessage(), e});
        }
        return false;
    }

    public static void updateCompletePalette() {
        boolean validPaletteFile = PaletteConfigManager.readCompletePalette();
        if (!validPaletteFile) {
            PaletteConfigManager.regenerateCompletePalette();
        }
    }

    public static void saveCompletePalette() {
        try (FileWriter writer = new FileWriter(MapartHelper.CONFIG_PATH.resolve("complete_palette.json").toFile());){
            gson.toJson((Object)completePalette, (Appendable)writer);
        }
        catch (IOException e) {
            MapartHelper.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void readPresetsConfigFile() {
        Path presetsConfigPath = MapartHelper.CONFIG_PATH.resolve("palette_presets.json");
        if (!Files.exists(presetsConfigPath, new LinkOption[0])) {
            presetsConfig = PalettePresetsConfig.createDefaultConfig();
            PaletteConfigManager.savePresetsConfigFile();
            PaletteConfigManager.savePresetFiles();
            return;
        }
        try (FileReader reader = new FileReader(presetsConfigPath.toFile());){
            presetsConfig = (PalettePresetsConfig)gson.fromJson((Reader)reader, PalettePresetsConfig.class);
            if (presetsConfig == null) {
                presetsConfig = PalettePresetsConfig.createDefaultConfig();
                PaletteConfigManager.savePresetsConfigFile();
                PaletteConfigManager.savePresetFiles();
                return;
            }
            if (PaletteConfigManager.removeUnexist() | PaletteConfigManager.readPresetsFiles() | PaletteConfigManager.validatePresetsConfig()) {
                PaletteConfigManager.savePresetsConfigFile();
            }
        }
        catch (Exception e) {
            MapartHelper.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean removeUnexist() {
        boolean hasChanges = false;
        Iterator<String> it = PaletteConfigManager.presetsConfig.presetFiles.keySet().iterator();
        while (it.hasNext()) {
            Path presetPath = PRESETS_PATH.resolve(it.next());
            if (Files.exists(presetPath, new LinkOption[0])) continue;
            it.remove();
            hasChanges = true;
        }
        return hasChanges;
    }

    private static boolean validatePresetsConfig() {
        boolean hasChanges = false;
        if (PaletteConfigManager.presetsConfig.presetFiles.isEmpty()) {
            MapartHelper.LOGGER.info("No preset files found, generating a default");
            PaletteConfigManager.presetsConfig.currentPresetFile = presetsConfig.createDefaultPreset();
            PaletteConfigManager.savePresetFiles();
            hasChanges = true;
        } else if (!PaletteConfigManager.presetsConfig.presetFiles.containsKey(PaletteConfigManager.presetsConfig.currentPresetFile)) {
            MapartHelper.LOGGER.info("Selected preset file \"{}\" is no longer exist, switching current preset", (Object)PaletteConfigManager.presetsConfig.currentPresetFile);
            PaletteConfigManager.presetsConfig.currentPresetFile = PaletteConfigManager.presetsConfig.presetFiles.keySet().iterator().next();
            hasChanges = true;
        }
        return hasChanges;
    }

    public static void savePresetsConfigFile() {
        try (FileWriter writer = new FileWriter(MapartHelper.CONFIG_PATH.resolve("palette_presets.json").toFile());){
            gson.toJson((Object)presetsConfig, (Appendable)writer);
        }
        catch (IOException e) {
            MapartHelper.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean readPresetsFiles() {
        boolean hasChanges = false;
        if (!Files.exists(PRESETS_PATH, new LinkOption[0])) {
            return false;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(PRESETS_PATH, "*.json");){
            for (Path path : stream) {
                try (FileReader reader = new FileReader(path.toFile());){
                    MapartHelper.LOGGER.info("Reading JSON file: \"{}\"", (Object)path);
                    PalettePresetsConfig.PalettePreset preset = (PalettePresetsConfig.PalettePreset)gson.fromJson((Reader)reader, PalettePresetsConfig.PalettePreset.class);
                    if (preset == null || preset.colors == null) {
                        MapartHelper.LOGGER.info("JSON file \"{}\" is not a preset, ignoring", (Object)path);
                        hasChanges |= PaletteConfigManager.presetsConfig.presetFiles.remove(path.getFileName().toString()) != null;
                        continue;
                    }
                    String filename = path.getFileName().toString();
                    PaletteConfigManager.presetsConfig.presets.put(filename, preset);
                    if (!PaletteConfigManager.presetsConfig.presetFiles.containsKey(filename)) {
                        PaletteConfigManager.presetsConfig.presetFiles.put(filename, FilenameUtils.getBaseName((String)filename));
                        hasChanges = true;
                    }
                    MapartHelper.LOGGER.info("Preset file \"{}\" successfully read", (Object)path);
                }
                catch (JsonSyntaxException e) {
                    MapartHelper.LOGGER.error("Failed to read JSON syntax \"{}\": {}", (Object)path, (Object)e.getMessage());
                    hasChanges |= PaletteConfigManager.presetsConfig.presetFiles.remove(path.getFileName().toString()) != null;
                }
                catch (IOException e) {
                    MapartHelper.LOGGER.error("Failed to read preset \"{}\"", (Object)path, (Object)e);
                    hasChanges |= PaletteConfigManager.presetsConfig.presetFiles.remove(path.getFileName().toString()) != null;
                }
            }
        }
        catch (IOException e) {
            MapartHelper.LOGGER.error("Failed to read presets directory", (Throwable)e);
        }
        return hasChanges;
    }

    private static void savePresetFiles() {
        try {
            if (!Files.exists(PRESETS_PATH, new LinkOption[0])) {
                Files.createDirectory(PRESETS_PATH, new FileAttribute[0]);
            }
            for (Map.Entry<String, String> entry : PaletteConfigManager.presetsConfig.presetFiles.entrySet()) {
                PaletteConfigManager.savePresetFile(entry.getKey());
            }
        }
        catch (IOException e) {
            MapartHelper.LOGGER.error("Failed to write presets directory", (Throwable)e);
        }
    }

    public static void savePresetFile(String filename) {
        Path presetFilePath = PRESETS_PATH.resolve(filename);
        try (FileWriter writer = new FileWriter(presetFilePath.toFile());){
            MapartHelper.LOGGER.info("Saving preset \"{}\" JSON file: \"{}\"", (Object)PaletteConfigManager.presetsConfig.presetFiles.get(filename), (Object)presetFilePath);
            PalettePresetsConfig.PalettePreset preset = PaletteConfigManager.presetsConfig.presets.get(filename);
            gson.toJson((Object)preset, (Appendable)writer);
        }
        catch (IOException e) {
            MapartHelper.LOGGER.error("Failed to write preset \"{}\" to file \"{}\"", new Object[]{filename, presetFilePath, e});
        }
    }

    public static void deletePresetFile(String filename) {
        try {
            Files.delete(PRESETS_PATH.resolve(filename));
        }
        catch (IOException e) {
            MapartHelper.LOGGER.error("Failed to delete preset \"{}\"", (Object)filename, (Object)e);
        }
    }

    public static void changeCurrentPreset(String name) {
        presetsConfig.setCurrentPreset(name);
        PaletteConfigManager.savePresetsConfigFile();
    }
}

