/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.conversion.dithering;

import java.util.Arrays;

public enum DitheringAlgorithms {
    NONE(new int[0], new int[0], new int[0]),
    FLOYD_STEINBERG(new int[]{7, 3, 5, 1}, new int[]{1, -1, 0, 1}, new int[]{0, 1, 1, 1}),
    ATKINSON(new int[]{1, 1, 1, 1, 1, 1}, new int[]{1, 2, -1, 0, 1, 0}, new int[]{0, 0, 1, 1, 1, 2}),
    JJN(new int[]{7, 5, 3, 5, 7, 5, 3, 1, 3, 5, 3, 1}, new int[]{1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2}, new int[]{0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2}),
    STUCKI(new int[]{8, 4, 2, 4, 8, 4, 2, 1, 2, 4, 2, 1}, new int[]{1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2}, new int[]{0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2}),
    BURKES(new int[]{8, 4, 2, 4, 8, 4, 2}, new int[]{1, 2, -2, -1, 0, 1, 2}, new int[]{0, 0, 1, 1, 1, 1, 1}),
    SIERRA(new int[]{4, 3, 1, 2, 3, 2, 1}, new int[]{1, 2, -2, -1, 0, 1, 2}, new int[]{0, 0, 1, 1, 1, 1, 1}),
    SIERRA_LITE(new int[]{2, 1, 1}, new int[]{1, -1, 0}, new int[]{0, 1, 1}),
    SIERRA_2ROW(new int[]{5, 3, 2, 4, 5, 4, 2, 2, 3, 2}, new int[]{1, 2, -2, -1, 0, 1, 2, -1, 0, 1}, new int[]{0, 0, 1, 1, 1, 1, 1, 2, 2, 2});

    private final float[] kernel;
    private final int[] offsetX;
    private final int[] offsetY;
    public final int rowsNumber;

    private DitheringAlgorithms(int[] weights, int[] offsetX, int[] offsetY) {
        int sum = Arrays.stream(weights).sum();
        this.kernel = new float[weights.length];
        for (int i = 0; i < weights.length; ++i) {
            this.kernel[i] = (float)weights[i] / (float)sum;
        }
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.rowsNumber = Arrays.stream(offsetY).max().orElse(0) + 1;
    }

    public void spreadDiffusionError(int[] errorsArray, int width, int x, int[] errorRGB) {
        for (int i = 0; i < this.kernel.length; ++i) {
            int nx = x + this.offsetX[i];
            int ny = this.offsetY[i];
            this.putError(errorsArray, width, nx, ny, (float)errorRGB[0] * this.kernel[i], (float)errorRGB[1] * this.kernel[i], (float)errorRGB[2] * this.kernel[i]);
        }
    }

    private void putError(int[] errorsArray, int width, int x, int y, float r, float g, float b) {
        int ind;
        if (x < 0 || x >= width || y < 0 || y >= this.rowsNumber) {
            return;
        }
        int n = ind = (y * width + x) * 3;
        errorsArray[n] = errorsArray[n] + Math.round(r);
        int n2 = ind + 1;
        errorsArray[n2] = errorsArray[n2] + Math.round(g);
        int n3 = ind + 2;
        errorsArray[n3] = errorsArray[n3] + Math.round(b);
    }
}

