/*
 * Decompiled with CFR 0.152.
 */
package rh.maparthelper.config.palette;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.class_2248;
import net.minecraft.class_3620;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import rh.maparthelper.config.palette.PaletteConfigManager;
import rh.maparthelper.config.palette.PaletteGenerator;
import rh.maparthelper.util.Utils;

public class PalettePresetsConfig {
    String currentPresetFile;
    public Map<String, String> presetFiles = new TreeMap<String, String>();
    transient Map<String, @NotNull PalettePreset> presets = new HashMap<String, PalettePreset>();

    static PalettePresetsConfig createDefaultConfig() {
        PalettePresetsConfig config = new PalettePresetsConfig();
        config.currentPresetFile = config.createDefaultPreset();
        return config;
    }

    public Editable getEditable() {
        return new Editable(this);
    }

    public String getCurrentPresetFilename() {
        return this.currentPresetFile;
    }

    public String getCurrentPresetName() {
        return this.presetFiles.get(this.currentPresetFile);
    }

    public Set<class_3620> getPresetColors(String filename) {
        return this.presets.get((Object)filename).colors.keySet();
    }

    public Set<class_3620> getCurrentPresetColors() {
        return this.getPresetColors(this.currentPresetFile);
    }

    public class_2248 getPresetBlockOfMapColor(String preset, class_3620 color) {
        return this.presets.get(preset).getBlockOfMapColor(color);
    }

    public class_2248 getBlockOfMapColor(class_3620 color) {
        return this.getPresetBlockOfMapColor(this.currentPresetFile, color);
    }

    void setCurrentPreset(String presetFilename) {
        if (this.presetFiles.containsKey(presetFilename)) {
            this.currentPresetFile = presetFilename;
        }
    }

    void addPreset(String filename, PalettePreset preset) {
        String presetName = Utils.makeUniqueName(this.presetFiles.values()::contains, "New preset", null, "%s (%d)");
        this.presetFiles.put(filename, presetName);
        this.presets.put(filename, preset);
    }

    String createDefaultPreset() {
        String presetFilename = Utils.makeUniqueFilename(PaletteConfigManager.PRESETS_PATH, "new_preset", "json", "%s_%d");
        this.addPreset(presetFilename, PaletteGenerator.getDefaultPreset());
        return presetFilename;
    }

    public static class Editable
    extends PalettePresetsConfig {
        public Editable(PalettePresetsConfig config) {
            this.currentPresetFile = config.currentPresetFile;
            this.presetFiles = new TreeMap<String, String>(config.presetFiles);
            this.presets = new TreeMap<String, PalettePreset>(config.presets);
        }

        @Override
        public void setCurrentPreset(String presetFilename) {
            if (this.presetFiles.containsKey(presetFilename)) {
                this.currentPresetFile = presetFilename;
            }
        }

        public PalettePreset getPreset(String presetFilename) {
            return (PalettePreset)this.presets.get(presetFilename);
        }

        public String createNewPreset(boolean createDefault, Set<String> updatedPresets, Set<String> deletedPresets) {
            String presetFilename = Utils.makeUniqueName(filename -> (updatedPresets.contains(filename) || Files.exists(PaletteConfigManager.PRESETS_PATH.resolve((String)filename), new LinkOption[0])) && !deletedPresets.contains(filename), "new_preset", "json", "%s_%d");
            updatedPresets.add(presetFilename);
            deletedPresets.remove(presetFilename);
            PalettePreset preset = createDefault ? PaletteGenerator.getDefaultPreset() : new PalettePreset();
            this.addPreset(presetFilename, preset);
            return presetFilename;
        }

        public Editable deletePreset(String filename, Set<String> updatedPresets, Set<String> deletedPresets) {
            if (Files.exists(PaletteConfigManager.PRESETS_PATH.resolve(filename), new LinkOption[0])) {
                deletedPresets.add(filename);
            }
            if (this.presetFiles.size() == 1) {
                Editable newConfig = new Editable(new PalettePresetsConfig());
                newConfig.currentPresetFile = newConfig.createNewPreset(true, updatedPresets, deletedPresets);
                updatedPresets.clear();
                updatedPresets.add(newConfig.currentPresetFile);
                deletedPresets.remove(newConfig.currentPresetFile);
                return newConfig;
            }
            updatedPresets.remove(filename);
            this.presetFiles.remove(filename);
            this.presets.remove(filename);
            this.currentPresetFile = (String)this.presetFiles.keySet().iterator().next();
            return this;
        }

        public String duplicatePreset(String filename, Set<String> updatedPresets, Set<String> deletedPresets) {
            PalettePreset preset = new PalettePreset((PalettePreset)this.presets.get(filename));
            Object newFilename = FilenameUtils.getBaseName((String)filename) + " (Copy)";
            newFilename = Utils.makeUniqueName(fName -> (this.presetFiles.containsKey(fName) || updatedPresets.contains(fName) || Files.exists(PaletteConfigManager.PRESETS_PATH.resolve((String)fName), new LinkOption[0])) && !deletedPresets.contains(fName), (String)newFilename, "json", "%s_%d");
            updatedPresets.add((String)newFilename);
            deletedPresets.remove(newFilename);
            this.presets.put(newFilename, preset);
            this.presetFiles.put(newFilename, (String)this.presetFiles.get(filename) + " (Copy)");
            return newFilename;
        }
    }

    public static class PalettePreset {
        public final Map<class_3620, class_2248> colors = new TreeMap<class_3620, class_2248>(Comparator.comparingInt(o -> o.field_16021));

        PalettePreset() {
        }

        PalettePreset(Map<class_3620, class_2248> colors) {
            this.colors.putAll(colors);
        }

        PalettePreset(PalettePreset origin) {
            this.colors.putAll(origin.colors);
        }

        class_2248 getBlockOfMapColor(class_3620 color) {
            return this.colors.get(color);
        }

        public void updateColor(class_3620 mapColor, class_2248 block) {
            this.colors.put(mapColor, block);
        }

        public void removeColor(class_3620 mapColor) {
            this.colors.remove(mapColor);
        }
    }
}

