/*
 * Decompiled with CFR 0.152.
 */
package top.xiyang6666.etched_extension.client;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.xiyang6666.etched_extension.Config;
import top.xiyang6666.etched_extension.Utils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J(\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0002J0\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\rH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ltop/xiyang6666/etched_extension/client/AlbumProcessor;", "", "<init>", "()V", "getOverlay", "Lkotlin/Pair;", "Ltop/xiyang6666/etched_extension/client/AlbumProcessor$Properties;", "Lcom/mojang/blaze3d/platform/NativeImage;", "POW22", "", "apply", "image", "multiplyAndQuantizeChannel", "", "baseColor", "overlayColor", "bitOffset", "multiplyBlendChannel", "base", "overlay", "quantizeChannel", "channel", "blendPixelQuad", "c1", "c2", "c3", "c4", "gammaBlend", "getPow22", "", "value", "Properties", "etched_extension"})
@SourceDebugExtension(value={"SMAP\nAlbumProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlbumProcessor.kt\ntop/xiyang6666/etched_extension/client/AlbumProcessor\n+ 2 Utils.kt\ntop/xiyang6666/etched_extension/Utils\n*L\n1#1,179:1\n29#2:180\n*S KotlinDebug\n*F\n+ 1 AlbumProcessor.kt\ntop/xiyang6666/etched_extension/client/AlbumProcessor\n*L\n39#1:180\n*E\n"})
public final class AlbumProcessor {
    @NotNull
    public static final AlbumProcessor INSTANCE = new AlbumProcessor();
    @NotNull
    private static final float[] POW22;

    private AlbumProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<Properties, NativeImage> getOverlay() {
        Pair pair;
        Object object;
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceManager, (String)"getResourceManager(...)");
        ResourceManager resourceManager2 = resourceManager;
        String resolution = (String)Config.Client.INSTANCE.getAlbumCover().getCoverResolution().get();
        Resource propertiesResource = resourceManager2.m_215593_(ResourceLocation.fromNamespaceAndPath((String)"etched_extension", (String)("textures/item/album_cover_properties_" + resolution + ".json")));
        Closeable closeable = propertiesResource.m_215507_();
        Object object2 = null;
        try {
            Properties properties;
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new InputStreamReader(stream, StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                InputStreamReader reader = (InputStreamReader)closeable2;
                boolean bl2 = false;
                Utils utils = Utils.INSTANCE;
                Gson $this$fromJsonTyped$iv = new Gson();
                boolean $i$f$fromJsonTyped = false;
                properties = (Properties)$this$fromJsonTyped$iv.fromJson((Reader)reader, new TypeToken<Properties>(){}.getType());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
            }
            object = properties;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        Properties properties = object;
        Resource imageResource = resourceManager2.m_215593_(ResourceLocation.parse((String)properties.getTemplateTexture()));
        object2 = imageResource.m_215507_();
        object = null;
        try {
            InputStream stream = (InputStream)object2;
            boolean bl = false;
            pair = TuplesKt.to((Object)properties, (Object)NativeImage.m_85058_((InputStream)stream));
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final NativeImage apply(@NotNull NativeImage image) {
        NativeImage nativeImage;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Pair<Properties, NativeImage> pair = this.getOverlay();
        Properties properties = (Properties)pair.component1();
        NativeImage overlay = (NativeImage)pair.component2();
        AutoCloseable autoCloseable = (AutoCloseable)overlay;
        Throwable throwable = null;
        try {
            NativeImage nativeImage2;
            NativeImage ov = (NativeImage)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = (AutoCloseable)image;
            Throwable throwable2 = null;
            try {
                NativeImage img = (NativeImage)autoCloseable2;
                boolean bl2 = false;
                NativeImage resultImage = new NativeImage(ov.m_84982_(), ov.m_85084_(), true);
                resultImage.m_85054_(ov);
                float xFactor = (float)img.m_84982_() / (float)(properties.getWidth() * 2);
                float yFactor = (float)img.m_85084_() / (float)(properties.getHeight() * 2);
                int n = properties.getX() + properties.getWidth();
                for (int m = properties.getX(); m < n; ++m) {
                    int n2 = properties.getY() + properties.getHeight();
                    for (int n3 = properties.getY(); n3 < n2; ++n3) {
                        int relativeM = m - properties.getX();
                        int relativeN = n3 - properties.getY();
                        int x1 = (int)(xFactor * (float)relativeM * (float)2);
                        int x2 = (int)(xFactor * (float)(relativeM * 2 + 1));
                        int y1 = (int)(yFactor * (float)relativeN * (float)2);
                        int y2 = (int)(yFactor * (float)(relativeN * 2 + 1));
                        int baseColor = INSTANCE.blendPixelQuad(img.m_84985_(x1, y1), img.m_84985_(x2, y1), img.m_84985_(x1, y2), img.m_84985_(x2, y2));
                        int overlayColor = ov.m_84985_(m, n3);
                        int r = INSTANCE.multiplyAndQuantizeChannel(baseColor, overlayColor, 16);
                        int g = INSTANCE.multiplyAndQuantizeChannel(baseColor, overlayColor, 8);
                        int b = INSTANCE.multiplyAndQuantizeChannel(baseColor, overlayColor, 0);
                        int finalColor = overlayColor & 0xFF000000 | r | g | b;
                        resultImage.m_84988_(m, n3, finalColor);
                    }
                }
                nativeImage2 = resultImage;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            nativeImage = nativeImage2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return nativeImage;
    }

    private final int multiplyAndQuantizeChannel(int baseColor, int overlayColor, int bitOffset) {
        int baseChannel = baseColor >> bitOffset & 0xFF;
        int overlayChannel = overlayColor >> bitOffset & 0xFF;
        int multiplied = this.multiplyBlendChannel(baseChannel, overlayChannel);
        int quantized = this.quantizeChannel(multiplied);
        return (quantized & 0xFF) << bitOffset;
    }

    private final int multiplyBlendChannel(int base, int overlay) {
        return (int)((float)base * ((float)overlay / 255.0f));
    }

    private final int quantizeChannel(int channel) {
        Integer divisions = (Integer)Config.Client.INSTANCE.getAlbumCover().getColorDivisions().get();
        Intrinsics.checkNotNull((Object)divisions);
        return channel / divisions * divisions;
    }

    private final int blendPixelQuad(int c1, int c2, int c3, int c4) {
        int r = this.gammaBlend(c1, c2, c3, c4, 16);
        int g = this.gammaBlend(c1, c2, c3, c4, 8);
        int b = this.gammaBlend(c1, c2, c3, c4, 0);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private final int gammaBlend(int c1, int c2, int c3, int c4, int bitOffset) {
        float f = this.getPow22(c1 >> bitOffset & 0xFF);
        float g = this.getPow22(c2 >> bitOffset & 0xFF);
        float h = this.getPow22(c3 >> bitOffset & 0xFF);
        float i = this.getPow22(c4 >> bitOffset & 0xFF);
        float avgLinear = (f + g + h + i) * 0.25f;
        float avgGamma = (float)Math.pow(avgLinear, 0.45454547f);
        return (int)(avgGamma * 255.0f);
    }

    private final float getPow22(int value) {
        return POW22[value & 0xFF];
    }

    static {
        int n = 0;
        float[] fArray = new float[256];
        while (n < 256) {
            int n2 = n++;
            fArray[n2] = (float)Math.pow((float)n2 / 255.0f, 2.2f);
        }
        POW22 = fArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u001d"}, d2={"Ltop/xiyang6666/etched_extension/client/AlbumProcessor$Properties;", "", "templateTexture", "", "x", "", "y", "width", "height", "<init>", "(Ljava/lang/String;IIII)V", "getTemplateTexture", "()Ljava/lang/String;", "getX", "()I", "getY", "getWidth", "getHeight", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "etched_extension"})
    public static final class Properties {
        @SerializedName(value="template_texture")
        @NotNull
        private final String templateTexture;
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        public Properties(@NotNull String templateTexture, int x, int y, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)templateTexture, (String)"templateTexture");
            this.templateTexture = templateTexture;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        @NotNull
        public final String getTemplateTexture() {
            return this.templateTexture;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final String component1() {
            return this.templateTexture;
        }

        public final int component2() {
            return this.x;
        }

        public final int component3() {
            return this.y;
        }

        public final int component4() {
            return this.width;
        }

        public final int component5() {
            return this.height;
        }

        @NotNull
        public final Properties copy(@NotNull String templateTexture, int x, int y, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)templateTexture, (String)"templateTexture");
            return new Properties(templateTexture, x, y, width, height);
        }

        public static /* synthetic */ Properties copy$default(Properties properties, String string, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                string = properties.templateTexture;
            }
            if ((n5 & 2) != 0) {
                n = properties.x;
            }
            if ((n5 & 4) != 0) {
                n2 = properties.y;
            }
            if ((n5 & 8) != 0) {
                n3 = properties.width;
            }
            if ((n5 & 0x10) != 0) {
                n4 = properties.height;
            }
            return properties.copy(string, n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Properties(templateTexture=" + this.templateTexture + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ")";
        }

        public int hashCode() {
            int result = this.templateTexture.hashCode();
            result = result * 31 + Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            result = result * 31 + Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.height);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Properties)) {
                return false;
            }
            Properties properties = (Properties)other;
            if (!Intrinsics.areEqual((Object)this.templateTexture, (Object)properties.templateTexture)) {
                return false;
            }
            if (this.x != properties.x) {
                return false;
            }
            if (this.y != properties.y) {
                return false;
            }
            if (this.width != properties.width) {
                return false;
            }
            return this.height == properties.height;
        }
    }
}

