/*
 * Decompiled with CFR 0.152.
 */
package top.xiyang6666.etched_extension.source;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.download.SoundDownloadSource;
import gg.moonflower.etched.api.util.DownloadProgressListener;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.xiyang6666.etched_extension.Config;
import top.xiyang6666.etched_extension.EtchedExtension;
import top.xiyang6666.etched_extension.Utils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u0000  2\u00020\u0001:\b !\"#$%&'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f2\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016\u00a8\u0006("}, d2={"Ltop/xiyang6666/etched_extension/source/EBNRApiSource;", "Lgg/moonflower/etched/api/sound/download/SoundDownloadSource;", "<init>", "()V", "parseSong", "Ltop/xiyang6666/etched_extension/source/EBNRApiSource$SongInfo;", "content", "", "parseAlbum", "Ltop/xiyang6666/etched_extension/source/EBNRApiSource$Album;", "parsePlaylist", "Ltop/xiyang6666/etched_extension/source/EBNRApiSource$Playlist;", "parseAudio", "Ltop/xiyang6666/etched_extension/source/EBNRApiSource$Audio;", "resolveUrl", "", "Ljava/net/URL;", "s", "listener", "Lgg/moonflower/etched/api/util/DownloadProgressListener;", "proxy", "Ljava/net/Proxy;", "resolveTracks", "Lgg/moonflower/etched/api/record/TrackData;", "resolveAlbumCover", "Ljava/util/Optional;", "manager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "isValidUrl", "", "isTemporary", "getApiName", "Companion", "Artist", "SongInfo", "AlbumInfo", "Album", "Creator", "Playlist", "Audio", "etched_extension"})
@SourceDebugExtension(value={"SMAP\nEBNRApiSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EBNRApiSource.kt\ntop/xiyang6666/etched_extension/source/EBNRApiSource\n+ 2 Utils.kt\ntop/xiyang6666/etched_extension/Utils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n28#2:175\n28#2:176\n28#2:177\n28#2:178\n1557#3:179\n1628#3,3:180\n1557#3:183\n1628#3,3:184\n*S KotlinDebug\n*F\n+ 1 EBNRApiSource.kt\ntop/xiyang6666/etched_extension/source/EBNRApiSource\n*L\n67#1:175\n68#1:176\n69#1:177\n70#1:178\n119#1:179\n119#1:180,3\n137#1:183\n137#1:184,3\n*E\n"})
public final class EBNRApiSource
implements SoundDownloadSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String API_NAME = "EBNR-APi";

    private final SongInfo parseSong(String content) {
        Utils utils = Utils.INSTANCE;
        Gson $this$fromJsonTyped$iv = new Gson();
        boolean $i$f$fromJsonTyped = false;
        return (SongInfo)$this$fromJsonTyped$iv.fromJson(content, new TypeToken<SongInfo>(){}.getType());
    }

    private final Album parseAlbum(String content) {
        Utils utils = Utils.INSTANCE;
        Gson $this$fromJsonTyped$iv = new Gson();
        boolean $i$f$fromJsonTyped = false;
        return (Album)$this$fromJsonTyped$iv.fromJson(content, new TypeToken<Album>(){}.getType());
    }

    private final Playlist parsePlaylist(String content) {
        Utils utils = Utils.INSTANCE;
        Gson $this$fromJsonTyped$iv = new Gson();
        boolean $i$f$fromJsonTyped = false;
        return (Playlist)$this$fromJsonTyped$iv.fromJson(content, new TypeToken<Playlist>(){}.getType());
    }

    private final Audio parseAudio(String content) {
        Utils utils = Utils.INSTANCE;
        Gson $this$fromJsonTyped$iv = new Gson();
        boolean $i$f$fromJsonTyped = false;
        return (Audio)$this$fromJsonTyped$iv.fromJson(content, new TypeToken<Audio>(){}.getType());
    }

    @NotNull
    public List<URL> resolveUrl(@NotNull String s, @Nullable DownloadProgressListener listener, @NotNull Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        String baseApi = StringsKt.removeSuffix((String)EtchedExtension.Companion.getClientEbnrApi(), (CharSequence)"/");
        Utils.NeteaseLinkInfo neteaseLinkInfo = Utils.INSTANCE.parseNeteaseLink(s);
        if (neteaseLinkInfo == null) {
            throw new RuntimeException("Invalid link: " + s);
        }
        Utils.NeteaseLinkInfo linkInfo = neteaseLinkInfo;
        String link = linkInfo.normalize();
        if (linkInfo.getType() != Utils.NeteaseLinkInfo.Type.SONG) {
            throw new RuntimeException("Not a song link: " + s);
        }
        Utils.INSTANCE.asyncWarning((Function0<? extends Component>)((Function0)() -> EBNRApiSource.resolveUrl$lambda$0(baseApi, linkInfo, this)));
        return CollectionsKt.listOf((Object)new URI(baseApi + "/resolve/" + link).toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<TrackData> resolveTracks(@NotNull String s, @Nullable DownloadProgressListener listener, @NotNull Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Object object = Config.Common.INSTANCE.getEbnrApi().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String baseApi = StringsKt.removeSuffix((String)((String)object), (CharSequence)"/");
        Utils.NeteaseLinkInfo neteaseLinkInfo = Utils.INSTANCE.parseNeteaseLink(s);
        if (neteaseLinkInfo == null) {
            throw new RuntimeException("Invalid link: " + s);
        }
        Utils.NeteaseLinkInfo linkInfo = neteaseLinkInfo;
        switch (WhenMappings.$EnumSwitchMapping$0[linkInfo.getType().ordinal()]) {
            case 1: {
                Closeable closeable = Utils.INSTANCE.etchedGet(baseApi + "/info?id=" + linkInfo.getId(), listener, API_NAME);
                Throwable throwable = null;
                try {
                    InputStream stream = (InputStream)closeable;
                    boolean bl = false;
                    InputStream inputStream = stream;
                    Charset charset = Charsets.UTF_8;
                    String content = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
                    SongInfo song = this.parseSong(content);
                    List list = CollectionsKt.listOf((Object)new TrackData(linkInfo.normalize(), CollectionsKt.joinToString$default((Iterable)song.getArtists(), (CharSequence)"/", null, null, (int)0, null, EBNRApiSource::resolveTracks$lambda$2$lambda$1, (int)30, null), (Component)Component.literal((String)song.getName())));
                    return list;
                }
                catch (Throwable stream) {
                    throwable = stream;
                    throw stream;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            case 2: {
                Closeable closeable = Utils.INSTANCE.etchedGet(baseApi + "/album?id=" + linkInfo.getId(), listener, API_NAME);
                Throwable throwable = null;
                try {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    InputStream stream = (InputStream)closeable;
                    boolean bl = false;
                    InputStream song = stream;
                    Object object2 = Charsets.UTF_8;
                    String content = TextStreamsKt.readText((Reader)new InputStreamReader(song, (Charset)object2));
                    Album album = this.parseAlbum(content);
                    object2 = album.getSongs();
                    Collection collection = CollectionsKt.listOf((Object)new TrackData(linkInfo.normalize(), CollectionsKt.joinToString$default((Iterable)album.getArtists(), (CharSequence)"/", null, null, (int)0, null, EBNRApiSource::resolveTracks$lambda$6$lambda$3, (int)30, null), (Component)Component.literal((String)album.getName())));
                    boolean $i$f$map = false;
                    void var15_38 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void song2;
                        SongInfo songInfo = (SongInfo)item$iv$iv;
                        Collection collection2 = destination$iv$iv;
                        boolean bl2 = false;
                        collection2.add(new TrackData(new Utils.NeteaseLinkInfo(Utils.NeteaseLinkInfo.Type.SONG, song2.getId()).normalize(), CollectionsKt.joinToString$default((Iterable)song2.getArtists(), (CharSequence)"/", null, null, (int)0, null, EBNRApiSource::resolveTracks$lambda$6$lambda$5$lambda$4, (int)30, null), (Component)Component.literal((String)song2.getName())));
                    }
                    List list = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
                    return list;
                }
                catch (Throwable stream) {
                    throwable = stream;
                    throw stream;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            case 3: {
                Closeable closeable = Utils.INSTANCE.etchedGet(baseApi + "/playlist?id=" + linkInfo.getId(), listener, API_NAME);
                Throwable throwable = null;
                try {
                    InputStream stream = (InputStream)closeable;
                    boolean bl = false;
                    InputStream album = stream;
                    Object $this$map$iv = Charsets.UTF_8;
                    String content = TextStreamsKt.readText((Reader)new InputStreamReader(album, (Charset)$this$map$iv));
                    Playlist playlist = this.parsePlaylist(content);
                    $this$map$iv = playlist.getTracks();
                    Collection collection = CollectionsKt.listOf((Object)new TrackData(linkInfo.normalize(), playlist.getCreator().getNickname(), (Component)Component.literal((String)playlist.getName())));
                    boolean $i$f$map = false;
                    Object $this$mapTo$iv$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object item$iv$iv = iterator.next();
                        SongInfo song2 = (SongInfo)item$iv$iv;
                        Collection collection3 = destination$iv$iv;
                        boolean bl3 = false;
                        collection3.add(new TrackData(new Utils.NeteaseLinkInfo(Utils.NeteaseLinkInfo.Type.SONG, song2.getId()).normalize(), CollectionsKt.joinToString$default((Iterable)song2.getArtists(), (CharSequence)"/", null, null, (int)0, null, EBNRApiSource::resolveTracks$lambda$9$lambda$8$lambda$7, (int)30, null), (Component)Component.literal((String)song2.getName())));
                    }
                    List list = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
                    return list;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Optional<String> resolveAlbumCover(@NotNull String s, @Nullable DownloadProgressListener listener, @NotNull Proxy proxy, @NotNull ResourceManager manager) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        String baseApi = StringsKt.removeSuffix((String)EtchedExtension.Companion.getClientEbnrApi(), (CharSequence)"/");
        Utils.NeteaseLinkInfo neteaseLinkInfo = Utils.INSTANCE.parseNeteaseLink(s);
        if (neteaseLinkInfo == null) {
            throw new RuntimeException("Invalid link: " + s);
        }
        Utils.NeteaseLinkInfo linkInfo = neteaseLinkInfo;
        switch (WhenMappings.$EnumSwitchMapping$0[linkInfo.getType().ordinal()]) {
            case 2: {
                Closeable closeable = Utils.INSTANCE.etchedGet(baseApi + "/album?id=" + linkInfo.getId(), listener, API_NAME);
                Throwable throwable = null;
                try {
                    InputStream stream = (InputStream)closeable;
                    boolean bl = false;
                    InputStream inputStream = stream;
                    Charset charset = Charsets.UTF_8;
                    String content = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
                    Album album = this.parseAlbum(content);
                    Optional<String> optional = Optional.of(album.getCoverUrl());
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                    Optional<String> optional2 = optional;
                    return optional2;
                }
                catch (Throwable stream) {
                    throwable = stream;
                    throw stream;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            case 3: {
                Closeable closeable = Utils.INSTANCE.etchedGet(baseApi + "/playlist?id=" + linkInfo.getId(), listener, API_NAME);
                Throwable throwable = null;
                try {
                    InputStream stream = (InputStream)closeable;
                    boolean bl = false;
                    InputStream album = stream;
                    Charset charset = Charsets.UTF_8;
                    String content = TextStreamsKt.readText((Reader)new InputStreamReader(album, charset));
                    Playlist playlist = this.parsePlaylist(content);
                    Optional<String> optional = Optional.of(playlist.getCoverUrl());
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                    Optional<String> optional3 = optional;
                    return optional3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
        Optional<String> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        return optional;
    }

    public boolean isValidUrl(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return Utils.INSTANCE.parseNeteaseLink(s) != null;
    }

    public boolean isTemporary(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return true;
    }

    @NotNull
    public String getApiName() {
        return "ebnr-api";
    }

    private static final Component resolveUrl$lambda$0(String $baseApi, Utils.NeteaseLinkInfo $linkInfo, EBNRApiSource this$0) {
        CompletableFuture<HttpResponse<String>> infoFuture = Utils.INSTANCE.asyncGet($baseApi + "/info?id=" + $linkInfo.getId());
        CompletableFuture<HttpResponse<String>> audioFuture = Utils.INSTANCE.asyncGet($baseApi + "/audio?id=" + $linkInfo.getId());
        try {
            String string = audioFuture.get().body();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body(...)");
            Audio audio = this$0.parseAudio(string);
            if (audio.getUrl() != null) {
                return null;
            }
            String string2 = infoFuture.get().body();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"body(...)");
            SongInfo info = this$0.parseSong(string2);
            Object[] objectArray = new Object[]{info.getName()};
            return (Component)Component.translatable((String)"message.vip_song", (Object[])objectArray);
        }
        catch (Exception e) {
            EtchedExtension.Companion.getLOGGER().warn((Object)e);
            Component component = null;
            return component;
        }
    }

    private static final CharSequence resolveTracks$lambda$2$lambda$1(Artist it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence resolveTracks$lambda$6$lambda$3(Artist it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence resolveTracks$lambda$6$lambda$5$lambda$4(Artist it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence resolveTracks$lambda$9$lambda$8$lambda$7(Artist it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007H\u00c6\u0003JG\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\u00052\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\""}, d2={"Ltop/xiyang6666/etched_extension/source/EBNRApiSource$Album;", "", "id", "", "name", "", "artists", "", "Ltop/xiyang6666/etched_extension/source/EBNRApiSource$Artist;", "coverUrl", "songs", "Ltop/xiyang6666/etched_extension/source/EBNRApiSource$SongInfo;", "<init>", "(JLjava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/util/List;)V", "getId", "()J", "getName", "()Ljava/lang/String;", "getArtists", "()Ljava/util/List;", "getCoverUrl", "getSongs", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "etched_extension"})
    public static final class Album {
        private final long id;
        @NotNull
        private final String name;
        @NotNull
        private final List<Artist> artists;
        @SerializedName(value="cover_url")
        @NotNull
        private final String coverUrl;
        @NotNull
        private final List<SongInfo> songs;

        public Album(long id, @NotNull String name, @NotNull List<Artist> artists, @NotNull String coverUrl, @NotNull List<SongInfo> songs) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(artists, (String)"artists");
            Intrinsics.checkNotNullParameter((Object)coverUrl, (String)"coverUrl");
            Intrinsics.checkNotNullParameter(songs, (String)"songs");
            this.id = id;
            this.name = name;
            this.artists = artists;
            this.coverUrl = coverUrl;
            this.songs = songs;
        }

        public final long getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<Artist> getArtists() {
            return this.artists;
        }

        @NotNull
        public final String getCoverUrl() {
            return this.coverUrl;
        }

        @NotNull
        public final List<SongInfo> getSongs() {
            return this.songs;
        }

        public final long component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final List<Artist> component3() {
            return this.artists;
        }

        @NotNull
        public final String component4() {
            return this.coverUrl;
        }

        @NotNull
        public final List<SongInfo> component5() {
            return this.songs;
        }

        @NotNull
        public final Album copy(long id, @NotNull String name, @NotNull List<Artist> artists, @NotNull String coverUrl, @NotNull List<SongInfo> songs) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(artists, (String)"artists");
            Intrinsics.checkNotNullParameter((Object)coverUrl, (String)"coverUrl");
            Intrinsics.checkNotNullParameter(songs, (String)"songs");
            return new Album(id, name, artists, coverUrl, songs);
        }

        public static /* synthetic */ Album copy$default(Album album, long l, String string, List list, String string2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                l = album.id;
            }
            if ((n & 2) != 0) {
                string = album.name;
            }
            if ((n & 4) != 0) {
                list = album.artists;
            }
            if ((n & 8) != 0) {
                string2 = album.coverUrl;
            }
            if ((n & 0x10) != 0) {
                list2 = album.songs;
            }
            return album.copy(l, string, list, string2, list2);
        }

        @NotNull
        public String toString() {
            return "Album(id=" + this.id + ", name=" + this.name + ", artists=" + this.artists + ", coverUrl=" + this.coverUrl + ", songs=" + this.songs + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.id);
            result = result * 31 + this.name.hashCode();
            result = result * 31 + ((Object)this.artists).hashCode();
            result = result * 31 + this.coverUrl.hashCode();
            result = result * 31 + ((Object)this.songs).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Album)) {
                return false;
            }
            Album album = (Album)other;
            if (this.id != album.id) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)album.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.artists, album.artists)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.coverUrl, (Object)album.coverUrl)) {
                return false;
            }
            return Intrinsics.areEqual(this.songs, album.songs);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Ltop/xiyang6666/etched_extension/source/EBNRApiSource$AlbumInfo;", "", "id", "", "name", "", "coverUrl", "<init>", "(JLjava/lang/String;Ljava/lang/String;)V", "getId", "()J", "getName", "()Ljava/lang/String;", "getCoverUrl", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "etched_extension"})
    public static final class AlbumInfo {
        private final long id;
        @NotNull
        private final String name;
        @SerializedName(value="cover_url")
        @NotNull
        private final String coverUrl;

        public AlbumInfo(long id, @NotNull String name, @NotNull String coverUrl) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)coverUrl, (String)"coverUrl");
            this.id = id;
            this.name = name;
            this.coverUrl = coverUrl;
        }

        public final long getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getCoverUrl() {
            return this.coverUrl;
        }

        public final long component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.coverUrl;
        }

        @NotNull
        public final AlbumInfo copy(long id, @NotNull String name, @NotNull String coverUrl) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)coverUrl, (String)"coverUrl");
            return new AlbumInfo(id, name, coverUrl);
        }

        public static /* synthetic */ AlbumInfo copy$default(AlbumInfo albumInfo, long l, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                l = albumInfo.id;
            }
            if ((n & 2) != 0) {
                string = albumInfo.name;
            }
            if ((n & 4) != 0) {
                string2 = albumInfo.coverUrl;
            }
            return albumInfo.copy(l, string, string2);
        }

        @NotNull
        public String toString() {
            return "AlbumInfo(id=" + this.id + ", name=" + this.name + ", coverUrl=" + this.coverUrl + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.id);
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.coverUrl.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AlbumInfo)) {
                return false;
            }
            AlbumInfo albumInfo = (AlbumInfo)other;
            if (this.id != albumInfo.id) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)albumInfo.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.coverUrl, (Object)albumInfo.coverUrl);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ltop/xiyang6666/etched_extension/source/EBNRApiSource$Artist;", "", "id", "", "name", "", "<init>", "(JLjava/lang/String;)V", "getId", "()J", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "etched_extension"})
    public static final class Artist {
        private final long id;
        @NotNull
        private final String name;

        public Artist(long id, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.id = id;
            this.name = name;
        }

        public final long getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final Artist copy(long id, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Artist(id, name);
        }

        public static /* synthetic */ Artist copy$default(Artist artist, long l, String string, int n, Object object) {
            if ((n & 1) != 0) {
                l = artist.id;
            }
            if ((n & 2) != 0) {
                string = artist.name;
            }
            return artist.copy(l, string);
        }

        @NotNull
        public String toString() {
            return "Artist(id=" + this.id + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.id);
            result = result * 31 + this.name.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Artist)) {
                return false;
            }
            Artist artist = (Artist)other;
            if (this.id != artist.id) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)artist.name);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Ltop/xiyang6666/etched_extension/source/EBNRApiSource$Audio;", "", "url", "", "<init>", "(Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "etched_extension"})
    public static final class Audio {
        @Nullable
        private final String url;

        public Audio(@Nullable String url) {
            this.url = url;
        }

        @Nullable
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final Audio copy(@Nullable String url) {
            return new Audio(url);
        }

        public static /* synthetic */ Audio copy$default(Audio audio, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = audio.url;
            }
            return audio.copy(string);
        }

        @NotNull
        public String toString() {
            return "Audio(url=" + this.url + ")";
        }

        public int hashCode() {
            return this.url == null ? 0 : this.url.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Audio)) {
                return false;
            }
            Audio audio = (Audio)other;
            return Intrinsics.areEqual((Object)this.url, (Object)audio.url);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ltop/xiyang6666/etched_extension/source/EBNRApiSource$Companion;", "", "<init>", "()V", "API_NAME", "", "etched_extension"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ltop/xiyang6666/etched_extension/source/EBNRApiSource$Creator;", "", "userId", "", "nickname", "", "<init>", "(JLjava/lang/String;)V", "getUserId", "()J", "getNickname", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "etched_extension"})
    public static final class Creator {
        @SerializedName(value="user_id")
        private final long userId;
        @NotNull
        private final String nickname;

        public Creator(long userId, @NotNull String nickname) {
            Intrinsics.checkNotNullParameter((Object)nickname, (String)"nickname");
            this.userId = userId;
            this.nickname = nickname;
        }

        public final long getUserId() {
            return this.userId;
        }

        @NotNull
        public final String getNickname() {
            return this.nickname;
        }

        public final long component1() {
            return this.userId;
        }

        @NotNull
        public final String component2() {
            return this.nickname;
        }

        @NotNull
        public final Creator copy(long userId, @NotNull String nickname) {
            Intrinsics.checkNotNullParameter((Object)nickname, (String)"nickname");
            return new Creator(userId, nickname);
        }

        public static /* synthetic */ Creator copy$default(Creator creator, long l, String string, int n, Object object) {
            if ((n & 1) != 0) {
                l = creator.userId;
            }
            if ((n & 2) != 0) {
                string = creator.nickname;
            }
            return creator.copy(l, string);
        }

        @NotNull
        public String toString() {
            return "Creator(userId=" + this.userId + ", nickname=" + this.nickname + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.userId);
            result = result * 31 + this.nickname.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Creator)) {
                return false;
            }
            Creator creator = (Creator)other;
            if (this.userId != creator.userId) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.nickname, (Object)creator.nickname);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003JA\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Ltop/xiyang6666/etched_extension/source/EBNRApiSource$Playlist;", "", "id", "", "name", "", "coverUrl", "creator", "Ltop/xiyang6666/etched_extension/source/EBNRApiSource$Creator;", "tracks", "", "Ltop/xiyang6666/etched_extension/source/EBNRApiSource$SongInfo;", "<init>", "(JLjava/lang/String;Ljava/lang/String;Ltop/xiyang6666/etched_extension/source/EBNRApiSource$Creator;Ljava/util/List;)V", "getId", "()J", "getName", "()Ljava/lang/String;", "getCoverUrl", "getCreator", "()Ltop/xiyang6666/etched_extension/source/EBNRApiSource$Creator;", "getTracks", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "etched_extension"})
    public static final class Playlist {
        private final long id;
        @NotNull
        private final String name;
        @SerializedName(value="cover_url")
        @NotNull
        private final String coverUrl;
        @NotNull
        private final Creator creator;
        @NotNull
        private final List<SongInfo> tracks;

        public Playlist(long id, @NotNull String name, @NotNull String coverUrl, @NotNull Creator creator, @NotNull List<SongInfo> tracks) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)coverUrl, (String)"coverUrl");
            Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
            Intrinsics.checkNotNullParameter(tracks, (String)"tracks");
            this.id = id;
            this.name = name;
            this.coverUrl = coverUrl;
            this.creator = creator;
            this.tracks = tracks;
        }

        public final long getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getCoverUrl() {
            return this.coverUrl;
        }

        @NotNull
        public final Creator getCreator() {
            return this.creator;
        }

        @NotNull
        public final List<SongInfo> getTracks() {
            return this.tracks;
        }

        public final long component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.coverUrl;
        }

        @NotNull
        public final Creator component4() {
            return this.creator;
        }

        @NotNull
        public final List<SongInfo> component5() {
            return this.tracks;
        }

        @NotNull
        public final Playlist copy(long id, @NotNull String name, @NotNull String coverUrl, @NotNull Creator creator, @NotNull List<SongInfo> tracks) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)coverUrl, (String)"coverUrl");
            Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
            Intrinsics.checkNotNullParameter(tracks, (String)"tracks");
            return new Playlist(id, name, coverUrl, creator, tracks);
        }

        public static /* synthetic */ Playlist copy$default(Playlist playlist, long l, String string, String string2, Creator creator, List list, int n, Object object) {
            if ((n & 1) != 0) {
                l = playlist.id;
            }
            if ((n & 2) != 0) {
                string = playlist.name;
            }
            if ((n & 4) != 0) {
                string2 = playlist.coverUrl;
            }
            if ((n & 8) != 0) {
                creator = playlist.creator;
            }
            if ((n & 0x10) != 0) {
                list = playlist.tracks;
            }
            return playlist.copy(l, string, string2, creator, list);
        }

        @NotNull
        public String toString() {
            return "Playlist(id=" + this.id + ", name=" + this.name + ", coverUrl=" + this.coverUrl + ", creator=" + this.creator + ", tracks=" + this.tracks + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.id);
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.coverUrl.hashCode();
            result = result * 31 + this.creator.hashCode();
            result = result * 31 + ((Object)this.tracks).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Playlist)) {
                return false;
            }
            Playlist playlist = (Playlist)other;
            if (this.id != playlist.id) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)playlist.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.coverUrl, (Object)playlist.coverUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.creator, (Object)playlist.creator)) {
                return false;
            }
            return Intrinsics.areEqual(this.tracks, playlist.tracks);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003J7\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Ltop/xiyang6666/etched_extension/source/EBNRApiSource$SongInfo;", "", "id", "", "name", "", "artists", "", "Ltop/xiyang6666/etched_extension/source/EBNRApiSource$Artist;", "album", "Ltop/xiyang6666/etched_extension/source/EBNRApiSource$AlbumInfo;", "<init>", "(JLjava/lang/String;Ljava/util/List;Ltop/xiyang6666/etched_extension/source/EBNRApiSource$AlbumInfo;)V", "getId", "()J", "getName", "()Ljava/lang/String;", "getArtists", "()Ljava/util/List;", "getAlbum", "()Ltop/xiyang6666/etched_extension/source/EBNRApiSource$AlbumInfo;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "etched_extension"})
    public static final class SongInfo {
        private final long id;
        @NotNull
        private final String name;
        @NotNull
        private final List<Artist> artists;
        @NotNull
        private final AlbumInfo album;

        public SongInfo(long id, @NotNull String name, @NotNull List<Artist> artists, @NotNull AlbumInfo album) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(artists, (String)"artists");
            Intrinsics.checkNotNullParameter((Object)album, (String)"album");
            this.id = id;
            this.name = name;
            this.artists = artists;
            this.album = album;
        }

        public final long getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<Artist> getArtists() {
            return this.artists;
        }

        @NotNull
        public final AlbumInfo getAlbum() {
            return this.album;
        }

        public final long component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final List<Artist> component3() {
            return this.artists;
        }

        @NotNull
        public final AlbumInfo component4() {
            return this.album;
        }

        @NotNull
        public final SongInfo copy(long id, @NotNull String name, @NotNull List<Artist> artists, @NotNull AlbumInfo album) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(artists, (String)"artists");
            Intrinsics.checkNotNullParameter((Object)album, (String)"album");
            return new SongInfo(id, name, artists, album);
        }

        public static /* synthetic */ SongInfo copy$default(SongInfo songInfo, long l, String string, List list, AlbumInfo albumInfo, int n, Object object) {
            if ((n & 1) != 0) {
                l = songInfo.id;
            }
            if ((n & 2) != 0) {
                string = songInfo.name;
            }
            if ((n & 4) != 0) {
                list = songInfo.artists;
            }
            if ((n & 8) != 0) {
                albumInfo = songInfo.album;
            }
            return songInfo.copy(l, string, list, albumInfo);
        }

        @NotNull
        public String toString() {
            return "SongInfo(id=" + this.id + ", name=" + this.name + ", artists=" + this.artists + ", album=" + this.album + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.id);
            result = result * 31 + this.name.hashCode();
            result = result * 31 + ((Object)this.artists).hashCode();
            result = result * 31 + this.album.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SongInfo)) {
                return false;
            }
            SongInfo songInfo = (SongInfo)other;
            if (this.id != songInfo.id) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)songInfo.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.artists, songInfo.artists)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.album, (Object)songInfo.album);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Utils.NeteaseLinkInfo.Type.values().length];
            try {
                nArray[Utils.NeteaseLinkInfo.Type.SONG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Utils.NeteaseLinkInfo.Type.ALBUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Utils.NeteaseLinkInfo.Type.PLAYLIST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

