/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen;

import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.cobblegen.CobbleGenPlugin;
import io.github.null2264.cobblegen.compat.CollectionCompat;
import io.github.null2264.cobblegen.data.CGRegistryImpl;
import io.github.null2264.cobblegen.data.model.Generator;
import io.github.null2264.cobblegen.extensions.net.minecraft.network.FriendlyByteBuf.ByteBufExt;
import io.github.null2264.cobblegen.network.payload.CGSyncS2CPayload;
import io.github.null2264.cobblegen.util.CGLog;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.PluginFinder;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidInteraction {
    private final Map<class_3611, List<Generator>> generatorMap = new HashMap<class_3611, List<Generator>>();
    @Nullable
    private Map<class_3611, List<Generator>> serverGeneratorMap = null;
    private boolean firstInit = true;
    private boolean shouldReload = true;
    private final AtomicInteger count = new AtomicInteger();

    @ApiStatus.AvailableSince(value="4.0")
    public void addGenerator(class_3611 fluid, Generator generator) {
        class_3611 genFluid = generator.getFluid();
        if (genFluid != null && genFluid == class_3612.field_15906) {
            CGLog.warn("EMPTY fluid is detected! Skipping...", new String[0]);
            return;
        }
        if (genFluid instanceof class_3609) {
            generator.setFluid(((class_3609)genFluid).method_15751());
        }
        this.generatorMap.computeIfAbsent(fluid, g -> new ArrayList()).add(generator);
        this.count.incrementAndGet();
    }

    public Map<class_3611, List<Generator>> getLocalGenerators() {
        return this.generatorMap;
    }

    @NotNull
    public Map<class_3611, List<Generator>> getGenerators() {
        return Util.notNullOr(this.serverGeneratorMap, this.generatorMap);
    }

    @ApiStatus.Internal
    public boolean isSync() {
        return this.serverGeneratorMap != null;
    }

    @Deprecated
    @ApiStatus.Internal
    public void writeGeneratorsToPacket(class_2540 buf) {
        FluidInteraction.write(this.generatorMap, buf);
    }

    @ApiStatus.Internal
    public void readGeneratorsFromPacket(class_2540 buf) {
        this.serverGeneratorMap = FluidInteraction.read(buf);
    }

    @ApiStatus.Internal
    public void readGeneratorsFromPayload(CGSyncS2CPayload payload) {
        this.serverGeneratorMap = payload.recipe();
    }

    @ApiStatus.Internal
    public void disconnect() {
        this.serverGeneratorMap = null;
    }

    @ApiStatus.Internal
    public void apply() {
        if (this.shouldReload) {
            CGLog.info(this.firstInit ? "Loading" : "Reloading", "generators...");
            this.generatorMap.clear();
            this.count.set(0);
            CGRegistryImpl registry = new CGRegistryImpl();
            for (PluginFinder.PlugInContainer container : PluginFinder.getModPlugins()) {
                String id = container.getModId();
                CobbleGenPlugin plugin = container.getPlugin();
                if (!plugin.shouldLoad()) continue;
                CGLog.info(this.firstInit ? "Loading" : "Reloading", "plugin from", id);
                try {
                    if (!this.firstInit) {
                        plugin.onReload();
                    }
                    plugin.registerInteraction(registry);
                }
                catch (Throwable err) {
                    CGLog.warn("Something went wrong while", this.firstInit ? "loading" : "reloading", "plugin provided by", id);
                    CGLog.error(err);
                    continue;
                }
                CGLog.info(this.firstInit ? "Loaded" : "Reloaded", "plugin from", id);
            }
            CGLog.info(String.valueOf(this.count.get()), "generators has been", this.firstInit ? "loaded" : "reloaded");
            if (this.firstInit) {
                this.firstInit = false;
            }
            this.shouldReload = false;
        }
    }

    @ApiStatus.Internal
    public void reload() {
        this.shouldReload = true;
        this.apply();
    }

    @ApiStatus.Internal
    public boolean interact(class_1936 level, class_2338 pos, class_2680 state) {
        return this.interact(level, pos, state, false);
    }

    @ApiStatus.Internal
    public boolean interact(class_1936 level, class_2338 pos, class_2680 state, boolean fromTop) {
        class_3610 fluidState = state.method_26227();
        class_3611 fluid = Generator.getStillFluid(fluidState);
        List<Generator> generators = this.generatorMap.getOrDefault(fluid, CollectionCompat.listOf(new Generator[0]));
        for (Generator generator : generators) {
            Optional<class_2680> result;
            if (!generator.check(level, pos, state, fromTop) || fromTop && generator.getType() != GeneratorType.STONE || !(result = generator.tryGenerate(level, pos, state)).isPresent()) continue;
            level.method_8652(pos, result.get(), 3);
            if (!generator.isSilent()) {
                level.method_20290(1501, pos, 0);
            }
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public Optional<class_2680> interactFromPipeState(class_1937 level, class_2338 pos, class_3611 fluid1, class_3611 fluid2) {
        class_3611 neighbour;
        class_3611 source;
        if (CobbleGen.META_CONFIG.create.disablePipe.booleanValue()) {
            return Optional.empty();
        }
        List<Generator> generators = this.generatorMap.get(fluid1);
        if (generators == null) {
            generators = this.generatorMap.get(fluid2);
            if (generators == null) {
                return Optional.empty();
            }
            source = fluid2;
            neighbour = fluid1;
        } else {
            source = fluid1;
            neighbour = fluid2;
        }
        for (Generator generator : generators) {
            Optional<class_2680> result;
            boolean fromTop = false;
            if (neighbour instanceof class_3609) {
                boolean bl = fromTop = neighbour == ((class_3609)neighbour).method_15751();
            }
            if (!generator.check((class_1936)level, pos, source.method_15785().method_15759(), fromTop)) continue;
            if (source == class_3612.field_15908) {
                source = ((class_3609)source).method_15750();
            }
            if (!(result = generator.tryGenerate((class_1936)level, pos, source.method_15785(), neighbour.method_15785())).isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public boolean interactFromPipe(class_1937 level, class_2338 pos, class_3611 fluid1, class_3611 fluid2) {
        Optional<class_2680> result = this.interactFromPipeState(level, pos, fluid1, fluid2);
        if (result.isPresent()) {
            level.method_8501(pos, result.get());
            return true;
        }
        return false;
    }

    public static void write(Map<class_3611, List<Generator>> generatorMap, class_2540 buf) {
        ByteBufExt.writeMap(buf, generatorMap, (b, o) -> b.method_10812(Util.getFluidId(o)), (b, generators) -> ByteBufExt.writeCollection(b, generators, (p, gen) -> gen.toPacket((class_2540)p)));
    }

    @ApiStatus.Internal
    public static Map<class_3611, List<Generator>> read(class_2540 buf) {
        return ByteBufExt.readMap(buf, o -> Util.getFluid(o.method_10810()), o -> {
            int _gensSize = o.method_10816();
            ArrayList<Generator> gens = new ArrayList<Generator>(_gensSize);
            for (int j = 0; j < _gensSize; ++j) {
                Generator generator = Generator.fromPacket(o);
                if (generator == null) {
                    CGLog.warn("Failed to retrieve a generator, skipping...", new String[0]);
                    continue;
                }
                gens.add(generator);
            }
            return gens;
        });
    }

    static {
        IBootstrap.dasBoot();
    }
}

