/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.compat;

import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class LoaderCompat {
    public static boolean isModLoaded(String mod) {
        return FabricLoader.getInstance().isModLoaded(mod);
    }

    public static Path getConfigDir() {
        Path configDir = FileSystems.getDefault().getPath(".", "config");
        if (!Files.exists(configDir, new LinkOption[0])) {
            try {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Creating config directory", e);
            }
        }
        return configDir;
    }

    public static LoaderType getType() {
        return LoaderType.FABRIC;
    }

    public static Boolean isFabric() {
        return LoaderCompat.getType() == LoaderType.FABRIC;
    }

    public static Boolean isQuilt() {
        return LoaderCompat.getType() == LoaderType.QUILT;
    }

    public static Boolean isFabricLike() {
        return LoaderCompat.isFabric() != false || LoaderCompat.isQuilt() != false;
    }

    public static Boolean isForge() {
        return LoaderCompat.getType() == LoaderType.FORGE;
    }

    public static Boolean isNeoForge() {
        return LoaderCompat.getType() == LoaderType.NEOFORGE;
    }

    public static Boolean isForgeLike() {
        return LoaderCompat.isForge() != false || LoaderCompat.isNeoForge() != false;
    }

    static {
        IBootstrap.dasBoot();
    }

    public static enum LoaderType {
        FABRIC,
        QUILT,
        FORGE,
        NEOFORGE;


        static {
            IBootstrap.dasBoot();
        }
    }
}

