/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data.config;

import io.github.null2264.cobblegen.data.CGIdentifier;
import io.github.null2264.cobblegen.data.JanksonSerializable;
import io.github.null2264.cobblegen.data.Pair;
import io.github.null2264.cobblegen.data.config.ResultList;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.data.model.PacketSerializable;
import io.github.null2264.cobblegen.extensions.net.minecraft.network.FriendlyByteBuf.ByteBufExt;
import io.github.null2264.shadowed.jankson.JsonArray;
import io.github.null2264.shadowed.jankson.JsonElement;
import io.github.null2264.shadowed.jankson.JsonObject;
import io.github.null2264.shadowed.jankson.annotation.Deserializer;
import io.github.null2264.shadowed.jankson.annotation.Serializer;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_2540;

public class GeneratorMap
extends HashMap<CGIdentifier, ResultList>
implements JanksonSerializable,
PacketSerializable<GeneratorMap> {
    public GeneratorMap() {
    }

    public GeneratorMap(int capacity) {
        super(capacity);
    }

    @SafeVarargs
    public static GeneratorMap of(Pair<CGIdentifier, ResultList> ... gens) {
        GeneratorMap map = new GeneratorMap();
        Arrays.stream(gens).forEach((? super T pair) -> {
            ResultList cfr_ignored_0 = (ResultList)map.put(pair.getFirst(), pair.getSecond());
        });
        return map;
    }

    @Override
    @Serializer
    public JsonElement toJson() {
        JsonObject result = new JsonObject();
        this.forEach((k, v) -> result.put(k.toString(), v.toJson()));
        return result;
    }

    @Deserializer
    public static GeneratorMap fromJson(JsonObject json) {
        GeneratorMap result = new GeneratorMap();
        if (json == null) {
            return result;
        }
        json.forEach((k, v) -> {
            if (!(v instanceof JsonArray)) {
                return;
            }
            result.put(CGIdentifier.of(k), ResultList.fromJson(v));
        });
        return result;
    }

    static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            if (expectedSize < 0) {
                throw new IllegalArgumentException("expectedSize cannot be negative but was: " + expectedSize);
            }
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void toPacket(class_2540 buf) {
        ByteBufExt.writeMap(buf, this, (o, key) -> key.writeToBuf((class_2540)o), (o, blocks) -> ByteBufExt.writeCollection(o, blocks, (p, block) -> block.toPacket((class_2540)p)));
    }

    public static GeneratorMap withExpectedSize(int expectedSize) {
        return new GeneratorMap(GeneratorMap.capacity(expectedSize));
    }

    public static GeneratorMap fromPacket(class_2540 buf) {
        int i = buf.method_10816();
        GeneratorMap map = GeneratorMap.withExpectedSize(i);
        for (int j = 0; j < i; ++j) {
            CGIdentifier id = CGIdentifier.readFromBuf(buf);
            List<WeightedBlock> list = ByteBufExt.readList(buf, WeightedBlock::fromPacket);
            map.put(id, new ResultList(list));
        }
        return map;
    }

    static {
        IBootstrap.dasBoot();
    }
}

