/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data.config;

import io.github.null2264.cobblegen.data.JanksonSerializable;
import io.github.null2264.cobblegen.data.model.PacketSerializable;
import io.github.null2264.cobblegen.extensions.net.minecraft.network.FriendlyByteBuf.ByteBufExt;
import io.github.null2264.cobblegen.util.Constants;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.jankson.JsonArray;
import io.github.null2264.shadowed.jankson.JsonElement;
import io.github.null2264.shadowed.jankson.JsonObject;
import io.github.null2264.shadowed.jankson.JsonPrimitive;
import io.github.null2264.shadowed.jankson.annotation.Deserializer;
import io.github.null2264.shadowed.jankson.annotation.Serializer;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class WeightedBlock
implements PacketSerializable<WeightedBlock>,
JanksonSerializable {
    public String id;
    public Double weight;
    @Nullable
    public List<String> dimensions;
    @Nullable
    public List<String> excludedDimensions;
    @Nullable
    public Integer maxY;
    @Nullable
    public Integer minY;
    @Nullable
    public List<String> neighbours;
    @Nullable
    public List<String> biomes;
    @Nullable
    public List<String> excludedBiomes;

    public WeightedBlock(String id, Double weight) {
        this(id, weight, null, null);
    }

    public WeightedBlock(String id, Double weight, List<String> dimIds) {
        this(id, weight, dimIds, null);
    }

    public WeightedBlock(String id, Double weight, List<String> dimIds, List<String> excludedDimensions) {
        this(id, weight, dimIds, excludedDimensions, null, null, null, null, null);
    }

    public WeightedBlock(String id, Double weight, @Nullable List<String> dimIds, @Nullable List<String> excludedDimensions, @Nullable Integer maxY, @Nullable Integer minY, @Nullable List<String> neighbours, @Nullable List<String> biomes, @Nullable List<String> excludedBiomes) {
        this.id = id;
        this.weight = weight;
        this.dimensions = dimIds;
        this.excludedDimensions = excludedDimensions;
        this.maxY = maxY;
        this.minY = minY;
        this.neighbours = neighbours;
        this.biomes = biomes;
        this.excludedBiomes = excludedBiomes;
    }

    public static WeightedBlock fromBlock(class_2248 block, Double weight) {
        return WeightedBlock.fromBlock(block, weight, null, null, null, null);
    }

    public static WeightedBlock fromBlock(class_2248 block, Double weight, List<String> dimIds, List<String> excludedDimensions, Integer maxY, Integer minY) {
        String id = Util.getBlockId(block).toString();
        return new WeightedBlock(id, weight, dimIds, excludedDimensions, maxY, minY, null, null, null);
    }

    public class_2248 getBlock() {
        return Util.getBlock(class_2960.method_12829((String)this.id));
    }

    public Optional<List<String>> getDimensions() {
        return Util.optional(this.dimensions);
    }

    public Optional<List<String>> getExcludedDimensions() {
        return Util.optional(this.excludedDimensions);
    }

    public Optional<Integer> getMaxY() {
        return Util.optional(this.maxY);
    }

    public Optional<Integer> getMinY() {
        return Util.optional(this.minY);
    }

    public Optional<List<String>> getBiomes() {
        return Util.optional(this.biomes);
    }

    public Optional<List<String>> getExcludedBiomes() {
        return Util.optional(this.excludedBiomes);
    }

    @Override
    public void toPacket(class_2540 buf) {
        buf.method_10814(this.id);
        buf.writeDouble(this.weight.doubleValue());
        ByteBufExt.writeOptional(buf, Util.optional(this.dimensions), (o, value) -> ByteBufExt.writeCollection(o, value, class_2540::method_10814));
        ByteBufExt.writeOptional(buf, Util.optional(this.excludedDimensions), (o, value) -> ByteBufExt.writeCollection(o, value, class_2540::method_10814));
        ByteBufExt.writeOptional(buf, Util.optional(this.maxY), class_2540::writeInt);
        ByteBufExt.writeOptional(buf, Util.optional(this.minY), class_2540::writeInt);
        ByteBufExt.writeOptional(buf, Util.optional(this.biomes), (o, value) -> ByteBufExt.writeCollection(o, value, class_2540::method_10814));
        ByteBufExt.writeOptional(buf, Util.optional(this.excludedBiomes), (o, value) -> ByteBufExt.writeCollection(o, value, class_2540::method_10814));
    }

    public static WeightedBlock fromPacket(class_2540 buf) {
        String id = buf.method_19772();
        Double weight = buf.readDouble();
        Optional<List> dimensions = ByteBufExt.readOptional(buf, o -> ByteBufExt.readList(o, class_2540::method_19772));
        Optional<List> excludedDimensions = ByteBufExt.readOptional(buf, o -> ByteBufExt.readList(o, class_2540::method_19772));
        Optional<Integer> maxY = ByteBufExt.readOptional(buf, class_2540::readInt);
        Optional<Integer> minY = ByteBufExt.readOptional(buf, class_2540::readInt);
        Optional<List> biomes = ByteBufExt.readOptional(buf, o -> ByteBufExt.readList(o, class_2540::method_19772));
        Optional<List> excludedBiomes = ByteBufExt.readOptional(buf, o -> ByteBufExt.readList(o, class_2540::method_19772));
        return new WeightedBlock(id, weight, dimensions.orElse(null), excludedDimensions.orElse(null), maxY.orElse(null), minY.orElse(null), null, biomes.orElse(null), excludedBiomes.orElse(null));
    }

    @Override
    @Serializer
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("id", JsonPrimitive.of(this.id));
        json.put("weight", JsonPrimitive.of(this.weight));
        json.put("dimensions", Constants.JANKSON.toJson(this.dimensions));
        json.put("excludedDimensions", Constants.JANKSON.toJson(this.excludedDimensions));
        json.put("maxY", Constants.JANKSON.toJson(this.maxY));
        json.put("minY", Constants.JANKSON.toJson(this.minY));
        json.put("biomes", Constants.JANKSON.toJson(this.biomes));
        json.put("excludedBiomes", Constants.JANKSON.toJson(this.excludedBiomes));
        return json;
    }

    @Deserializer
    public static WeightedBlock fromJson(JsonObject json) {
        ArrayList<String> excludedBiomes;
        ArrayList<String> biomes;
        JsonElement _biomes;
        ArrayList<String> excludedDimensions;
        ArrayList<String> dimensions;
        JsonElement _id = json.get("id");
        if (!(_id instanceof JsonPrimitive)) {
            return null;
        }
        String id = ((JsonPrimitive)_id).asString();
        Double weight = json.getDouble("weight", 0.0);
        JsonElement _dimensions = json.get("dimensions");
        if (_dimensions instanceof JsonArray) {
            dimensions = new ArrayList<String>();
            ((JsonArray)_dimensions).forEach(value -> dimensions.add(((JsonPrimitive)value).asString()));
        } else {
            dimensions = null;
        }
        JsonElement _excludedDimensions = json.get("excludedDimensions");
        if (_excludedDimensions instanceof JsonArray) {
            excludedDimensions = new ArrayList<String>();
            ((JsonArray)_excludedDimensions).forEach(value -> excludedDimensions.add(((JsonPrimitive)value).asString()));
        } else {
            excludedDimensions = null;
        }
        Integer maxY = null;
        JsonElement _maxY = json.get("maxY");
        if (_maxY instanceof JsonPrimitive) {
            maxY = ((JsonPrimitive)_maxY).asInt(0);
        }
        Integer minY = null;
        JsonElement _minY = json.get("minY");
        if (_minY instanceof JsonPrimitive) {
            minY = ((JsonPrimitive)_minY).asInt(0);
        }
        if ((_biomes = json.get("biomes")) instanceof JsonArray) {
            biomes = new ArrayList<String>();
            ((JsonArray)_biomes).forEach(value -> biomes.add(((JsonPrimitive)value).asString()));
        } else {
            biomes = null;
        }
        JsonElement _excludedBiomes = json.get("excludedBiomes");
        if (_excludedBiomes instanceof JsonArray) {
            excludedBiomes = new ArrayList<String>();
            ((JsonArray)_excludedBiomes).forEach(value -> excludedBiomes.add(((JsonPrimitive)value).asString()));
        } else {
            excludedBiomes = null;
        }
        return new WeightedBlock(id, weight, dimensions, excludedDimensions, maxY, minY, null, biomes, excludedBiomes);
    }

    static {
        IBootstrap.dasBoot();
    }
}

