/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data.generator;

import io.github.null2264.cobblegen.data.CGIdentifier;
import io.github.null2264.cobblegen.data.Pair;
import io.github.null2264.cobblegen.data.config.GeneratorMap;
import io.github.null2264.cobblegen.data.config.ResultList;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.data.model.BlockGenerator;
import io.github.null2264.cobblegen.data.model.Generator;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;

public class BasaltGenerator
extends BlockGenerator {
    private final GeneratorMap possibleBlocks;
    private final class_2248 block;
    private final boolean silent;

    public BasaltGenerator(ResultList possibleBlocks, class_2248 block, boolean silent) {
        this(GeneratorMap.of(Pair.of(CGIdentifier.fromMC(Util.getBlockId(class_2246.field_22090)), possibleBlocks)), block, silent);
    }

    public BasaltGenerator(GeneratorMap possibleBlocks, class_2248 block, boolean silent) {
        this.possibleBlocks = possibleBlocks;
        this.block = block;
        this.silent = silent;
    }

    public static BasaltGenerator fromString(Map<String, List<WeightedBlock>> possibleBlocks, class_2248 block, boolean silent) {
        GeneratorMap map = new GeneratorMap();
        possibleBlocks.forEach((k, v) -> map.put(CGIdentifier.of(k), new ResultList((List<WeightedBlock>)v)));
        return new BasaltGenerator(map, block, silent);
    }

    @Override
    @NotNull
    public GeneratorMap getOutput() {
        return this.possibleBlocks;
    }

    @Override
    @NotNull
    public GeneratorType getType() {
        return GeneratorType.BASALT;
    }

    @Override
    public class_3611 getFluid() {
        return null;
    }

    @Override
    @NotNull
    public class_2248 getBlock() {
        return this.block;
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    @Override
    public Optional<class_2680> tryGenerate(class_1936 level, class_2338 pos, class_2680 state, class_2350 direction) {
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        if (level.method_8320(blockPos).method_26204() == this.getBlock()) {
            return this.getBlockCandidate(level, pos, this.getOutput());
        }
        return Optional.empty();
    }

    @Override
    public void toPacket(class_2540 buf) {
        buf.method_10814(this.getClass().getName());
        buf.method_10814(Util.getBlockId(this.block).toString());
        buf.writeBoolean(this.silent);
        this.getOutput().toPacket(buf);
    }

    public static Generator fromPacket(class_2540 buf) {
        class_2248 block = Util.getBlock(buf.method_10810());
        boolean silent = buf.readBoolean();
        GeneratorMap outMap = GeneratorMap.fromPacket(buf);
        return new BasaltGenerator(outMap, block, silent);
    }

    static {
        IBootstrap.dasBoot();
    }
}

