/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data.generator;

import io.github.null2264.cobblegen.data.CGIdentifier;
import io.github.null2264.cobblegen.data.Pair;
import io.github.null2264.cobblegen.data.config.GeneratorMap;
import io.github.null2264.cobblegen.data.config.ResultList;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.data.model.BuiltInGenerator;
import io.github.null2264.cobblegen.data.model.Generator;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneGenerator
implements BuiltInGenerator {
    private final GeneratorMap possibleBlocks;
    private final class_3611 fluid;
    private final boolean silent;

    public StoneGenerator(ResultList possibleBlocks, class_3611 fluid, boolean silent) {
        this(GeneratorMap.of(Pair.of(CGIdentifier.wildcard(), possibleBlocks)), fluid, silent);
    }

    public StoneGenerator(GeneratorMap possibleBlocks, class_3611 fluid, boolean silent) {
        this.possibleBlocks = possibleBlocks;
        this.fluid = fluid;
        this.silent = silent;
    }

    public static StoneGenerator fromString(Map<String, List<WeightedBlock>> possibleBlocks, class_3611 fluid, boolean silent) {
        GeneratorMap map = new GeneratorMap();
        possibleBlocks.forEach((k, v) -> map.put(CGIdentifier.of(k), new ResultList((List<WeightedBlock>)v)));
        return new StoneGenerator(map, fluid, silent);
    }

    @Override
    @NotNull
    public GeneratorMap getOutput() {
        return this.possibleBlocks;
    }

    @Override
    public GeneratorMap getObsidianOutput() {
        return GeneratorMap.of(Pair.of(CGIdentifier.wildcard(), ResultList.of(WeightedBlock.fromBlock(class_2246.field_10340, 100.0))));
    }

    @Override
    @NotNull
    public GeneratorType getType() {
        return GeneratorType.STONE;
    }

    @Override
    public class_3611 getFluid() {
        return this.fluid;
    }

    @Override
    @Nullable
    public class_2248 getBlock() {
        return null;
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    @Override
    public boolean check(class_1936 level, class_2338 pos, class_2680 state, boolean fromTop) {
        return fromTop;
    }

    @Override
    public Optional<class_2680> tryGenerate(class_1936 level, class_2338 pos, class_2680 state) {
        return this.tryGenerate(level, pos, state.method_26227(), level.method_8316(pos));
    }

    @Override
    public Optional<class_2680> tryGenerate(class_1936 level, class_2338 pos, class_3610 source, class_3610 neighbour) {
        class_3611 fluid = Generator.getStillFluid(neighbour);
        if (this.getFluid() == fluid) {
            return this.getBlockCandidate(level, pos, this.getOutput());
        }
        return Optional.empty();
    }

    @Override
    public void toPacket(class_2540 buf) {
        buf.method_10814(this.getClass().getName());
        buf.method_10812(Util.getFluidId(this.fluid));
        buf.writeBoolean(this.silent);
        this.getOutput().toPacket(buf);
    }

    public static Generator fromPacket(class_2540 buf) {
        class_3611 fluid = Util.getFluid(buf.method_10810());
        boolean silent = buf.readBoolean();
        GeneratorMap outMap = GeneratorMap.fromPacket(buf);
        return new StoneGenerator(outMap, fluid, silent);
    }

    static {
        IBootstrap.dasBoot();
    }
}

