/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data.model;

import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.cobblegen.data.CGIdentifier;
import io.github.null2264.cobblegen.data.config.GeneratorMap;
import io.github.null2264.cobblegen.data.config.ResultList;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.data.model.Generator;
import io.github.null2264.cobblegen.util.Util;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface BuiltInGenerator
extends Generator {
    @ApiStatus.Internal
    default public String randomizeBlockId(class_2248 key, String dim, Integer yLevel, GeneratorMap candidates, @Nullable String biome) {
        int idx;
        ResultList blockIds = candidates.getOrDefault(CGIdentifier.fromMC(Util.getBlockId(key)), candidates.getOrDefault(CGIdentifier.wildcard(), new ResultList()));
        ResultList filteredBlockIds = new ResultList();
        AtomicReference<Double> totalWeight = new AtomicReference<Double>(0.0);
        for (WeightedBlock block : blockIds) {
            if (block.dimensions != null && !block.dimensions.contains(dim) || block.excludedDimensions != null && block.excludedDimensions.contains(dim) || biome != null && CobbleGen.META_CONFIG.enableExperimentalFeatures.booleanValue() && (block.biomes != null && !block.biomes.contains(biome) || block.excludedBiomes != null && block.excludedBiomes.contains(biome)) || block.maxY != null && block.maxY.compareTo(yLevel) <= 0 || block.minY != null && block.minY.compareTo(yLevel) >= 0) continue;
            if (block.id.startsWith("#")) {
                try {
                    List<class_2960> taggedBlocks = Util.getTaggedBlockIds(class_2960.method_12829((String)block.id.substring(1)));
                    for (class_2960 taggedBlock : taggedBlocks) {
                        filteredBlockIds.add(new WeightedBlock(taggedBlock.toString(), block.weight));
                        totalWeight.updateAndGet(v -> v + block.weight);
                    }
                    continue;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            filteredBlockIds.add(block);
            totalWeight.updateAndGet(v -> v + block.weight);
        }
        if (filteredBlockIds.isEmpty()) {
            return null;
        }
        if (filteredBlockIds.size() == 1) {
            return ((WeightedBlock)filteredBlockIds.get((int)0)).id;
        }
        double r = Math.random() * totalWeight.get();
        for (idx = 0; idx < filteredBlockIds.size() - 1 && !((r -= ((WeightedBlock)filteredBlockIds.get((int)idx)).weight.doubleValue()) <= 0.0); ++idx) {
        }
        return ((WeightedBlock)filteredBlockIds.get((int)idx)).id;
    }

    default public Optional<class_2680> getBlockCandidate(class_1936 level, class_2338 pos, GeneratorMap candidates) {
        return this.getBlockCandidate(level, pos, candidates, null);
    }

    default public Optional<class_2680> getBlockCandidate(class_1936 level, class_2338 pos, GeneratorMap candidates, class_2248 defaultBlock) {
        class_2960 id;
        String replacementId = this.randomizeBlockId(level.method_8320(pos.method_10074()).method_26204(), Util.getDimension(level), pos.method_10264(), candidates, Util.getBiome(level, pos));
        if (replacementId == null) {
            if (defaultBlock != null) {
                return Optional.of(defaultBlock.method_9564());
            }
            return Optional.empty();
        }
        try {
            id = class_2960.method_12829((String)replacementId);
        }
        catch (Exception e) {
            id = Util.identifierOf(replacementId);
        }
        return Optional.of(Util.getBlock(id).method_9564());
    }
}

