/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.shadowed.log4j.slf4j;

import io.github.null2264.shadowed.log4j.log4j.Logger;
import io.github.null2264.shadowed.log4j.log4j.Marker;
import io.github.null2264.shadowed.log4j.log4j.MarkerManager;
import io.github.null2264.shadowed.log4j.log4j.status.StatusLogger;
import io.github.null2264.shadowed.log4j.slf4j.Log4jMarker;
import io.github.null2264.shadowed.slf4j.IMarkerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Log4jMarkerFactory
implements IMarkerFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final ConcurrentMap<String, io.github.null2264.shadowed.slf4j.Marker> markerMap = new ConcurrentHashMap<String, io.github.null2264.shadowed.slf4j.Marker>();

    @Override
    public io.github.null2264.shadowed.slf4j.Marker getMarker(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Marker name must not be null");
        }
        io.github.null2264.shadowed.slf4j.Marker marker = (io.github.null2264.shadowed.slf4j.Marker)this.markerMap.get(name);
        if (marker != null) {
            return marker;
        }
        Marker log4jMarker = MarkerManager.getMarker(name);
        return this.addMarkerIfAbsent(name, log4jMarker);
    }

    private io.github.null2264.shadowed.slf4j.Marker addMarkerIfAbsent(String name, Marker log4jMarker) {
        Log4jMarker marker = new Log4jMarker(log4jMarker);
        io.github.null2264.shadowed.slf4j.Marker existing = this.markerMap.putIfAbsent(name, marker);
        return existing == null ? marker : existing;
    }

    public io.github.null2264.shadowed.slf4j.Marker getMarker(io.github.null2264.shadowed.slf4j.Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException("Marker must not be null");
        }
        io.github.null2264.shadowed.slf4j.Marker m = (io.github.null2264.shadowed.slf4j.Marker)this.markerMap.get(marker.getName());
        if (m != null) {
            return m;
        }
        return this.addMarkerIfAbsent(marker.getName(), Log4jMarkerFactory.convertMarker(marker));
    }

    private static Marker convertMarker(io.github.null2264.shadowed.slf4j.Marker original) {
        if (original == null) {
            throw new IllegalArgumentException("Marker must not be null");
        }
        return Log4jMarkerFactory.convertMarker(original, new ArrayList<io.github.null2264.shadowed.slf4j.Marker>());
    }

    private static Marker convertMarker(io.github.null2264.shadowed.slf4j.Marker original, Collection<io.github.null2264.shadowed.slf4j.Marker> visited) {
        Marker marker = MarkerManager.getMarker(original.getName());
        if (original.hasReferences()) {
            Iterator<io.github.null2264.shadowed.slf4j.Marker> it = original.iterator();
            while (it.hasNext()) {
                io.github.null2264.shadowed.slf4j.Marker next = it.next();
                if (visited.contains(next)) {
                    LOGGER.warn("Found a cycle in Marker [{}]. Cycle will be broken.", (Object)next.getName());
                    continue;
                }
                visited.add(next);
                marker.addParents(Log4jMarkerFactory.convertMarker(next, visited));
            }
        }
        return marker;
    }

    @Override
    public boolean exists(String name) {
        return this.markerMap.containsKey(name);
    }

    @Override
    public boolean detachMarker(String name) {
        return false;
    }

    @Override
    public io.github.null2264.shadowed.slf4j.Marker getDetachedMarker(String name) {
        LOGGER.warn("Log4j does not support detached Markers. Returned Marker [{}] will be unchanged.", (Object)name);
        return this.getMarker(name);
    }
}

