/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.shadowed.manifold.ext.rt.proxy;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;

final class WeakCache<K, P, V> {
    private final ReferenceQueue<K> refQueue = new ReferenceQueue();
    private final ConcurrentMap<Object, ConcurrentMap<Object, Supplier<V>>> map = new ConcurrentHashMap<Object, ConcurrentMap<Object, Supplier<V>>>();
    private final ConcurrentMap<Supplier<V>, Boolean> reverseMap = new ConcurrentHashMap<Supplier<V>, Boolean>();
    private final BiFunction<K, P, ?> subKeyFactory;
    private final BiFunction<K, P, V> valueFactory;

    public WeakCache(BiFunction<K, P, ?> subKeyFactory, BiFunction<K, P, V> valueFactory) {
        this.subKeyFactory = Objects.requireNonNull(subKeyFactory);
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    public V get(K key, P parameter) {
        ConcurrentMap oldValuesMap;
        Objects.requireNonNull(parameter);
        this.expungeStaleEntries();
        Object cacheKey = CacheKey.valueOf(key, this.refQueue);
        ConcurrentMap<Object, Supplier<Factory>> valuesMap = (ConcurrentHashMap)this.map.get(cacheKey);
        if (valuesMap == null && (oldValuesMap = (ConcurrentMap)this.map.putIfAbsent(cacheKey, valuesMap = new ConcurrentHashMap())) != null) {
            valuesMap = oldValuesMap;
        }
        Object subKey = Objects.requireNonNull(this.subKeyFactory.apply(key, parameter));
        Supplier supplier = (Supplier)valuesMap.get(subKey);
        Factory factory = null;
        Object value;
        while (supplier == null || (value = supplier.get()) == null) {
            if (factory == null) {
                factory = new Factory(key, parameter, subKey, valuesMap);
            }
            if (supplier == null) {
                supplier = valuesMap.putIfAbsent(subKey, factory);
                if (supplier != null) continue;
                supplier = factory;
                continue;
            }
            if (valuesMap.replace(subKey, supplier, factory)) {
                supplier = factory;
                continue;
            }
            supplier = (Supplier)valuesMap.get(subKey);
        }
        return (V)value;
    }

    public boolean containsValue(V value) {
        Objects.requireNonNull(value);
        this.expungeStaleEntries();
        return this.reverseMap.containsKey(new LookupValue<V>(value));
    }

    public int size() {
        this.expungeStaleEntries();
        return this.reverseMap.size();
    }

    private void expungeStaleEntries() {
        CacheKey cacheKey;
        while ((cacheKey = (CacheKey)this.refQueue.poll()) != null) {
            cacheKey.expungeFrom(this.map, this.reverseMap);
        }
    }

    private static final class CacheKey<K>
    extends WeakReference<K> {
        private static final Object NULL_KEY = new Object();
        private final int hash;

        static <K> Object valueOf(K key, ReferenceQueue<K> refQueue) {
            return key == null ? NULL_KEY : new CacheKey<K>(key, refQueue);
        }

        private CacheKey(K key, ReferenceQueue<K> refQueue) {
            super(key, refQueue);
            this.hash = System.identityHashCode(key);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            Object key;
            return obj == this || obj != null && obj.getClass() == this.getClass() && (key = this.get()) != null && key == ((CacheKey)obj).get();
        }

        void expungeFrom(ConcurrentMap<?, ? extends ConcurrentMap<?, ?>> map, ConcurrentMap<?, Boolean> reverseMap) {
            ConcurrentMap valuesMap = (ConcurrentMap)map.remove(this);
            if (valuesMap != null) {
                for (Object cacheValue : valuesMap.values()) {
                    reverseMap.remove(cacheValue);
                }
            }
        }
    }

    private static final class CacheValue<V>
    extends WeakReference<V>
    implements Value<V> {
        private final int hash;

        CacheValue(V value) {
            super(value);
            this.hash = System.identityHashCode(value);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            Object value;
            return obj == this || obj instanceof Value && (value = this.get()) != null && value == ((Value)obj).get();
        }
    }

    private static final class LookupValue<V>
    implements Value<V> {
        private final V value;

        LookupValue(V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }

        public int hashCode() {
            return System.identityHashCode(this.value);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Value && this.value == ((Value)obj).get();
        }
    }

    private static interface Value<V>
    extends Supplier<V> {
    }

    private final class Factory
    implements Supplier<V> {
        private final K key;
        private final P parameter;
        private final Object subKey;
        private final ConcurrentMap<Object, Supplier<V>> valuesMap;

        Factory(K key, P parameter, Object subKey, ConcurrentMap<Object, Supplier<V>> valuesMap) {
            this.key = key;
            this.parameter = parameter;
            this.subKey = subKey;
            this.valuesMap = valuesMap;
        }

        @Override
        public synchronized V get() {
            Supplier supplier = (Supplier)this.valuesMap.get(this.subKey);
            if (supplier != this) {
                return null;
            }
            Object value = null;
            try {
                value = Objects.requireNonNull(WeakCache.this.valueFactory.apply(this.key, this.parameter));
            }
            finally {
                if (value == null) {
                    this.valuesMap.remove(this.subKey, this);
                }
            }
            assert (value != null);
            CacheValue<Object> cacheValue = new CacheValue<Object>(value);
            WeakCache.this.reverseMap.put(cacheValue, Boolean.TRUE);
            if (!this.valuesMap.replace(this.subKey, this, cacheValue)) {
                throw new AssertionError((Object)"Should not reach here");
            }
            return value;
        }
    }
}

