/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen;

import io.github.null2264.cobblegen.CobbleGenPlugin;
import io.github.null2264.cobblegen.compat.CollectionCompat;
import io.github.null2264.cobblegen.data.CGRegistryImpl;
import io.github.null2264.cobblegen.data.config.ConfigHolder;
import io.github.null2264.cobblegen.data.model.Generator;
import io.github.null2264.cobblegen.network.payload.CGSyncS2CPayload;
import io.github.null2264.cobblegen.util.CGLog;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.PluginFinder;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidInteraction {
    private final Map<Fluid, List<Generator>> generatorMap = new HashMap<Fluid, List<Generator>>();
    @Nullable
    private Map<Fluid, List<Generator>> serverGeneratorMap = null;
    private boolean firstInit = true;
    private boolean shouldReload = true;
    private final AtomicInteger count = new AtomicInteger();

    @ApiStatus.AvailableSince(value="4.0")
    public void addGenerator(Fluid fluid, Generator generator) {
        Fluid genFluid = generator.getFluid();
        if (genFluid != null && genFluid == Fluids.EMPTY) {
            CGLog.warn("EMPTY fluid is detected! Skipping...", new String[0]);
            return;
        }
        if (genFluid instanceof FlowingFluid) {
            generator.setFluid(((FlowingFluid)genFluid).getSource());
        }
        this.generatorMap.computeIfAbsent(fluid, g -> new ArrayList()).add(generator);
        this.count.incrementAndGet();
    }

    public Map<Fluid, List<Generator>> getLocalGenerators() {
        return this.generatorMap;
    }

    @NotNull
    public Map<Fluid, List<Generator>> getGenerators() {
        return Util.notNullOr(this.serverGeneratorMap, this.generatorMap);
    }

    @ApiStatus.Internal
    public boolean isSync() {
        return this.serverGeneratorMap != null;
    }

    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.Internal
    public void writeGeneratorsToPacket(FriendlyByteBuf buf) {
        FluidInteraction.write(this.generatorMap, buf);
    }

    @ApiStatus.Internal
    public void readGeneratorsFromPacket(FriendlyByteBuf buf) {
        this.serverGeneratorMap = FluidInteraction.read(buf);
    }

    @ApiStatus.Internal
    public void readGeneratorsFromPayload(CGSyncS2CPayload payload) {
        this.serverGeneratorMap = payload.recipe();
    }

    @ApiStatus.Internal
    public void disconnect() {
        this.serverGeneratorMap = null;
    }

    @ApiStatus.Internal
    public void apply() {
        if (this.shouldReload) {
            CGLog.info(this.firstInit ? "Loading" : "Reloading", "generators...");
            this.generatorMap.clear();
            this.count.set(0);
            CGRegistryImpl registry = new CGRegistryImpl();
            for (PluginFinder.PlugInContainer container : PluginFinder.getModPlugins()) {
                String id = container.getModId();
                CobbleGenPlugin plugin = container.getPlugin();
                if (!plugin.shouldLoad()) continue;
                CGLog.info(this.firstInit ? "Loading" : "Reloading", "plugin from", id);
                try {
                    if (!this.firstInit) {
                        plugin.onReload();
                    }
                    plugin.registerInteraction(registry);
                }
                catch (Throwable err) {
                    CGLog.warn("Something went wrong while", this.firstInit ? "loading" : "reloading", "plugin provided by", id);
                    CGLog.error(err);
                    continue;
                }
                CGLog.info(this.firstInit ? "Loaded" : "Reloaded", "plugin from", id);
            }
            CGLog.info(String.valueOf(this.count.get()), "generators has been", this.firstInit ? "loaded" : "reloaded");
            if (this.firstInit) {
                this.firstInit = false;
            }
            this.shouldReload = false;
        }
    }

    @ApiStatus.Internal
    public void reload() {
        this.shouldReload = true;
        this.apply();
    }

    @ApiStatus.Internal
    public boolean interact(LevelAccessor level, BlockPos pos, BlockState state) {
        return this.interact(level, pos, state, false);
    }

    @ApiStatus.Internal
    public boolean interact(LevelAccessor level, BlockPos pos, BlockState state, boolean fromTop) {
        FluidState fluidState = state.getFluidState();
        Fluid fluid = Generator.getStillFluid(fluidState);
        List<Generator> generators = this.generatorMap.getOrDefault(fluid, CollectionCompat.listOf(new Generator[0]));
        for (Generator generator : generators) {
            Optional<BlockState> result;
            if (!generator.check(level, pos, state, fromTop) || fromTop && generator.getType() != GeneratorType.STONE || !(result = generator.tryGenerate(level, pos, state)).isPresent()) continue;
            level.setBlock(pos, result.get(), 3);
            if (!generator.isSilent()) {
                level.levelEvent(1501, pos, 0);
            }
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public Optional<BlockState> interactFromPipeState(Level level, BlockPos pos, Fluid fluid1, Fluid fluid2) {
        Fluid neighbour;
        Fluid source;
        if (ConfigHolder.META.create.disablePipe.booleanValue()) {
            return Optional.empty();
        }
        List<Generator> generators = this.generatorMap.get(fluid1 instanceof FlowingFluid ? ((FlowingFluid)fluid1).getSource() : fluid1);
        if (generators == null) {
            generators = this.generatorMap.get(fluid2 instanceof FlowingFluid ? ((FlowingFluid)fluid2).getSource() : fluid2);
            if (generators == null) {
                return Optional.empty();
            }
            source = fluid2;
            neighbour = fluid1;
        } else {
            source = fluid1;
            neighbour = fluid2;
        }
        for (Generator generator : generators) {
            Optional<BlockState> result;
            boolean fromTop = false;
            if (neighbour instanceof FlowingFluid) {
                boolean bl = fromTop = neighbour == ((FlowingFluid)neighbour).getSource();
            }
            if (!generator.check((LevelAccessor)level, pos, source.defaultFluidState().createLegacyBlock(), fromTop)) continue;
            if (source == Fluids.LAVA) {
                source = ((FlowingFluid)source).getFlowing();
            }
            if (!(result = generator.tryGenerate((LevelAccessor)level, pos, source.defaultFluidState(), neighbour.defaultFluidState())).isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public boolean interactFromPipe(Level level, BlockPos pos, Fluid fluid1, Fluid fluid2) {
        Optional<BlockState> result = this.interactFromPipeState(level, pos, fluid1, fluid2);
        if (result.isPresent()) {
            level.setBlockAndUpdate(pos, result.get());
            return true;
        }
        return false;
    }

    public static void write(Map<Fluid, List<Generator>> generatorMap, FriendlyByteBuf buf) {
        buf.writeMap(generatorMap, (b, o) -> b.writeResourceLocation(Util.getFluidId(o)), (b, generators) -> b.writeCollection((Collection)generators, (p, gen) -> gen.toPacket((FriendlyByteBuf)p)));
    }

    @ApiStatus.Internal
    public static Map<Fluid, List<Generator>> read(FriendlyByteBuf buf) {
        return buf.readMap(o -> Util.getFluid(o.readResourceLocation()), o -> {
            int _gensSize = o.readVarInt();
            ArrayList<Generator> gens = new ArrayList<Generator>(_gensSize);
            for (int j = 0; j < _gensSize; ++j) {
                Generator generator = Generator.fromPacket(o);
                if (generator == null) {
                    CGLog.warn("Failed to retrieve a generator, skipping...", new String[0]);
                    continue;
                }
                gens.add(generator);
            }
            return gens;
        });
    }

    static {
        IBootstrap.dasBoot();
    }
}

