/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.compat;

import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.nio.file.Path;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LoadingModList;

public class LoaderCompat {
    public static boolean isModLoaded(String mod) {
        ModList modlist = ModList.get();
        if (modlist == null) {
            return LoadingModList.get().getModFileById(mod) != null;
        }
        return modlist.isLoaded(mod);
    }

    public static Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static LoaderType getType() {
        return LoaderType.NEOFORGE;
    }

    public static Boolean isFabric() {
        return LoaderCompat.getType() == LoaderType.FABRIC;
    }

    public static Boolean isQuilt() {
        return LoaderCompat.getType() == LoaderType.QUILT;
    }

    public static Boolean isFabricLike() {
        return LoaderCompat.isFabric() != false || LoaderCompat.isQuilt() != false;
    }

    public static Boolean isForge() {
        return LoaderCompat.getType() == LoaderType.FORGE;
    }

    public static Boolean isNeoForge() {
        return LoaderCompat.getType() == LoaderType.NEOFORGE;
    }

    public static Boolean isForgeLike() {
        return LoaderCompat.isForge() != false || LoaderCompat.isNeoForge() != false;
    }

    static {
        IBootstrap.dasBoot();
    }

    public static enum LoaderType {
        FABRIC,
        QUILT,
        FORGE,
        NEOFORGE;


        static {
            IBootstrap.dasBoot();
        }
    }
}

