/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.compat;

import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.neoforgespi.language.IModInfo;

public class ModContainerCompat {
    public static ConcurrentMap<String, ModContainerCompat> CACHED;
    private final IModInfo container;

    private ModContainerCompat(String modid) {
        IModInfo modInfo = ModList.get() == null ? LoadingModList.get().getModFileById(modid).getMods().stream().filter(i -> i.getModId().equals(modid)).findFirst().orElseThrow() : ((ModContainer)ModList.get().getModContainerById(modid).orElseThrow()).getModInfo();
        this.container = modInfo;
    }

    public static ModContainerCompat fromLoader(String modid) {
        if (CACHED.containsKey(modid)) {
            return (ModContainerCompat)CACHED.get(modid);
        }
        ModContainerCompat rt = new ModContainerCompat(modid);
        CACHED.put(modid, new ModContainerCompat(modid));
        return rt;
    }

    public String getVersionString() {
        return this.container.getVersion().toString();
    }

    static {
        IBootstrap.dasBoot();
        CACHED = new ConcurrentHashMap<String, ModContainerCompat>();
    }
}

