/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data.config;

import io.github.null2264.cobblegen.data.config.Config;
import io.github.null2264.cobblegen.data.config.ConfigHolder;
import io.github.null2264.cobblegen.util.CGLog;
import io.github.null2264.shadowed.jankson.Jankson;
import io.github.null2264.shadowed.jankson.JsonArray;
import io.github.null2264.shadowed.jankson.JsonElement;
import io.github.null2264.shadowed.jankson.JsonGrammar;
import io.github.null2264.shadowed.jankson.JsonNull;
import io.github.null2264.shadowed.jankson.JsonObject;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ConfigHelper {
    @ApiStatus.Internal
    public static <T extends Config> T loadConfig(boolean reload, File configFile, T workingConfig, T defaultConfig, Class<T> clazz) {
        String string = reload ? "reload" : "load";
        try {
            CGLog.info("Trying to " + string + " config file...", new String[0]);
            JsonObject json = ConfigHolder.JANKSON.load(configFile);
            return (T)((Config)ConfigHolder.JANKSON.fromJson(json, clazz));
        }
        catch (Exception e) {
            CGLog.error("There was an error while " + string + "ing the config file!\n" + String.valueOf(e), new String[0]);
            if (reload && workingConfig != null) {
                CGLog.warn("Falling back to previously working config...", new String[0]);
                return workingConfig;
            }
            if (!configFile.exists()) {
                ConfigHelper.saveConfig(defaultConfig, configFile);
            }
            CGLog.warn("Falling back to default config...", new String[0]);
            return defaultConfig;
        }
    }

    @Deprecated
    @Nullable
    private static JsonElement filter(JsonElement json) {
        JsonElement result = null;
        if (json instanceof JsonObject) {
            JsonObject finalResult = (JsonObject)json;
            finalResult.keySet().forEach(key -> {
                JsonElement element = finalResult.get(key);
                if (!(element instanceof JsonNull) && element != null) {
                    ConfigHelper.filter(element);
                } else {
                    finalResult.remove(key);
                }
            });
            result = finalResult;
        } else if (json instanceof JsonArray) {
            JsonArray finalResult = (JsonArray)json;
            finalResult.forEach(element -> {
                if (element instanceof JsonObject) {
                    ConfigHelper.filter(element);
                }
            });
            result = finalResult;
        }
        return result;
    }

    private static void saveConfig(Config config, File configFile) {
        try {
            CGLog.info("Trying to create config file...", new String[0]);
            FileWriter fw = new FileWriter(configFile);
            JsonElement jsonElement = Jankson.builder().build().toJson(config);
            JsonElement filteredElement = ConfigHelper.filter(jsonElement);
            fw.write((filteredElement != null ? filteredElement : jsonElement).toJson(JsonGrammar.JSON5));
            fw.close();
        }
        catch (IOException e) {
            CGLog.error("There was an error while creating the config file!\n" + String.valueOf(e), new String[0]);
        }
    }

    static {
        IBootstrap.dasBoot();
    }
}

