/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data.config;

import io.github.null2264.cobblegen.data.JanksonSerializable;
import io.github.null2264.cobblegen.data.config.ConfigHolder;
import io.github.null2264.cobblegen.data.model.PacketSerializable;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.jankson.JsonArray;
import io.github.null2264.shadowed.jankson.JsonElement;
import io.github.null2264.shadowed.jankson.JsonObject;
import io.github.null2264.shadowed.jankson.JsonPrimitive;
import io.github.null2264.shadowed.jankson.annotation.Deserializer;
import io.github.null2264.shadowed.jankson.annotation.Serializer;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class WeightedBlock
implements PacketSerializable<WeightedBlock>,
JanksonSerializable {
    public String id;
    public Double weight;
    @Nullable
    public List<String> dimensions;
    @Nullable
    public List<String> excludedDimensions;
    @Nullable
    public Integer maxY;
    @Nullable
    public Integer minY;
    @Nullable
    public List<String> neighbours;
    @Nullable
    public List<String> biomes;
    @Nullable
    public List<String> excludedBiomes;

    public WeightedBlock(String id, Double weight) {
        this(id, weight, null, null);
    }

    public WeightedBlock(String id, Double weight, List<String> dimIds) {
        this(id, weight, dimIds, null);
    }

    public WeightedBlock(String id, Double weight, List<String> dimIds, List<String> excludedDimensions) {
        this(id, weight, dimIds, excludedDimensions, null, null, null, null, null);
    }

    public WeightedBlock(String id, Double weight, @Nullable List<String> dimIds, @Nullable List<String> excludedDimensions, @Nullable Integer maxY, @Nullable Integer minY, @Nullable List<String> neighbours, @Nullable List<String> biomes, @Nullable List<String> excludedBiomes) {
        this.id = id;
        this.weight = weight;
        this.dimensions = dimIds;
        this.excludedDimensions = excludedDimensions;
        this.maxY = maxY;
        this.minY = minY;
        this.neighbours = neighbours;
        this.biomes = biomes;
        this.excludedBiomes = excludedBiomes;
    }

    public static WeightedBlock fromBlock(Block block, Double weight) {
        return WeightedBlock.fromBlock(block, weight, null, null, null, null);
    }

    public static WeightedBlock fromBlock(Block block, Double weight, List<String> dimIds, List<String> excludedDimensions, Integer maxY, Integer minY) {
        String id = Util.getBlockId(block).toString();
        return new WeightedBlock(id, weight, dimIds, excludedDimensions, maxY, minY, null, null, null);
    }

    public Block getBlock() {
        return Util.getBlock(ResourceLocation.tryParse((String)this.id));
    }

    public Optional<List<String>> getDimensions() {
        return Util.optional(this.dimensions);
    }

    public Optional<List<String>> getExcludedDimensions() {
        return Util.optional(this.excludedDimensions);
    }

    public Optional<Integer> getMaxY() {
        return Util.optional(this.maxY);
    }

    public Optional<Integer> getMinY() {
        return Util.optional(this.minY);
    }

    public Optional<List<String>> getBiomes() {
        return Util.optional(this.biomes);
    }

    public Optional<List<String>> getExcludedBiomes() {
        return Util.optional(this.excludedBiomes);
    }

    @Override
    public void toPacket(FriendlyByteBuf buf) {
        buf.writeUtf(this.id);
        buf.writeDouble(this.weight.doubleValue());
        buf.writeOptional(Util.optional(this.dimensions), (o, value) -> o.writeCollection((Collection)value, FriendlyByteBuf::writeUtf));
        buf.writeOptional(Util.optional(this.excludedDimensions), (o, value) -> o.writeCollection((Collection)value, FriendlyByteBuf::writeUtf));
        buf.writeOptional(Util.optional(this.maxY), FriendlyByteBuf::writeInt);
        buf.writeOptional(Util.optional(this.minY), FriendlyByteBuf::writeInt);
        buf.writeOptional(Util.optional(this.biomes), (o, value) -> o.writeCollection((Collection)value, FriendlyByteBuf::writeUtf));
        buf.writeOptional(Util.optional(this.excludedBiomes), (o, value) -> o.writeCollection((Collection)value, FriendlyByteBuf::writeUtf));
    }

    public static WeightedBlock fromPacket(FriendlyByteBuf buf) {
        String id = buf.readUtf();
        Double weight = buf.readDouble();
        Optional dimensions = buf.readOptional(o -> o.readList(FriendlyByteBuf::readUtf));
        Optional excludedDimensions = buf.readOptional(o -> o.readList(FriendlyByteBuf::readUtf));
        Optional maxY = buf.readOptional(FriendlyByteBuf::readInt);
        Optional minY = buf.readOptional(FriendlyByteBuf::readInt);
        Optional biomes = buf.readOptional(o -> o.readList(FriendlyByteBuf::readUtf));
        Optional excludedBiomes = buf.readOptional(o -> o.readList(FriendlyByteBuf::readUtf));
        return new WeightedBlock(id, weight, dimensions.orElse(null), excludedDimensions.orElse(null), maxY.orElse(null), minY.orElse(null), null, biomes.orElse(null), excludedBiomes.orElse(null));
    }

    @Override
    @Serializer
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("id", JsonPrimitive.of(this.id));
        json.put("weight", JsonPrimitive.of(this.weight));
        json.put("dimensions", ConfigHolder.JANKSON.toJson(this.dimensions));
        json.put("excludedDimensions", ConfigHolder.JANKSON.toJson(this.excludedDimensions));
        json.put("maxY", ConfigHolder.JANKSON.toJson(this.maxY));
        json.put("minY", ConfigHolder.JANKSON.toJson(this.minY));
        json.put("biomes", ConfigHolder.JANKSON.toJson(this.biomes));
        json.put("excludedBiomes", ConfigHolder.JANKSON.toJson(this.excludedBiomes));
        return json;
    }

    @Deserializer
    public static WeightedBlock fromJson(JsonObject json) {
        ArrayList<String> excludedBiomes;
        ArrayList<String> biomes;
        JsonElement _biomes;
        ArrayList<String> excludedDimensions;
        ArrayList<String> dimensions;
        JsonElement _id = json.get("id");
        if (!(_id instanceof JsonPrimitive)) {
            return null;
        }
        String id = ((JsonPrimitive)_id).asString();
        Double weight = json.getDouble("weight", 0.0);
        JsonElement _dimensions = json.get("dimensions");
        if (_dimensions instanceof JsonArray) {
            dimensions = new ArrayList<String>();
            ((JsonArray)_dimensions).forEach(value -> dimensions.add(((JsonPrimitive)value).asString()));
        } else {
            dimensions = null;
        }
        JsonElement _excludedDimensions = json.get("excludedDimensions");
        if (_excludedDimensions instanceof JsonArray) {
            excludedDimensions = new ArrayList<String>();
            ((JsonArray)_excludedDimensions).forEach(value -> excludedDimensions.add(((JsonPrimitive)value).asString()));
        } else {
            excludedDimensions = null;
        }
        Integer maxY = null;
        JsonElement _maxY = json.get("maxY");
        if (_maxY instanceof JsonPrimitive) {
            maxY = ((JsonPrimitive)_maxY).asInt(0);
        }
        Integer minY = null;
        JsonElement _minY = json.get("minY");
        if (_minY instanceof JsonPrimitive) {
            minY = ((JsonPrimitive)_minY).asInt(0);
        }
        if ((_biomes = json.get("biomes")) instanceof JsonArray) {
            biomes = new ArrayList<String>();
            ((JsonArray)_biomes).forEach(value -> biomes.add(((JsonPrimitive)value).asString()));
        } else {
            biomes = null;
        }
        JsonElement _excludedBiomes = json.get("excludedBiomes");
        if (_excludedBiomes instanceof JsonArray) {
            excludedBiomes = new ArrayList<String>();
            ((JsonArray)_excludedBiomes).forEach(value -> excludedBiomes.add(((JsonPrimitive)value).asString()));
        } else {
            excludedBiomes = null;
        }
        return new WeightedBlock(id, weight, dimensions, excludedDimensions, maxY, minY, null, biomes, excludedBiomes);
    }

    static {
        IBootstrap.dasBoot();
    }
}

