/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data.generator;

import io.github.null2264.cobblegen.data.CGIdentifier;
import io.github.null2264.cobblegen.data.Pair;
import io.github.null2264.cobblegen.data.config.GeneratorMap;
import io.github.null2264.cobblegen.data.config.ResultList;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.data.model.BuiltInGenerator;
import io.github.null2264.cobblegen.data.model.Generator;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneGenerator
implements BuiltInGenerator {
    private final GeneratorMap possibleBlocks;
    private final Fluid fluid;
    private final boolean silent;

    public StoneGenerator(ResultList possibleBlocks, Fluid fluid, boolean silent) {
        this(GeneratorMap.of(Pair.of(CGIdentifier.wildcard(), possibleBlocks)), fluid, silent);
    }

    public StoneGenerator(GeneratorMap possibleBlocks, Fluid fluid, boolean silent) {
        this.possibleBlocks = possibleBlocks;
        this.fluid = fluid;
        this.silent = silent;
    }

    public static StoneGenerator fromString(Map<String, List<WeightedBlock>> possibleBlocks, Fluid fluid, boolean silent) {
        GeneratorMap map = new GeneratorMap();
        possibleBlocks.forEach((k, v) -> map.put(CGIdentifier.of(k), new ResultList((List<WeightedBlock>)v)));
        return new StoneGenerator(map, fluid, silent);
    }

    @Override
    @NotNull
    public GeneratorMap getOutput() {
        return this.possibleBlocks;
    }

    @Override
    public GeneratorMap getObsidianOutput() {
        return GeneratorMap.of(Pair.of(CGIdentifier.wildcard(), ResultList.of(WeightedBlock.fromBlock(Blocks.STONE, 100.0))));
    }

    @Override
    @NotNull
    public GeneratorType getType() {
        return GeneratorType.STONE;
    }

    @Override
    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    @Nullable
    public Block getBlock() {
        return null;
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    @Override
    public boolean check(LevelAccessor level, BlockPos pos, BlockState state, boolean fromTop) {
        return fromTop;
    }

    @Override
    public Optional<BlockState> tryGenerate(LevelAccessor level, BlockPos pos, BlockState state) {
        return this.tryGenerate(level, pos, state.getFluidState(), level.getFluidState(pos));
    }

    @Override
    public Optional<BlockState> tryGenerate(LevelAccessor level, BlockPos pos, FluidState source, FluidState neighbour) {
        Fluid fluid = Generator.getStillFluid(neighbour);
        if (this.getFluid() == fluid) {
            return this.getBlockCandidate(level, pos, this.getOutput());
        }
        return Optional.empty();
    }

    @Override
    public void toPacket(FriendlyByteBuf buf) {
        buf.writeUtf(this.getClass().getName());
        buf.writeResourceLocation(Util.getFluidId(this.fluid));
        buf.writeBoolean(this.silent);
        this.getOutput().toPacket(buf);
    }

    public static Generator fromPacket(FriendlyByteBuf buf) {
        Fluid fluid = Util.getFluid(buf.readResourceLocation());
        boolean silent = buf.readBoolean();
        GeneratorMap outMap = GeneratorMap.fromPacket(buf);
        return new StoneGenerator(outMap, fluid, silent);
    }

    static {
        IBootstrap.dasBoot();
    }
}

