/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data.model;

import io.github.null2264.cobblegen.data.Pair;
import io.github.null2264.cobblegen.data.config.GeneratorMap;
import io.github.null2264.cobblegen.data.model.PacketSerializable;
import io.github.null2264.cobblegen.extensions.net.minecraft.network.FriendlyByteBuf.ByteBufExt;
import io.github.null2264.cobblegen.util.CGLog;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Generator
extends PacketSerializable<Generator> {
    public static final StreamCodec<ByteBuf, Generator> CODEC = new StreamCodec<ByteBuf, Generator>(){

        public Generator decode(ByteBuf buf) {
            return Generator.fromPacket(new FriendlyByteBuf(buf));
        }

        public void encode(ByteBuf buf, Generator generator) {
            FriendlyByteBuf newBuf = ByteBufExt.unpooled();
            generator.toPacket(newBuf);
            buf.writeBytes((ByteBuf)newBuf);
        }
    };

    public static Fluid getStillFluid(FluidState fluidState) {
        try {
            return ((FlowingFluid)fluidState.getType()).getSource();
        }
        catch (ClassCastException ignore) {
            return Generator.getStillFluid(fluidState.getType());
        }
    }

    public static Fluid getStillFluid(Fluid fluid) {
        if (fluid == Fluids.FLOWING_LAVA) {
            return Fluids.LAVA;
        }
        if (fluid == Fluids.FLOWING_WATER) {
            return Fluids.WATER;
        }
        if (fluid instanceof FlowingFluid) {
            return ((FlowingFluid)fluid).getSource();
        }
        return fluid;
    }

    public Optional<BlockState> tryGenerate(LevelAccessor var1, BlockPos var2, BlockState var3);

    default public Optional<BlockState> tryGenerate(LevelAccessor level, BlockPos pos, FluidState source, FluidState neighbour) {
        return Optional.empty();
    }

    @NotNull
    public GeneratorMap getOutput();

    default public GeneratorMap getObsidianOutput() {
        return GeneratorMap.of(new Pair[0]);
    }

    @NotNull
    public GeneratorType getType();

    @Nullable
    public Fluid getFluid();

    @ApiStatus.Internal
    default public void setFluid(Fluid fluid) {
    }

    @Nullable
    public Block getBlock();

    default public boolean isSilent() {
        return false;
    }

    default public boolean check(LevelAccessor level, BlockPos pos, BlockState state, boolean fromTop) {
        return true;
    }

    public static Generator fromPacket(FriendlyByteBuf buf) {
        String className = buf.readUtf();
        try {
            Method method = Class.forName(className).getMethod("fromPacket", FriendlyByteBuf.class);
            return (Generator)method.invoke(null, buf);
        }
        catch (ClassNotFoundException method) {
        }
        catch (Throwable t) {
            CGLog.error("Failed to get generator packet: " + className + " ", t);
        }
        return null;
    }
}

