/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.gametest;

import io.github.null2264.cobblegen.data.CGIdentifier;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;

public class BlockGenerationTest {
    public static final CGIdentifier TEMPLATE;
    public static final Integer TIMEOUT_TICKS;

    @PrefixGameTestTemplate(value=false)
    @GameTest(templateNamespace="cobblegen", template="empty", timeoutTicks=120)
    public void cobbleGenerationTest(GameTestHelper context) {
        context.setBlock(new BlockPos(1, 2, 0), Blocks.BARRIER);
        context.setBlock(new BlockPos(0, 2, 1), Blocks.BARRIER);
        context.setBlock(new BlockPos(0, 2, 2), Blocks.BARRIER);
        context.setBlock(new BlockPos(2, 2, 1), Blocks.BARRIER);
        context.setBlock(new BlockPos(2, 2, 2), Blocks.BARRIER);
        context.setBlock(new BlockPos(0, 1, 2), Blocks.BARRIER);
        context.setBlock(new BlockPos(2, 1, 2), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 1, 1), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 0, 2), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 2, 1), Blocks.WATER);
        context.setBlock(new BlockPos(2, 2, 4), Blocks.BARRIER);
        context.setBlock(new BlockPos(0, 2, 4), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 2, 5), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 1, 4), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 2, 4), Blocks.LAVA);
        context.setBlock(new BlockPos(1, 1, 3), Blocks.BARRIER);
        BlockPos generatedPos = new BlockPos(1, 2, 3);
        context.succeedWhen(() -> context.assertBlockPresent(Blocks.BEDROCK, generatedPos));
    }

    @PrefixGameTestTemplate(value=false)
    @GameTest(templateNamespace="cobblegen", template="empty", timeoutTicks=120)
    public void basaltGenerationTest(GameTestHelper context) {
        context.setBlock(new BlockPos(1, 2, 2), Blocks.BLUE_ICE);
        context.setBlock(new BlockPos(2, 2, 4), Blocks.BARRIER);
        context.setBlock(new BlockPos(0, 2, 4), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 2, 5), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 1, 4), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 2, 4), Blocks.LAVA);
        context.setBlock(new BlockPos(1, 1, 3), Blocks.SOUL_SOIL);
        BlockPos generatedPos = new BlockPos(1, 2, 3);
        context.succeedWhen(() -> context.assertBlockPresent(Blocks.BEDROCK, generatedPos));
    }

    @PrefixGameTestTemplate(value=false)
    @GameTest(templateNamespace="cobblegen", template="empty", timeoutTicks=120)
    public void stoneGenerationTest(GameTestHelper context) {
        context.setBlock(new BlockPos(1, 2, 0), Blocks.BARRIER);
        context.setBlock(new BlockPos(0, 2, 1), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 2, 2), Blocks.BARRIER);
        context.setBlock(new BlockPos(2, 2, 1), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 1, 0), Blocks.BARRIER);
        context.setBlock(new BlockPos(0, 1, 1), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 1, 2), Blocks.BARRIER);
        context.setBlock(new BlockPos(2, 1, 1), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 2, 1), Blocks.LAVA);
        context.setBlock(new BlockPos(0, 1, 2), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 1, 3), Blocks.BARRIER);
        context.setBlock(new BlockPos(2, 1, 2), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 0, 2), Blocks.BARRIER);
        context.setBlock(new BlockPos(1, 1, 2), Blocks.WATER);
        context.setBlock(new BlockPos(1, 0, 1), Blocks.BARRIER);
        BlockPos generatedPos = new BlockPos(1, 1, 1);
        context.succeedWhen(() -> context.assertBlockPresent(Blocks.BEDROCK, generatedPos));
    }

    static {
        IBootstrap.dasBoot();
        TEMPLATE = CGIdentifier.of("empty");
        TIMEOUT_TICKS = 120;
    }
}

