/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.integration.viewer.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.cobblegen.compat.LoaderCompat;
import io.github.null2264.cobblegen.compat.TextCompat;
import io.github.null2264.cobblegen.data.config.ConfigHolder;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.extensions.net.minecraft.world.level.Level.LevelExt;
import io.github.null2264.cobblegen.integration.viewer.emi.FluidInteractionRecipe;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@EmiEntrypoint
public class CGEMIPlugin
implements EmiPlugin {
    public static final String ID_PREFIX = "fluid_interaction_";
    public static final Map<String, EmiRecipeCategory> FLUID_INTERACTION_CATEGORIES;

    private void input(EmiWorldInteractionRecipe.Builder recipe, EmiIngredient input, boolean catalyst, InputPosition position) {
        if (position.equals((Object)InputPosition.RIGHT)) {
            recipe.rightInput(input, catalyst);
        } else {
            recipe.leftInput(input);
        }
    }

    private void input(EmiWorldInteractionRecipe.Builder recipe, EmiIngredient input, boolean catalyst, Function<SlotWidget, SlotWidget> mutator, InputPosition position) {
        if (position.equals((Object)InputPosition.RIGHT)) {
            recipe.rightInput(input, catalyst, mutator);
        } else {
            recipe.leftInput(input, mutator);
        }
    }

    public void register(EmiRegistry registry) {
        if (!ConfigHolder.META.enableRecipeViewer.booleanValue()) {
            return;
        }
        if (!ConfigHolder.META.mergeEMIRecipeCategory.booleanValue()) {
            FLUID_INTERACTION_CATEGORIES.forEach((ignored, category) -> registry.addCategory(category));
            CobbleGen.FLUID_INTERACTION.getGenerators().forEach((fluid, generators) -> generators.forEach(generator -> generator.getOutput().forEach((modifierId, blocks) -> {
                Block modifier = null;
                if (!modifierId.isWildcard()) {
                    modifier = Util.getBlock(modifierId.toMC());
                }
                for (WeightedBlock block : blocks) {
                    registry.addRecipe((EmiRecipe)new FluidInteractionRecipe((Fluid)fluid, Util.notNullOr(generator.getFluid(), Fluids.EMPTY), Util.notNullOr(generator.getBlock(), Blocks.AIR), block, generator.getType(), Util.notNullOr(modifier, Blocks.AIR)));
                }
            })));
        } else {
            Minecraft minecraft = Minecraft.getInstance();
            CobbleGen.FLUID_INTERACTION.getGenerators().forEach((fluid, generators) -> generators.forEach(generator -> generator.getOutput().forEach((modifierId, blocks) -> {
                EmiStack trigger = EmiStack.of((Fluid)fluid, (long)(LoaderCompat.isForge() != false ? 1000L : 81000L));
                Optional<Object> modifier = Optional.empty();
                if (!modifierId.isWildcard()) {
                    modifier = Optional.of(Util.getBlock(modifierId.toMC()));
                }
                for (WeightedBlock block : blocks) {
                    EmiStack neighbourRemainder;
                    EmiStack neighbour;
                    ResourceLocation neighbourId;
                    ResourceLocation resultId;
                    try {
                        resultId = ResourceLocation.tryParse((String)block.id);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    EmiStack output = EmiStack.of((ItemLike)Util.getBlock(resultId));
                    ResourceLocation source = Util.getFluidId(fluid);
                    if (generator.getFluid() == null) {
                        neighbourId = Util.getBlockId(generator.getBlock());
                        neighbour = EmiStack.of((ItemLike)((ItemLike)Objects.requireNonNull(generator.getBlock())));
                    } else {
                        neighbourId = Util.getFluidId(generator.getFluid());
                        neighbour = EmiStack.of((Fluid)Objects.requireNonNull(generator.getFluid()), (long)(LoaderCompat.isForge() != false ? 1000L : 81000L));
                    }
                    if (ConfigHolder.META.emi.removeOverlaps.booleanValue()) {
                        registry.removeRecipes(r -> new HashSet(r.getInputs()).containsAll(List.of(neighbour, trigger)) && r.getOutputs().contains(output) && r.getId().toString().startsWith("emi"));
                    }
                    ResourceLocation id = Util.identifierOf(ID_PREFIX + generator.getType().name().toLowerCase() + "-" + source.toDebugFileName() + "-" + resultId.toDebugFileName() + "-" + neighbourId.toDebugFileName() + "-" + modifierId.toDebugFileName());
                    EmiWorldInteractionRecipe.Builder recipe = EmiWorldInteractionRecipe.builder().id(id);
                    this.input(recipe, (EmiIngredient)trigger.copy().setRemainder(trigger), false, ConfigHolder.META.emi.invertInput != false ? InputPosition.RIGHT : InputPosition.LEFT);
                    EmiStack emiStack = neighbourRemainder = neighbour.isEmpty() ? neighbour : neighbour.copy().setRemainder(neighbour);
                    if (modifier.isPresent()) {
                        this.input(recipe, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)modifier.get())), false, s -> s.appendTooltip((Component)TextCompat.translatable("tooltip.emi.fluid_interaction.basalt.soul_soil").withStyle(ChatFormatting.GREEN)), ConfigHolder.META.emi.invertInput != false ? InputPosition.LEFT : InputPosition.RIGHT);
                        this.input(recipe, (EmiIngredient)neighbourRemainder, false, s -> generator.getBlock() != null ? s.appendTooltip((Component)TextCompat.translatable("tooltip.emi.fluid_interaction.basalt.blue_ice").withStyle(ChatFormatting.GREEN)) : s, ConfigHolder.META.emi.invertInput != false ? InputPosition.LEFT : InputPosition.RIGHT);
                    } else {
                        this.input(recipe, (EmiIngredient)neighbourRemainder, false, ConfigHolder.META.emi.invertInput != false ? InputPosition.LEFT : InputPosition.RIGHT);
                    }
                    recipe.output(output, s -> {
                        Integer maxY;
                        if (!ConfigHolder.META.emi.addTooltip.booleanValue()) {
                            return s;
                        }
                        Integer minY = block.minY;
                        if (minY == null) {
                            minY = minecraft.level != null ? LevelExt.getMinBuildHeight((Level)minecraft.level) : 0;
                        }
                        if ((maxY = block.maxY) == null) {
                            maxY = minecraft.level != null ? LevelExt.getMaxBuildHeight((Level)minecraft.level) : 256;
                        }
                        s.appendTooltip((Component)TextCompat.translatable("cobblegen.info.weight").append(Component.nullToEmpty((String)block.weight.toString())));
                        s.appendTooltip((Component)TextCompat.translatable("cobblegen.info.minY").append(Component.nullToEmpty((String)minY.toString())));
                        s.appendTooltip((Component)TextCompat.translatable("cobblegen.info.maxY").append(Component.nullToEmpty((String)maxY.toString())));
                        s.appendTooltip((Component)TextCompat.translatable("cobblegen.info.blacklistedDim").withStyle(ChatFormatting.GREEN));
                        List<String> recipeBlacklist = block.excludedDimensions;
                        try {
                            for (String string : recipeBlacklist) {
                                ResourceLocation dimId;
                                try {
                                    dimId = ResourceLocation.tryParse((String)string);
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                s.appendTooltip((Component)TextCompat.literal("- " + String.valueOf(dimId)));
                            }
                        }
                        catch (NullPointerException ignored) {
                            s.appendTooltip((Component)TextCompat.literal("- ").append((Component)TextCompat.translatable("cobblegen.dim.none")));
                        }
                        s.appendTooltip((Component)TextCompat.translatable("cobblegen.info.whitelistedDim").withStyle(ChatFormatting.GREEN));
                        List<String> recipeWhitelist = block.dimensions;
                        try {
                            for (String dim : recipeWhitelist) {
                                ResourceLocation dimId;
                                try {
                                    dimId = ResourceLocation.tryParse((String)dim);
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                s.appendTooltip((Component)TextCompat.literal("- " + String.valueOf(dimId)));
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            s.appendTooltip((Component)TextCompat.literal("- ").append((Component)TextCompat.translatable("cobblegen.dim.any")));
                        }
                        return s;
                    });
                    registry.addRecipe((EmiRecipe)recipe.build());
                }
            })));
        }
    }

    static {
        IBootstrap.dasBoot();
        FLUID_INTERACTION_CATEGORIES = Map.of("COBBLE", new EmiRecipeCategory(Util.identifierOf("fluid_interaction_cobble"), (EmiRenderable)EmiStack.of((ItemLike)Blocks.COBBLESTONE)), "STONE", new EmiRecipeCategory(Util.identifierOf("fluid_interaction_stone"), (EmiRenderable)EmiStack.of((ItemLike)Blocks.STONE)), "BASALT", new EmiRecipeCategory(Util.identifierOf("fluid_interaction_basalt"), (EmiRenderable)EmiStack.of((ItemLike)Blocks.BASALT)));
    }

    static enum InputPosition {
        LEFT,
        RIGHT;


        static {
            IBootstrap.dasBoot();
        }
    }
}

