/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.integration.viewer.jei;

import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.cobblegen.data.config.ConfigHolder;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.integration.viewer.FluidInteractionRecipeHolder;
import io.github.null2264.cobblegen.integration.viewer.jei.FluidInteractionCategory;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class CGJEIPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return Util.identifierOf("plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (!ConfigHolder.META.enableRecipeViewer.booleanValue()) {
            return;
        }
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IPlatformFluidHelper fluidHelper = jeiHelpers.getPlatformFluidHelper();
        for (GeneratorType generator : GeneratorType.values()) {
            FluidInteractionCategory category = new FluidInteractionCategory(guiHelper, fluidHelper, generator);
            registration.addRecipeCategories(new IRecipeCategory[]{category});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (!ConfigHolder.META.enableRecipeViewer.booleanValue()) {
            return;
        }
        CobbleGen.FLUID_INTERACTION.getGenerators().forEach((fluid, generators) -> generators.forEach(generator -> generator.getOutput().forEach((modifierId, blocks) -> {
            ArrayList<FluidInteractionRecipeHolder> recipes = new ArrayList<FluidInteractionRecipeHolder>();
            Block modifier = null;
            if (!modifierId.isWildcard()) {
                modifier = Util.getBlock(modifierId.toMC());
            }
            for (WeightedBlock block : blocks) {
                recipes.add(new FluidInteractionRecipeHolder((Fluid)fluid, Util.notNullOr(generator.getFluid(), Fluids.EMPTY), Util.notNullOr(generator.getBlock(), Blocks.AIR), block, generator.getType(), Util.notNullOr(modifier, Blocks.AIR)));
            }
            registration.addRecipes(new RecipeType(Util.identifierOf(generator.getType()), FluidInteractionRecipeHolder.class), recipes);
        })));
    }

    static {
        IBootstrap.dasBoot();
    }
}

