/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.integration.viewer.jei;

import io.github.null2264.cobblegen.compat.GraphicsCompat;
import io.github.null2264.cobblegen.compat.TextCompat;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.extensions.net.minecraft.world.level.Level.LevelExt;
import io.github.null2264.cobblegen.integration.viewer.FluidInteractionRecipeHolder;
import io.github.null2264.cobblegen.util.Constants;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidInteractionCategory
implements IRecipeCategory<FluidInteractionRecipeHolder> {
    private final IDrawable background;
    private final Long full;
    private final IDrawable icon;
    private final GeneratorType type;
    private final int initialHeight;
    private final IDrawable whitelistIcon;
    private final IDrawable blacklistIcon;
    private int dimensionIconsY = 0;

    public FluidInteractionCategory(IGuiHelper guiHelper, IPlatformFluidHelper<?> fluidHelper, GeneratorType generatorType) {
        this.initialHeight = generatorType.equals((Object)GeneratorType.STONE) ? 56 : 36;
        this.background = guiHelper.createBlankDrawable(136, this.initialHeight + 18 + 20 + 9);
        this.full = 10L * fluidHelper.bucketVolume();
        ItemStack iconStack = Items.AIR.getDefaultInstance();
        switch (generatorType) {
            case COBBLE: {
                iconStack = Items.COBBLESTONE.getDefaultInstance();
                break;
            }
            case STONE: {
                iconStack = Items.STONE.getDefaultInstance();
                break;
            }
            case BASALT: {
                iconStack = Items.BASALT.getDefaultInstance();
            }
        }
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)iconStack);
        this.type = generatorType;
        this.whitelistIcon = guiHelper.drawableBuilder(Constants.JEI_UI_COMPONENT.toMC(), 0, 0, 15, 20).build();
        this.blacklistIcon = guiHelper.drawableBuilder(Constants.JEI_UI_COMPONENT.toMC(), 15, 0, 15, 20).build();
    }

    @NotNull
    public RecipeType<FluidInteractionRecipeHolder> getRecipeType() {
        return new RecipeType(Util.identifierOf(this.type), FluidInteractionRecipeHolder.class);
    }

    @NotNull
    public Component getTitle() {
        return TextCompat.translatable("cobblegen.generators." + this.type.name().toLowerCase());
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidInteractionRecipeHolder recipe, IFocusGroup focuses) {
        WeightedBlock output = recipe.getResult();
        Block modifier = recipe.getModifier();
        Fluid source = recipe.getSourceFluid();
        Fluid neighbourFluid = recipe.getNeighbourFluid();
        Block neighbourBlock = recipe.getNeighbourBlock();
        int offset = 18;
        int x = 0;
        int y = 0;
        int gap = 2;
        int coldY = y;
        int lavaX = x + 40;
        int resultX = x + 18 + 2;
        int resultY = y;
        int resultModY = y + 18 + 2;
        if (this.type.equals((Object)GeneratorType.STONE)) {
            lavaX = x + 18 + 2;
            coldY = y + 18 + 2;
            resultY = resultModY;
            resultModY = resultModY + 18 + 2;
        }
        IRecipeSlotBuilder coldBuilder = builder.addSlot(RecipeIngredientRole.INPUT, x, coldY);
        if (this.type.equals((Object)GeneratorType.BASALT)) {
            coldBuilder.addItemStack(neighbourBlock.asItem().getDefaultInstance());
        } else {
            coldBuilder.addFluidStack(neighbourFluid, this.full.longValue());
        }
        builder.addSlot(RecipeIngredientRole.INPUT, lavaX, y).addFluidStack(source, this.full.longValue());
        builder.addSlot(RecipeIngredientRole.OUTPUT, resultX, resultY).addItemStack(output.getBlock().asItem().getDefaultInstance());
        builder.addSlot(RecipeIngredientRole.INPUT, resultX, resultModY).addItemStack(modifier.asItem().getDefaultInstance());
    }

    public void draw(FluidInteractionRecipeHolder recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphicsTarget, double mouseX, double mouseY) {
        int n;
        Integer maxY;
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        Integer minY = recipe.getResult().minY;
        if (minY == null) {
            minY = minecraft.level != null ? LevelExt.getMinBuildHeight((Level)minecraft.level) : 0;
        }
        if ((maxY = recipe.getResult().maxY) == null) {
            maxY = minecraft.level != null ? LevelExt.getMaxBuildHeight((Level)minecraft.level) : 256;
        }
        List<MutableComponent> texts = List.of(TextCompat.translatable("cobblegen.info.weight").append(Component.nullToEmpty((String)recipe.getResult().weight.toString())), TextCompat.translatable("cobblegen.info.minY").append(Component.nullToEmpty((String)minY.toString())), TextCompat.translatable("cobblegen.info.maxY").append(Component.nullToEmpty((String)maxY.toString())));
        int y = 0;
        for (Component component : texts) {
            int width = font.width((FormattedText)component);
            GraphicsCompat.drawString(graphicsTarget, component, this.background.getWidth() - width, y, -8355712);
            Objects.requireNonNull(font);
            y += 9;
        }
        MutableComponent text = TextCompat.translatable("cobblegen.info.dimensions");
        int n2 = this.initialHeight + 9;
        GraphicsCompat.drawString(graphicsTarget, (Component)text, (int)((float)this.background.getWidth() / 2.0f - (float)font.width((FormattedText)text) / 2.0f), n2, -8355712);
        Objects.requireNonNull(font);
        this.dimensionIconsY = n = n2 + 9 + 9;
        this.whitelistIcon.draw(graphicsTarget, 18, n);
        this.blacklistIcon.draw(graphicsTarget, this.background.getWidth() - 15 - 18, n);
    }

    public void getTooltip(ITooltipBuilder tooltip, FluidInteractionRecipeHolder recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        tooltip.addAll(this.getTooltip(recipe, recipeSlotsView, mouseX, mouseY));
    }

    @NotNull
    public List<Component> getTooltip(FluidInteractionRecipeHolder recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 18.0 && mouseX < 33.0 && mouseY > (double)this.dimensionIconsY && mouseY < (double)(this.dimensionIconsY + 20)) {
            ArrayList<Component> dimList = new ArrayList<Component>();
            dimList.add((Component)TextCompat.translatable("cobblegen.info.whitelistedDim"));
            List<String> recipeDimList = recipe.getResult().dimensions;
            if (recipeDimList == null) {
                dimList.add((Component)TextCompat.literal("- ").append((Component)TextCompat.translatable("cobblegen.dim.any")));
            } else {
                for (String dim : recipeDimList) {
                    ResourceLocation id;
                    try {
                        id = ResourceLocation.tryParse((String)dim);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    dimList.add((Component)TextCompat.literal("- " + String.valueOf(id)));
                }
            }
            return dimList;
        }
        int aetherX = this.background.getWidth() - 18;
        if (mouseX > (double)(aetherX - 15) && mouseX < (double)aetherX && mouseY > (double)this.dimensionIconsY && mouseY < (double)(this.dimensionIconsY + 20)) {
            ArrayList<Component> dimList = new ArrayList<Component>();
            dimList.add((Component)TextCompat.translatable("cobblegen.info.blacklistedDim"));
            List<String> recipeDimList = recipe.getResult().excludedDimensions;
            if (recipeDimList == null) {
                dimList.add((Component)TextCompat.literal("- ").append((Component)TextCompat.translatable("cobblegen.dim.none")));
            } else {
                for (String dim : recipeDimList) {
                    ResourceLocation id;
                    try {
                        id = ResourceLocation.tryParse((String)dim);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    dimList.add((Component)TextCompat.literal("- " + String.valueOf(id)));
                }
            }
            return dimList;
        }
        return List.of();
    }

    static {
        IBootstrap.dasBoot();
    }
}

