/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.integration.viewer.rei;

import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.cobblegen.data.config.ConfigHolder;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.integration.viewer.rei.FluidInteractionCategory;
import io.github.null2264.cobblegen.integration.viewer.rei.FluidInteractionRecipe;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@REIPluginClient
public class CGREIPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        if (!ConfigHolder.META.enableRecipeViewer.booleanValue()) {
            return;
        }
        for (GeneratorType generator : GeneratorType.values()) {
            FluidInteractionCategory category = new FluidInteractionCategory(generator);
            registry.add((DisplayCategory)category);
        }
    }

    public void registerDisplays(DisplayRegistry registry) {
        if (!ConfigHolder.META.enableRecipeViewer.booleanValue()) {
            return;
        }
        CobbleGen.FLUID_INTERACTION.getGenerators().forEach((fluid, generators) -> generators.forEach(generator -> generator.getOutput().forEach((modifierId, blocks) -> {
            Block modifier = null;
            if (!modifierId.isWildcard()) {
                modifier = Util.getBlock(modifierId.toMC());
            }
            for (WeightedBlock block : blocks) {
                registry.add((Display)new FluidInteractionRecipe((Fluid)fluid, Util.notNullOr(generator.getFluid(), Fluids.EMPTY), Util.notNullOr(generator.getBlock(), Blocks.AIR), block, generator.getType(), Util.notNullOr(modifier, Blocks.AIR)));
            }
        })));
    }

    static {
        IBootstrap.dasBoot();
    }
}

