/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.integration.viewer.rei;

import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.integration.viewer.FluidInteractionRecipeHolder;
import io.github.null2264.cobblegen.integration.viewer.rei.FluidInteractionCategory;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FluidInteractionRecipe
extends FluidInteractionRecipeHolder
implements Display {
    public FluidInteractionRecipe(Fluid sourceFluid, Fluid neighbourFluid, Block neighbourBlock, WeightedBlock result, GeneratorType type, Block modifier) {
        super(sourceFluid, neighbourFluid, neighbourBlock, result, type, modifier);
    }

    public List<EntryIngredient> getInputEntries() {
        switch (this.getType()) {
            case COBBLE: 
            case STONE: {
                return List.of(EntryIngredient.of((EntryStack)EntryStacks.of((Fluid)this.getSourceFluid())), EntryIngredient.of((EntryStack)EntryStacks.of((Fluid)this.getNeighbourFluid())), EntryIngredient.of((EntryStack)EntryStacks.of((ItemLike)this.getModifier())));
            }
            case BASALT: {
                return List.of(EntryIngredient.of((EntryStack)EntryStacks.of((Fluid)this.getSourceFluid())), EntryIngredient.of((EntryStack)EntryStacks.of((ItemLike)this.getNeighbourBlock())), EntryIngredient.of((EntryStack)EntryStacks.of((ItemLike)this.getModifier())));
            }
        }
        return List.of();
    }

    public List<EntryIngredient> getOutputEntries() {
        return List.of(EntryIngredient.of((EntryStack)EntryStacks.of((ItemLike)this.getResult().getBlock())));
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return FluidInteractionCategory.generateIdentifier(this.getType());
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return Optional.empty();
    }

    @Nullable
    public DisplaySerializer<? extends Display> getSerializer() {
        return null;
    }

    static {
        IBootstrap.dasBoot();
    }
}

