/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.network;

import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.cobblegen.network.payload.CGPacketPayload;
import io.github.null2264.cobblegen.network.payload.CGPingC2SPayload;
import io.github.null2264.cobblegen.network.payload.CGPingS2CPayload;
import io.github.null2264.cobblegen.network.payload.CGSyncC2SPayload;
import io.github.null2264.cobblegen.network.payload.CGSyncS2CPayload;
import io.github.null2264.cobblegen.util.CGLog;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.jetbrains.annotations.ApiStatus;

public class CGClientPlayNetworkHandler {
    public static boolean handlePacket(ClientCommonPacketListenerImpl listener, CustomPacketPayload payload) {
        if (payload instanceof CGSyncS2CPayload) {
            Boolean isReload = ((CGSyncS2CPayload)payload).isReload();
            CobbleGen.FLUID_INTERACTION.readGeneratorsFromPayload((CGSyncS2CPayload)payload);
            boolean isSync = CobbleGen.FLUID_INTERACTION.isSync();
            if (isSync) {
                CGLog.info("CobbleGen config has been", isReload != false ? "re-synced" : "retrieved from the server");
            }
            CGSyncC2SPayload newPayload = new CGSyncC2SPayload(isSync);
            listener.send((Packet)CGClientPlayNetworkHandler.createC2SPacket(newPayload));
            return true;
        }
        if (payload instanceof CGPingS2CPayload) {
            CGPingC2SPayload newPayload = new CGPingC2SPayload(((CGPingS2CPayload)payload).reload(), Util.isAnyRecipeViewerLoaded());
            listener.send((Packet)CGClientPlayNetworkHandler.createC2SPacket(newPayload));
            return true;
        }
        return false;
    }

    public static void onDisconnect() {
        CobbleGen.FLUID_INTERACTION.disconnect();
    }

    @ApiStatus.Internal
    private static ServerboundCustomPayloadPacket createC2SPacket(CGPacketPayload payload) {
        return new ServerboundCustomPayloadPacket((CustomPacketPayload)payload);
    }

    static {
        IBootstrap.dasBoot();
    }
}

