/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.network;

import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.cobblegen.network.payload.CGPacketPayload;
import io.github.null2264.cobblegen.network.payload.CGPingC2SPayload;
import io.github.null2264.cobblegen.network.payload.CGPingS2CPayload;
import io.github.null2264.cobblegen.network.payload.CGSyncC2SPayload;
import io.github.null2264.cobblegen.network.payload.CGSyncS2CPayload;
import io.github.null2264.cobblegen.util.CGLog;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import org.jetbrains.annotations.ApiStatus;

public class CGServerPlayNetworkHandler {
    public static void trySync(ServerCommonPacketListenerImpl listener) {
        CGServerPlayNetworkHandler.trySync(listener, false);
    }

    public static void trySync(ServerCommonPacketListenerImpl listener, boolean isReload) {
        if (isReload) {
            CGLog.info("CobbleGen has been reloaded, trying to re-sync...", new String[0]);
        } else {
            CGLog.debug("A player joined, checking for recipe viewer...", new String[0]);
        }
        CGPingS2CPayload payload = new CGPingS2CPayload(isReload);
        listener.send((Packet)CGServerPlayNetworkHandler.createS2CPacket(payload));
    }

    public static boolean handlePacket(ServerCommonPacketListenerImpl listener, CustomPacketPayload payload) {
        if (payload instanceof CGPingC2SPayload) {
            if (((CGPingC2SPayload)payload).hasRecipeViewer().booleanValue()) {
                if (!((CGPingC2SPayload)payload).reload().booleanValue()) {
                    CGLog.info("Player has recipe viewer installed, sending CobbleGen config...", new String[0]);
                }
                CGServerPlayNetworkHandler.sync(listener, ((CGPingC2SPayload)payload).reload());
            }
            return true;
        }
        if (payload instanceof CGSyncC2SPayload) {
            if (((CGSyncC2SPayload)payload).sync().booleanValue()) {
                CGLog.info("Player has received the server's newest CobbleGen config", new String[0]);
            }
            return true;
        }
        return false;
    }

    public static void sync(ServerCommonPacketListenerImpl handler, boolean isReload) {
        CGSyncS2CPayload payload = new CGSyncS2CPayload(isReload, CobbleGen.FLUID_INTERACTION.getLocalGenerators());
        handler.send((Packet)CGServerPlayNetworkHandler.createS2CPacket(payload));
    }

    @ApiStatus.Internal
    public static ClientboundCustomPayloadPacket createS2CPacket(CGPacketPayload payload) {
        return new ClientboundCustomPayloadPacket((CustomPacketPayload)payload);
    }

    static {
        IBootstrap.dasBoot();
    }
}

