/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.null2264.cobblegen.data.CGIdentifier;
import io.github.null2264.cobblegen.extensions.net.minecraft.network.FriendlyByteBuf.ByteBufExt;
import io.github.null2264.cobblegen.network.payload.CGPacketPayload;
import io.github.null2264.cobblegen.network.payload.CGPingC2SPayload;
import io.github.null2264.cobblegen.network.payload.CGPingS2CPayload;
import io.github.null2264.cobblegen.network.payload.CGSyncC2SPayload;
import io.github.null2264.cobblegen.network.payload.CGSyncS2CPayload;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class Constants {
    public static final int SLOT_SIZE = 18;
    public static final int JEI_RECIPE_WIDTH = 136;
    public static final int JEI_RECIPE_HEIGHT = 36;
    public static final int JEI_RECIPE_HEIGHT_STONE = 56;
    public static final CGIdentifier JEI_UI_COMPONENT;
    public static final CGIdentifier CG_PING;
    public static final CGIdentifier CG_SYNC;
    public static final CGIdentifier CG_PING_SERVER;
    public static final CGIdentifier CG_SYNC_SERVER;
    public static final ImmutableMap<CGIdentifier, StreamCodec<? super FriendlyByteBuf, ? extends CGPacketPayload>> KNOWN_PAYLOADS;
    public static final int LAVA_FIZZ = 1501;
    public static final int OP_LEVEL_GAMEMASTERS = 2;
    public static final StreamCodec<ByteBuf, Fluid> FLUID_CODEC;
    public static final ImmutableList<Direction> FLOW_DIRECTIONS;

    static {
        IBootstrap.dasBoot();
        JEI_UI_COMPONENT = CGIdentifier.of("textures/gui/jei.png");
        CG_PING = CGIdentifier.of("ping");
        CG_SYNC = CGIdentifier.of("sync");
        CG_PING_SERVER = CGIdentifier.of("ping_server");
        CG_SYNC_SERVER = CGIdentifier.of("sync_server");
        KNOWN_PAYLOADS = ImmutableMap.of((Object)CGPingC2SPayload.ID, CGPingC2SPayload.STREAM_CODEC, (Object)CGSyncC2SPayload.ID, CGSyncC2SPayload.STREAM_CODEC, (Object)CGPingS2CPayload.ID, CGPingS2CPayload.STREAM_CODEC, (Object)CGSyncS2CPayload.ID, CGSyncS2CPayload.STREAM_CODEC);
        FLUID_CODEC = new StreamCodec<ByteBuf, Fluid>(){

            public Fluid decode(ByteBuf buf) {
                FriendlyByteBuf compat = new FriendlyByteBuf(buf);
                return Util.getFluid(compat.readResourceLocation());
            }

            public void encode(ByteBuf buf, Fluid fluid) {
                FriendlyByteBuf newBuf = ByteBufExt.unpooled();
                newBuf.writeResourceLocation(Util.getFluidId(fluid));
                buf.writeBytes((ByteBuf)newBuf);
            }
        };
        FLOW_DIRECTIONS = ImmutableList.of((Object)Direction.DOWN, (Object)Direction.SOUTH, (Object)Direction.NORTH, (Object)Direction.EAST, (Object)Direction.WEST);
    }

    public static enum CGBlocks {
        WILDCARD("*");

        private final String text;

        private CGBlocks(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public static String fromId(ResourceLocation id) {
            return id.toString();
        }

        public static String fromBlock(Block block) {
            return CGBlocks.fromId(Util.getBlockId(block));
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

