/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.util;

import io.github.null2264.cobblegen.compat.LoaderCompat;
import io.github.null2264.cobblegen.compat.RegistryCompat;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static ResourceLocation identifierOf(GeneratorType type) {
        return Util.identifierOf(type.name().toLowerCase());
    }

    public static ResourceLocation identifierOf(String id) {
        return Util.identifierOf("cobblegen", id);
    }

    public static ResourceLocation identifierOf(String namespace, String id) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)id);
    }

    @NotNull
    public static <T> T notNullOr(@Nullable T nullable, @NotNull T notNull) {
        if (nullable == null) {
            return notNull;
        }
        return nullable;
    }

    @NotNull
    public static <T> Optional<T> optional(@Nullable T nullable) {
        if (nullable == null) {
            return Optional.empty();
        }
        return Optional.of(nullable);
    }

    public static boolean isPortingLibLoaded() {
        return LoaderCompat.isModLoaded("porting_lib");
    }

    public static boolean isAnyRecipeViewerLoaded() {
        return LoaderCompat.isModLoaded("roughlyenoughitems") || LoaderCompat.isModLoaded("jei") || LoaderCompat.isModLoaded("emi");
    }

    public static Fluid getFluid(ResourceLocation id) {
        return (Fluid)RegistryCompat.fluid().getValue(id);
    }

    public static ResourceLocation getFluidId(Fluid fluid) {
        return RegistryCompat.fluid().getKey((Object)fluid);
    }

    public static Block getBlock(ResourceLocation id) {
        return (Block)RegistryCompat.block().getValue(id);
    }

    public static ResourceLocation getBlockId(Block block) {
        return RegistryCompat.block().getKey((Object)block);
    }

    public static List<ResourceLocation> getTaggedBlockIds(ResourceLocation tagId) {
        TagKey blockTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tagId);
        Optional blockList = RegistryCompat.block().get(blockTag);
        ArrayList<ResourceLocation> blockIds = new ArrayList<ResourceLocation>();
        blockList.ifPresent(t -> t.stream().forEach(taggedBlock -> {
            Optional key = taggedBlock.unwrapKey();
            key.ifPresent(k -> blockIds.add(k.location()));
        }));
        return blockIds;
    }

    public static String getDimension(LevelAccessor level) {
        RegistryAccess access = level.registryAccess();
        ResourceLocation dim = access.lookupOrThrow(Registries.DIMENSION_TYPE).getKey((Object)level.dimensionType());
        return dim != null ? dim.toString() : "minecraft:overworld";
    }

    @Nullable
    public static String getBiome(LevelAccessor level, BlockPos position) {
        RegistryAccess access = level.registryAccess();
        ResourceLocation biome = access.lookupOrThrow(Registries.BIOME).getKey((Object)((Biome)level.getBiome(position).value()));
        return biome != null ? biome.toString() : null;
    }

    static {
        IBootstrap.dasBoot();
    }
}

