/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.shadowed.manifold.ext.rt.proxy;

import io.github.null2264.shadowed.manifold.ext.rt.proxy.ProxyGenerator;
import io.github.null2264.shadowed.manifold.ext.rt.proxy.WeakCache;
import io.github.null2264.shadowed.manifold.util.JreUtil;
import io.github.null2264.shadowed.manifold.util.ReflectUtil;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final Class<?>[] constructorParams = new Class[]{InvocationHandler.class};
    private static final WeakCache<ClassLoader, Class<?>[], Class<?>> proxyClassCache = new WeakCache(new KeyFactory(), new ProxyClassFactory());
    protected InvocationHandler h;
    private static final Object key0 = new Object();

    private Proxy() {
    }

    protected Proxy(InvocationHandler h) {
        Objects.requireNonNull(h);
        this.h = h;
    }

    @CallerSensitive
    public static Class<?> getProxyClass(ClassLoader loader, Class<?> ... interfaces) throws IllegalArgumentException {
        Class[] intfs = (Class[])interfaces.clone();
        return Proxy.getProxyClass0(loader, intfs);
    }

    private static void checkProxyAccess(Class<?> caller, ClassLoader loader, Class<?> ... interfaces) {
    }

    private static Class<?> getProxyClass0(ClassLoader loader, Class<?> ... interfaces) {
        if (interfaces.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        return proxyClassCache.get(loader, interfaces);
    }

    @CallerSensitive
    public static Object newProxyInstance(ClassLoader loader, Class<?>[] interfaces, InvocationHandler h) throws IllegalArgumentException {
        Objects.requireNonNull(h);
        Class[] intfs = (Class[])interfaces.clone();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Proxy.checkProxyAccess(Reflection.getCallerClass(), loader, intfs);
        }
        Class<?> cl = Proxy.getProxyClass0(loader, intfs);
        try {
            if (sm != null) {
                Proxy.checkNewProxyPermission(Reflection.getCallerClass(), cl);
            }
            final Constructor<?> cons = cl.getConstructor(constructorParams);
            InvocationHandler ih = h;
            if (!Modifier.isPublic(cl.getModifiers())) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        cons.setAccessible(true);
                        return null;
                    }
                });
            }
            return cons.newInstance(h);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InternalError(e.toString(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InternalError(t.toString(), t);
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString(), e);
        }
    }

    private static void checkNewProxyPermission(Class<?> caller, Class<?> proxyClass) {
    }

    public static boolean isProxyClass(Class<?> cl) {
        return java.lang.reflect.Proxy.class.isAssignableFrom(cl) && proxyClassCache.containsValue(cl);
    }

    @CallerSensitive
    public static InvocationHandler getInvocationHandler(Object proxy) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy p = (Proxy)proxy;
        return p.h;
    }

    public static Class<?> defineProxyClass(Object module, String name, byte[] b, int off, int len, ClassLoader loader) {
        if (!JreUtil.isJava8()) {
            loader = (ClassLoader)ReflectUtil.method(module, "getClassLoader", new Class[0]).invoke(new Object[0]);
        }
        return (Class)ReflectUtil.method(loader, "defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE).invoke(name, b, off, len);
    }

    private static final class ProxyClassFactory
    implements BiFunction<ClassLoader, Class<?>[], Class<?>> {
        private static final String proxyClassNamePrefix = "$ManProxy";
        private static final AtomicLong nextUniqueNumber = new AtomicLong();

        private ProxyClassFactory() {
        }

        @Override
        public Class<?> apply(ClassLoader loader, Class<?>[] interfaces) {
            IdentityHashMap interfaceSet = new IdentityHashMap(interfaces.length);
            for (Class<?> intf : interfaces) {
                Class<?> interfaceClass = null;
                try {
                    interfaceClass = Class.forName(intf.getName(), false, loader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (interfaceClass != intf) {
                    throw new IllegalArgumentException(intf + " is not visible from class loader");
                }
                if (!interfaceClass.isInterface()) {
                    throw new IllegalArgumentException(interfaceClass.getName() + " is not an interface");
                }
                if (interfaceSet.put(interfaceClass, Boolean.TRUE) == null) continue;
                throw new IllegalArgumentException("repeated interface: " + interfaceClass.getName());
            }
            String proxyPkg = null;
            int accessFlags = 17;
            for (Class<?> intf : interfaces) {
                String pkg;
                int flags = intf.getModifiers();
                if (Modifier.isPublic(flags)) continue;
                accessFlags = 16;
                String name = intf.getName();
                int n = name.lastIndexOf(46);
                String string = pkg = n == -1 ? "" : name.substring(0, n + 1);
                if (proxyPkg == null) {
                    proxyPkg = pkg;
                    continue;
                }
                if (pkg.equals(proxyPkg)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            Object proxyModule = null;
            if (!JreUtil.isJava8()) {
                if (proxyPkg != null && proxyPkg.endsWith(".")) {
                    proxyPkg = proxyPkg.substring(0, proxyPkg.length() - 1);
                }
                Object builder = ReflectUtil.constructor("java.lang.reflect.Proxy$ProxyBuilder", ClassLoader.class, List.class).newInstance(loader, Arrays.asList(interfaces));
                proxyModule = JreUtil.isJava20orLater() ? ReflectUtil.field(ReflectUtil.field(builder, "context").get(), "module").get() : ReflectUtil.field(builder, "module").get();
                String moduleName = (String)ReflectUtil.method(proxyModule, "getName", new Class[0]).invoke(new Object[0]);
                Class<?> moduleClass = ReflectUtil.type("java.lang.Module");
                Object manifoldExtRtModule = ReflectUtil.method(Proxy.class, "getModule", new Class[0]).invoke(new Object[0]);
                ReflectUtil.method("jdk.internal.module.Modules", "addReads", moduleClass, moduleClass).invokeStatic(proxyModule, manifoldExtRtModule);
                if (proxyPkg == null) {
                    proxyPkg = (Boolean)ReflectUtil.method(proxyModule, "isNamed", new Class[0]).invoke(new Object[0]) != false ? "com.sun.proxy." + moduleName : "com.sun.proxy";
                }
                ReflectUtil.method("jdk.internal.module.Modules", "addExports", moduleClass, String.class, moduleClass).invokeStatic(proxyModule, proxyPkg, manifoldExtRtModule);
                ReflectUtil.method("jdk.internal.module.Modules", "addOpens", moduleClass, String.class, moduleClass).invokeStatic(proxyModule, proxyPkg, manifoldExtRtModule);
                proxyPkg = proxyPkg + '.';
            }
            if (proxyPkg == null) {
                proxyPkg = "com.sun.proxy.";
            }
            long num = nextUniqueNumber.getAndIncrement();
            String proxyName = proxyPkg + proxyClassNamePrefix + num;
            byte[] proxyClassFile = ProxyGenerator.generateProxyClass(proxyName, interfaces, accessFlags);
            try {
                return Proxy.defineProxyClass(proxyModule, proxyName, proxyClassFile, 0, proxyClassFile.length, loader);
            }
            catch (ClassFormatError e) {
                throw new IllegalArgumentException(e.toString());
            }
        }
    }

    private static final class KeyFactory
    implements BiFunction<ClassLoader, Class<?>[], Object> {
        private KeyFactory() {
        }

        @Override
        public Object apply(ClassLoader classLoader, Class<?>[] interfaces) {
            switch (interfaces.length) {
                case 1: {
                    return new Key1(interfaces[0]);
                }
                case 2: {
                    return new Key2(interfaces[0], interfaces[1]);
                }
                case 0: {
                    return key0;
                }
            }
            return new KeyX(interfaces);
        }
    }

    private static final class KeyX {
        private final int hash;
        private final WeakReference<Class<?>>[] refs;

        KeyX(Class<?>[] interfaces) {
            this.hash = Arrays.hashCode(interfaces);
            this.refs = new WeakReference[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                this.refs[i] = new WeakReference(interfaces[i]);
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && obj.getClass() == KeyX.class && KeyX.equals(this.refs, ((KeyX)obj).refs);
        }

        private static boolean equals(WeakReference<Class<?>>[] refs1, WeakReference<Class<?>>[] refs2) {
            if (refs1.length != refs2.length) {
                return false;
            }
            for (int i = 0; i < refs1.length; ++i) {
                Class intf = (Class)refs1[i].get();
                if (intf != null && intf == refs2[i].get()) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Key2
    extends WeakReference<Class<?>> {
        private final int hash;
        private final WeakReference<Class<?>> ref2;

        Key2(Class<?> intf1, Class<?> intf2) {
            super(intf1);
            this.hash = 31 * intf1.hashCode() + intf2.hashCode();
            this.ref2 = new WeakReference(intf2);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            Class intf2;
            Class intf1;
            return this == obj || obj != null && obj.getClass() == Key2.class && (intf1 = (Class)this.get()) != null && intf1 == ((Key2)obj).get() && (intf2 = (Class)this.ref2.get()) != null && intf2 == ((Key2)obj).ref2.get();
        }
    }

    private static final class Key1
    extends WeakReference<Class<?>> {
        private final int hash;

        Key1(Class<?> intf) {
            super(intf);
            this.hash = intf.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            Class intf;
            return this == obj || obj != null && obj.getClass() == Key1.class && (intf = (Class)this.get()) != null && intf == ((Key1)obj).get();
        }
    }
}

