/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.shadowed.manifold.rt.api.util;

import io.github.null2264.shadowed.manifold.rt.api.util.ManStringUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;

public class ManDateTimeUtil {
    private static final DateTimeFormatter[] DATE_TIME_FORMATTERS = new DateTimeFormatter[]{DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.RFC_1123_DATE_TIME, DateTimeFormatter.ISO_LOCAL_DATE_TIME, DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL), DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG), DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM), DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT)};
    private static final DateTimeFormatter[] DATE_FORMATTERS = new DateTimeFormatter[]{DateTimeFormatter.ISO_DATE, DateTimeFormatter.ISO_LOCAL_DATE, DateTimeFormatter.ISO_OFFSET_DATE, DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL), DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG), DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM), DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT)};
    private static final DateTimeFormatter[] TIME_FORMATTERS = new DateTimeFormatter[]{DateTimeFormatter.ISO_TIME, DateTimeFormatter.ISO_LOCAL_TIME, DateTimeFormatter.ISO_OFFSET_TIME, DateTimeFormatter.ofLocalizedTime(FormatStyle.FULL), DateTimeFormatter.ofLocalizedTime(FormatStyle.LONG), DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM), DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT)};

    public static LocalDateTime parseDateTime(String data) {
        if (data.length() > 80 || data.length() < 6 || ManStringUtil.isAlpha(data) || ManStringUtil.isNumeric(data)) {
            return null;
        }
        for (DateTimeFormatter formatter : DATE_TIME_FORMATTERS) {
            try {
                return LocalDateTime.parse(data, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    public static LocalDate parseDate(String data) {
        if (data.length() > 60 || data.length() < 4 || ManStringUtil.isAlpha(data) || ManStringUtil.isNumeric(data)) {
            return null;
        }
        for (DateTimeFormatter formatter : DATE_FORMATTERS) {
            try {
                return LocalDate.parse(data, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    public static LocalTime parseTime(String data) {
        if (data.length() > 30 || ManStringUtil.isAlpha(data) || ManStringUtil.isAlpha(data) || ManStringUtil.isNumeric(data)) {
            return null;
        }
        for (DateTimeFormatter formatter : TIME_FORMATTERS) {
            try {
                return LocalTime.parse(data, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }
}

