/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.shadowed.manifold.util.concurrent;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ConcurrentWeakValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentHashMap<K, MyReference<K, V>> myMap;
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    public ConcurrentWeakValueHashMap(Map<K, V> map) {
        this();
        this.putAll(map);
    }

    public ConcurrentWeakValueHashMap() {
        this.myMap = new ConcurrentHashMap();
    }

    public ConcurrentWeakValueHashMap(int initialCapacity) {
        this.myMap = new ConcurrentHashMap(initialCapacity);
    }

    public ConcurrentWeakValueHashMap(int initialCapaciy, float loadFactor, int concurrenycLevel) {
        this.myMap = new ConcurrentHashMap(initialCapaciy, loadFactor, concurrenycLevel);
    }

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            if (this.myMap.get(ref.key) != ref) continue;
            this.myMap.remove(ref.key);
        }
    }

    @Override
    public V get(Object key) {
        MyReference<K, V> ref = this.myMap.get(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        MyReference<K, V> oldRef = this.myMap.put(key, this.createRef(key, value));
        return oldRef != null ? (V)oldRef.get() : null;
    }

    private MyReference<K, V> createRef(K key, V value) {
        return new MyReference<K, V>(key, value, this.myQueue);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Object oldVal;
        block2: {
            MyReference<K, V> newRef;
            MyReference<K, V> oldRef;
            do {
                this.processQueue();
                newRef = this.createRef(key, value);
                oldRef = this.myMap.putIfAbsent(key, newRef);
                if (oldRef == null) {
                    return null;
                }
                oldVal = oldRef.get();
                if (oldVal != null) break block2;
            } while (!this.myMap.replace(key, oldRef, newRef));
            return null;
        }
        return (V)oldVal;
    }

    @Override
    public boolean remove(Object key, Object value) {
        this.processQueue();
        return this.myMap.remove(key, this.createRef(key, value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.processQueue();
        return this.myMap.replace(key, this.createRef(key, oldValue), this.createRef(key, newValue));
    }

    @Override
    public V replace(K key, V value) {
        this.processQueue();
        MyReference<K, V> ref = this.myMap.replace(key, this.createRef(key, value));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        MyReference<K, V> ref = this.myMap.remove(key);
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.processQueue();
        for (K k : t.keySet()) {
            V v = t.get(k);
            if (v == null) continue;
            this.put(k, v);
        }
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    public Set<K> keySet() {
        return this.myMap.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Collection<MyReference<K, V>> refs = this.myMap.values();
        for (MyReference<K, V> ref : refs) {
            Object value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<K> keys = this.keySet();
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (final K key : keys) {
            final V value = this.get(key);
            if (value == null) continue;
            entries.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return key;
                }

                @Override
                public V getValue() {
                    return value;
                }

                @Override
                public V setValue(V value2) {
                    throw new UnsupportedOperationException("setValue is not implemented");
                }
            });
        }
        return entries;
    }

    public String toString() {
        String s = "ConcurrentWeakValueHashMap size:" + this.size() + " [";
        for (Object k : this.myMap.keySet()) {
            V v = this.get(k);
            s = s + "'" + k + "': '" + v + "', ";
        }
        s = s + "] ";
        return s;
    }

    private static class MyReference<K, T>
    extends WeakReference<T> {
        private final K key;

        public MyReference(K key, T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyReference that = (MyReference)o;
            return this.key.equals(that.key) && this.areEqual(this.get(), that.get());
        }

        private boolean areEqual(Object p1, Object p2) {
            if (p1 == null || p2 == null) {
                return p1 == p2;
            }
            if (p1 instanceof Object[] && p2 instanceof Object[]) {
                Object[] arr1 = (Object[])p1;
                Object[] arr2 = (Object[])p2;
                return Arrays.equals(arr1, arr2);
            }
            return p1.equals(p2);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

