/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.block.entity;

import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7128;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import net.moss.resonance.Resonance;
import org.jetbrains.annotations.Nullable;

public class BuddingPearlIceBlockEntity
extends class_2586 {
    private final class_7128 spreadManager;
    class_1799 seed = class_1799.field_8037;
    class_1799 potion = class_1799.field_8037;
    class_1799 catalyst = class_1799.field_8037;
    class_1799 pearl = class_1799.field_8037;
    private int brushesCount;
    private long nextDustTime;
    private long nextBrushTime;
    @Nullable
    private class_2350 hitDirection;

    public BuddingPearlIceBlockEntity(class_2338 pos, class_2680 state) {
        super(Resonance.BUDDING_PEARL_ICE_BLOCK_ENTITY, pos, state);
        this.spreadManager = class_7128.method_41478();
    }

    public void spreadSculk(class_2680 state, class_3218 world, class_5819 random) {
        class_2338 pos2 = this.field_11867.method_10069(random.method_39332(0, 6) - 3, random.method_39332(0, 6) - 3, random.method_39332(0, 6) - 3);
        this.spreadManager.method_41482(pos2, 25);
        this.spreadManager.method_41479((class_1936)world, pos2, random, true);
        this.spreadManager.method_41479((class_1936)world, pos2, random, true);
        this.spreadManager.method_41479((class_1936)world, pos2, random, true);
    }

    public boolean brush(long worldTime, class_2350 hitDirection) {
        if (this.hitDirection == null) {
            this.hitDirection = hitDirection;
        }
        this.nextDustTime = worldTime + 40L;
        if (worldTime < this.nextBrushTime || !(this.field_11863 instanceof class_3218)) {
            return false;
        }
        this.nextBrushTime = worldTime + 10L;
        int i = this.getDustedLevel();
        if (++this.brushesCount >= 10) {
            this.finishBrushing();
            return true;
        }
        this.field_11863.method_39279(this.method_11016(), this.method_11010().method_26204(), 2);
        int j = this.getDustedLevel();
        if (i != j) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_42836, (Comparable)Integer.valueOf(j)), 3);
        }
        return false;
    }

    public void scheduledTick() {
        if (this.field_11863 == null) {
            return;
        }
        if (this.brushesCount != 0 && this.field_11863.method_8510() >= this.nextDustTime) {
            int i = this.getDustedLevel();
            this.brushesCount = Math.max(0, this.brushesCount - 2);
            int j = this.getDustedLevel();
            if (i != j) {
                this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)class_2741.field_42836, (Comparable)Integer.valueOf(j)), 3);
            }
            this.nextDustTime = this.field_11863.method_8510() + 4L;
        }
        if (this.brushesCount == 0) {
            this.hitDirection = null;
            this.nextDustTime = 0L;
            this.nextBrushTime = 0L;
        } else {
            this.field_11863.method_39279(this.method_11016(), this.method_11010().method_26204(), 2);
        }
    }

    private void finishBrushing() {
        if (this.field_11863 == null || this.field_11863.method_8503() == null) {
            return;
        }
        this.spawnItem();
        this.field_11863.method_8396(null, this.field_11867, (class_3414)Resonance.REVERBERATION_SOUND.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
        class_2680 blockState = this.method_11010();
        this.field_11863.method_20290(3008, this.method_11016(), class_2248.method_9507((class_2680)blockState));
        this.field_11863.method_8652(this.field_11867, Resonance.PEARL_ICE.method_9564(), 3);
    }

    private void spawnItem() {
        if (!this.hasPearl() || this.field_11863 == null || this.field_11863.method_8503() == null) {
            return;
        }
        double d = class_1299.field_6052.method_17685();
        double e = 1.0 - d;
        double f = d / 2.0;
        class_2350 direction = Objects.requireNonNullElse(this.hitDirection, class_2350.field_11036);
        class_2338 blockPos = this.field_11867.method_10079(direction, 1);
        double g = (double)blockPos.method_10263() + 0.5 * e + f;
        double h = (double)blockPos.method_10264() + 0.5 + (double)(class_1299.field_6052.method_17686() / 2.0f);
        double i = (double)blockPos.method_10260() + 0.5 * e + f;
        class_1542 itemEntity = new class_1542(this.field_11863, g, h, i, this.pearl.method_7971(this.field_11863.field_9229.method_43048(21) + 10));
        itemEntity.method_18799(class_243.field_1353);
        this.field_11863.method_8649((class_1297)itemEntity);
        this.setPearl(class_1799.field_8037);
    }

    public boolean canCraftPearl() {
        return this.hasSeed() && this.hasPotion() && (this.potion.method_57826(class_9334.field_50238) || this.potion.method_57826(class_9334.field_49651));
    }

    public boolean hasSeed() {
        return !this.seed.method_7960();
    }

    public boolean hasPotion() {
        return !this.potion.method_7960();
    }

    public boolean hasCatalyst() {
        return !this.catalyst.method_7960();
    }

    public boolean hasPearl() {
        return !this.pearl.method_7960();
    }

    public class_1799 getSeed() {
        return this.seed;
    }

    public class_1799 getPotion() {
        return this.potion;
    }

    public class_1799 getCatalyst() {
        return this.catalyst;
    }

    public class_1799 getPearl() {
        return this.pearl;
    }

    public void setSeed(class_1799 seed) {
        this.seed = seed;
    }

    public void setPotion(class_1799 potion) {
        this.potion = potion;
    }

    public void setCatalyst(class_1799 catalyst) {
        this.catalyst = catalyst;
    }

    public void setPearl(class_1799 pearl) {
        this.pearl = pearl;
    }

    public void clear() {
        this.setSeed(class_1799.field_8037);
        this.setPotion(class_1799.field_8037);
        this.setCatalyst(class_1799.field_8037);
        this.setPearl(class_1799.field_8037);
    }

    @Nullable
    public class_2350 getHitDirection() {
        return this.hitDirection;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.seed = nbt.method_10573("Seed", 10) ? class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbt.method_10562("Seed")).orElse(class_1799.field_8037) : class_1799.field_8037;
        this.potion = nbt.method_10573("Potion", 10) ? class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbt.method_10562("Potion")).orElse(class_1799.field_8037) : class_1799.field_8037;
        this.catalyst = nbt.method_10573("Catalyst", 10) ? class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbt.method_10562("Catalyst")).orElse(class_1799.field_8037) : class_1799.field_8037;
        class_1799 class_17992 = this.pearl = nbt.method_10573("Pearl", 10) ? class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbt.method_10562("Pearl")).orElse(class_1799.field_8037) : class_1799.field_8037;
        if (nbt.method_10545("hit_direction")) {
            this.hitDirection = class_2350.values()[nbt.method_10550("hit_direction")];
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (this.hasSeed()) {
            nbt.method_10566("Seed", this.getSeed().method_57358(registryLookup));
        }
        if (this.hasPotion()) {
            nbt.method_10566("Potion", this.getPotion().method_57358(registryLookup));
        }
        if (this.hasCatalyst()) {
            nbt.method_10566("Catalyst", this.getCatalyst().method_57358(registryLookup));
        }
        if (this.hasPearl()) {
            nbt.method_10566("Pearl", this.getPearl().method_57358(registryLookup));
        }
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = super.method_16887(registryLookup);
        if (this.hitDirection != null) {
            nbtCompound.method_10569("hit_direction", this.hitDirection.ordinal());
        }
        if (this.hasSeed()) {
            nbtCompound.method_10566("Seed", this.seed.method_57358(registryLookup));
        }
        if (this.hasPotion()) {
            nbtCompound.method_10566("Potion", this.potion.method_57358(registryLookup));
        }
        if (this.hasCatalyst()) {
            nbtCompound.method_10566("Catalyst", this.catalyst.method_57358(registryLookup));
        }
        if (this.hasPearl()) {
            nbtCompound.method_10566("Pearl", this.pearl.method_57358(registryLookup));
        }
        return nbtCompound;
    }

    private int getDustedLevel() {
        if (this.brushesCount == 0) {
            return 0;
        }
        if (this.brushesCount < 3) {
            return 1;
        }
        if (this.brushesCount < 6) {
            return 2;
        }
        return 3;
    }
}

