/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3956;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7059;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.minecraft.server.MinecraftServer;
import net.moss.resonance.Resonance;
import net.moss.resonance.ReverberationRecipe;
import net.moss.resonance.block.BuddingPearlIce;
import net.moss.resonance.command.LocateUniqueStructureCommand;
import net.moss.resonance.entity.ModEntities;
import net.moss.resonance.event.PlayerCritEvent;
import net.moss.resonance.event.ReverberateEvent;
import net.moss.resonance.event.ShieldEvents;
import net.moss.resonance.event.StaticShockEvent;
import net.moss.resonance.mixin.MobSpawnerLogicAccessor;
import net.moss.resonance.particle.ModParticles;
import net.moss.resonance.util.EnchantUtils;
import net.moss.resonance.util.Utils;
import net.moss.resonance.util.interfaces.CritStoringInterface;
import net.moss.resonance.world.UniqueStructureDataSaver;
import net.moss.resonance.world.UniqueStructurePlacement;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ModEvents {
    public static class_1269 onEntityInteract(class_1657 player, class_1937 world, class_1268 hand, class_1297 target, class_3966 hitResult) {
        if (world.method_8608()) {
            return class_1269.field_5811;
        }
        class_1799 itemstack = player.method_5998(hand);
        if (itemstack.method_7909().equals(Resonance.TINTED_BOTTLE)) {
            Boolean successfulPickup = true;
            class_1799 bottleType = Resonance.TINTED_BOTTLE.method_7854();
            if (target.method_5864() == class_1299.field_6066) {
                bottleType = Resonance.FIREBALL_BOTTLE.method_7854();
            } else if (target.method_5864() == class_1299.field_6100) {
                bottleType = Resonance.SHULKER_BOTTLE.method_7854();
            } else if (target.method_5864() == ModEntities.LOST_SOUL) {
                bottleType = Resonance.SOUL_BOTTLE.method_7854();
            } else {
                successfulPickup = false;
            }
            if (successfulPickup.booleanValue()) {
                Resonance.TINTED_BOTTLE_CRITERION.trigger((class_3222)player, target);
                world.method_45447(null, player.method_24515(), class_3417.field_14779, class_3419.field_15248);
                player.method_7259(class_3468.field_15372.method_14956((Object)itemstack.method_7909()));
                target.method_5650(class_1297.class_5529.field_26999);
                if (itemstack.method_7947() > 1) {
                    class_5328.method_30012((class_1799)itemstack, (class_1657)player, (class_1799)bottleType);
                } else {
                    itemstack.method_7934(1);
                    player.method_6122(hand, bottleType);
                }
                player.method_7357().method_7906(bottleType.method_7909(), 20);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public static class_1269 onBlockInteract(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        class_1799 itemstack = player.method_5998(hand);
        class_2338 pos = hitResult.method_17777();
        class_2680 state = world.method_8320(pos);
        if ((itemstack.method_31574(class_1802.field_27063) || itemstack.method_31574(Resonance.CHARGED_AMETHYST_SHARD) || itemstack.method_31574(Resonance.PEARL) || itemstack.method_31574(Resonance.BIFURCATED_PEARL)) && state.method_27852(class_2246.field_10295)) {
            if (player instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)player;
                class_174.field_24478.method_23889(serverPlayerEntity, pos, itemstack);
            }
            player.method_7259(class_3468.field_15372.method_14956((Object)itemstack.method_7909()));
            world.method_8501(pos, Resonance.BUDDING_PEARL_ICE.method_9564());
            state = world.method_8320(pos);
            world.method_54762(player, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_26980, class_3419.field_15245);
            ((BuddingPearlIce)state.method_26204()).putSeed(world, pos, state, itemstack);
            return class_1269.field_5812;
        }
        if (itemstack.method_31574(class_1802.field_8868)) {
            class_2248 block = null;
            if (state.method_27852(class_2246.field_27161)) {
                block = class_2246.field_27162;
            } else if (state.method_27852(class_2246.field_27162)) {
                block = class_2246.field_27163;
            } else if (state.method_27852(class_2246.field_27163)) {
                block = class_2246.field_27164;
            } else if (state.method_27852(Resonance.CHARGED_AMETHYST_CLUSTER)) {
                block = Resonance.LARGE_CHARGED_AMETHYST_BUD;
            } else if (state.method_27852(Resonance.LARGE_CHARGED_AMETHYST_BUD)) {
                block = Resonance.MEDIUM_CHARGED_AMETHYST_BUD;
            } else if (state.method_27852(Resonance.MEDIUM_CHARGED_AMETHYST_BUD)) {
                block = Resonance.SMALL_CHARGED_AMETHYST_BUD;
            }
            if (block != null) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)player;
                    class_174.field_24478.method_23889(serverPlayerEntity, pos, itemstack);
                }
                player.method_7259(class_3468.field_15372.method_14956((Object)itemstack.method_7909()));
                world.method_31595(pos, state);
                world.method_8501(pos, block.method_34725(state));
                world.method_54762(player, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_26979, class_3419.field_15245);
                itemstack.method_7970(4, (class_1309)player, class_1309.method_56079((class_1268)hand));
                player.method_7357().method_7906(class_1802.field_8868, 20);
            }
        }
        return class_1269.field_5811;
    }

    public static class_1271<class_1799> onItemUse(class_1657 player, class_1937 world, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            EnchantUtils.onStackUsed(serverWorld, itemstack, (class_1309)player, hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171, item -> {});
        }
        return class_1271.method_22430((Object)itemstack);
    }

    public static void onServerStart(MinecraftServer server) {
        block9: {
            UniqueStructureDataSaver serverState;
            block8: {
                serverState = UniqueStructureDataSaver.getServerState(server);
                if (!serverState.generated) break block8;
                server.method_30002().method_14178().method_46642().method_46697().forEach(structureSet -> {
                    class_6874 patt0$temp = ((class_7059)structureSet.comp_349()).comp_511();
                    if (patt0$temp instanceof UniqueStructurePlacement) {
                        UniqueStructurePlacement placement = (UniqueStructurePlacement)patt0$temp;
                        String name = structureSet.method_55840();
                        if (!serverState.name.contains(name)) {
                            return;
                        }
                        class_2338 pos = serverState.pos.get(serverState.name.indexOf(name));
                        placement.setChunk(pos.method_10263() >> 4, pos.method_10260() >> 4);
                    }
                });
                break block9;
            }
            int maxSearchRadius = 200;
            int sizeMultiplier = 100;
            block0: for (class_5321 WorldKey : server.method_29435().stream().toList()) {
                class_3218 world = server.method_3847(WorldKey);
                ArrayList structureSets = new ArrayList();
                world.method_14178().method_46642().method_46697().forEach(structureSet -> {
                    if (((class_7059)structureSet.comp_349()).comp_511() instanceof UniqueStructurePlacement) {
                        structureSets.add(structureSet);
                    }
                });
                for (int searchRadius = 1; searchRadius <= maxSearchRadius; ++searchRadius) {
                    ArrayList<Float> angles = new ArrayList<Float>();
                    float i = 0.0f;
                    while ((double)i < Math.PI * 2) {
                        angles.add(Float.valueOf(i));
                        i += 1.0f / (float)searchRadius;
                    }
                    Collections.shuffle(angles);
                    for (Float searchAngle : angles) {
                        block10: {
                            class_6880 structureSet2;
                            block11: {
                                int x = (int)(Math.cos(searchAngle.floatValue()) * (double)searchRadius * (double)sizeMultiplier);
                                int z = (int)(Math.sin(searchAngle.floatValue()) * (double)searchRadius * (double)sizeMultiplier);
                                Iterator iterator = structureSets.iterator();
                                if (!iterator.hasNext()) break block10;
                                structureSet2 = (class_6880)iterator.next();
                                class_6874 class_68742 = ((class_7059)structureSet2.comp_349()).comp_511();
                                if (!(class_68742 instanceof UniqueStructurePlacement)) break block11;
                                UniqueStructurePlacement placement = (UniqueStructurePlacement)class_68742;
                                if (searchRadius * sizeMultiplier < placement.getDistance()) break block10;
                                class_2338 pos = new class_2338(x, placement.getTestHeight(), z);
                                int depth = placement.getBiomeDepth();
                                class_6885<class_1959> biomes = placement.getBiomes();
                                if (!biomes.method_40241(world.method_23753(pos.method_10076(depth))) || !biomes.method_40241(world.method_23753(pos.method_10077(depth))) || !biomes.method_40241(world.method_23753(pos.method_10089(depth))) || !biomes.method_40241(world.method_23753(pos.method_10088(depth)))) break block10;
                                if (biomes.method_40241(world.method_23753(pos))) {
                                    serverState.name.add(structureSet2.method_55840());
                                    serverState.pos.add(pos);
                                    placement.setChunk(pos.method_10263() >> 4, pos.method_10260() >> 4);
                                    Resonance.LOGGER.info("Assigned [" + structureSet2.method_55840() + "] To: " + String.valueOf(pos));
                                }
                            }
                            structureSets.remove(structureSet2);
                        }
                        if (!structureSets.isEmpty()) continue;
                        break;
                    }
                    if (structureSets.isEmpty()) continue block0;
                }
            }
            serverState.generated = true;
        }
    }

    public static void onReverberate(class_1937 world, class_243 pos, Vector3f angle, @Nullable class_1297 immuneEntity, @Nullable class_1297 sourceEntity, float strength, boolean windCharged) {
        world.method_32888(Resonance.REVERBERATE_EVENT, pos, class_5712.class_7397.method_43287((class_2680)world.method_8320(class_2338.method_49638((class_2374)pos))));
        if (!windCharged) {
            world.method_8454(sourceEntity, Utils.damageSource(world, Resonance.REVERBERATION_DAMAGE), (class_5362)new Utils.CustomWindChargeBehavior(Float.valueOf(0.0f)), pos.method_10216(), pos.method_10214(), pos.method_10215(), 0.5f, false, class_1937.class_7867.field_51779, (class_2394)ModParticles.AMETHYST_PARTICLE, (class_2394)ModParticles.AMETHYST_PARTICLE, Resonance.REVERBERATION_SOUND);
        }
        if (world instanceof class_3218) {
            class_3218 world2 = (class_3218)world;
            world2.method_14199((class_2394)ModParticles.SMALL_RING_PARTICLE, pos.method_10216(), pos.method_10214(), pos.method_10215(), 1, 0.0, 0.0, 0.0, 3.0);
            world2.method_14199((class_2394)ModParticles.AMETHYST_PARTICLE, pos.method_10216(), pos.method_10214(), pos.method_10215(), (int)(10.0f * strength), 0.0, 0.0, 0.0, 1.0);
            if ((double)strength >= 1.5) {
                world2.method_14199((class_2394)ModParticles.MEDIUM_RING_PARTICLE, pos.method_10216(), pos.method_10214(), pos.method_10215(), 1, 0.0, 0.0, 0.0, 1.0);
            }
            for (class_2350 direction : class_2350.values()) {
                class_2338 blockPos = class_2338.method_49638((class_2374)pos).method_10093(direction);
                class_2586 class_25862 = world.method_8321(blockPos);
                if (!(class_25862 instanceof class_2636)) continue;
                class_2636 mobSpawnerBlockEntity = (class_2636)class_25862;
                class_243 spawnerPos = new class_243((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5);
                world2.method_14199((class_2394)ModParticles.MEDIUM_RING_PARTICLE, spawnerPos.method_10216(), spawnerPos.method_10214(), spawnerPos.method_10215(), 1, 0.0, 0.0, 0.0, 1.0);
                world2.method_14199((class_2394)class_2398.field_11215, spawnerPos.method_10216(), spawnerPos.method_10214() + 0.75, spawnerPos.method_10215(), 20, 0.0, 0.0, 0.0, 1.0);
                ((MobSpawnerLogicAccessor)mobSpawnerBlockEntity.method_11390()).setSpawnDelay(world.field_9229.method_43048(15));
            }
        } else {
            world.method_8466((class_2394)ModParticles.SMALL_RING_PARTICLE, true, pos.method_10216(), pos.method_10214(), pos.method_10215(), (double)angle.x, (double)angle.y, (double)angle.z);
        }
        List<class_1297> list = Utils.entitiesInRadius(world, pos, immuneEntity, 3.0f, 3.0f, class_1297::method_5805);
        for (class_1297 entity2 : list) {
            class_1309 entity1;
            if (entity2 instanceof class_1542) {
                class_1542 entity12 = (class_1542)entity2;
                if (world instanceof class_3218) {
                    class_3218 world2 = (class_3218)world;
                    entity2.method_5762(0.0, 0.1, 0.0);
                    class_1799 material = entity12.method_6983();
                    Optional recipe = world2.method_8503().method_3772().method_8132((class_3956)ReverberationRecipe.Type.INSTANCE, (class_9695)new class_9696(material), (class_1937)world2);
                    if (!recipe.isPresent()) continue;
                    ReverberationRecipe reverberationRecipe = (ReverberationRecipe)((class_8786)recipe.get()).comp_1933();
                    int explosionPower = reverberationRecipe.getExplosionPower();
                    if (reverberationRecipe.getResonates() && strength > 0.2f) {
                        ((ReverberateEvent.Reverberate)ReverberateEvent.REVERBERATE.invoker()).onResonate(world, entity12.method_19538(), angle, (class_1297)entity12, sourceEntity, 0.2f, false);
                    }
                    if (explosionPower > 0) {
                        world2.method_8437(sourceEntity, entity12.method_23317(), entity12.method_23318(), entity12.method_23321(), (float)explosionPower, class_1937.class_7867.field_40890);
                    }
                    for (class_1799 stack : reverberationRecipe.getResults()) {
                        world.method_8649((class_1297)new class_1542(world, entity12.method_23317(), entity12.method_23318(), entity12.method_23321(), stack, 0.0, 0.2, 0.0));
                    }
                    if (material.method_7947() <= 0 || !reverberationRecipe.getIsMaterialConsumed()) continue;
                    material.method_7934(1);
                    continue;
                }
            }
            if (!(entity2 instanceof class_1309) || (entity1 = (class_1309)entity2).method_6039()) continue;
            if (entity2 instanceof class_1548) {
                class_1548 creeperEntity = (class_1548)entity2;
                creeperEntity.method_7004();
            } else {
                float damage = (float)((double)((float)(entity2.method_5864().method_20210(Resonance.SOUND_SENSITIVE_TAG) ? 2 : 1) * strength * 8.0f) / Math.max(pos.method_1022(entity2.method_19538()), 1.0));
                if (sourceEntity != null && sourceEntity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)sourceEntity;
                    entity2.method_5643(Utils.damageSource(world, Resonance.REVERBERATION_DAMAGE, (class_1297)livingEntity), damage);
                } else {
                    entity2.method_5643(Utils.damageSource(world, Resonance.REVERBERATION_DAMAGE, pos), damage);
                }
            }
            Utils.customKnockbackClamp(entity1, pos, 0.4f * strength, Float.valueOf(3.0f));
        }
    }

    public static class_1269 onParry(class_1309 defender, @Nullable class_1282 source, float amount, class_1268 hand, class_1799 shield) {
        class_1297 class_12972;
        defender.method_32876(Resonance.SHIELD_PARRY_EVENT);
        Resonance.PARRY_CRITERION.trigger((class_3222)defender);
        if (shield.method_7909() == Resonance.AMETHYST_SHIELD) {
            defender.method_37908().method_43128(null, defender.method_23317(), defender.method_23318(), defender.method_23321(), class_3417.field_26980, class_3419.field_15248, 2.0f, 1.0f);
            if (source != null) {
                if (!source.method_60489()) {
                    ((ReverberateEvent.Reverberate)ReverberateEvent.REVERBERATE.invoker()).onResonate(defender.method_5770(), source.method_5510().method_1031(0.0, 0.0, 0.0), new Vector3f(0.0f, 0.0f, 0.0f), (class_1297)defender, (class_1297)defender, 0.5f, false);
                } else {
                    ((ReverberateEvent.Reverberate)ReverberateEvent.REVERBERATE.invoker()).onResonate(defender.method_5770(), source.method_5529().method_19538().method_1031(0.0, 1.25, 0.0), new Vector3f(0.0f, 0.0f, 0.0f), (class_1297)defender, (class_1297)defender, 0.5f, false);
                }
            } else {
                ((ReverberateEvent.Reverberate)ReverberateEvent.REVERBERATE.invoker()).onResonate(defender.method_5770(), defender.method_33571(), new Vector3f(0.0f, 0.0f, 0.0f), (class_1297)defender, (class_1297)defender, 0.5f, false);
            }
        } else if (shield.method_7909() == Resonance.COPPER_SHIELD) {
            if (source != null) {
                class_1297 class_12973 = source.method_5529();
                if (class_12973 instanceof class_1657) {
                    class_1657 player = (class_1657)class_12973;
                    player.method_7357().method_7906(shield.method_7909(), 66);
                    player.method_6021();
                    player.method_37908().method_8421((class_1297)player, (byte)30);
                }
                if ((class_12973 = source.method_5529()) instanceof class_1309) {
                    class_1309 entity = (class_1309)class_12973;
                    entity.method_6005(0.6, defender.method_23317() - entity.method_23317(), defender.method_23321() - entity.method_23321());
                    entity.method_6092(new class_1293(class_1294.field_5909, 50, 2, false, false, false));
                    entity.method_6092(new class_1293(class_1294.field_5911, 100, 2, false, false, false));
                }
            }
        } else if (source != null && (class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            entity.method_6005(0.4, defender.method_23317() - entity.method_23317(), defender.method_23321() - entity.method_23321());
        }
        return class_1269.field_5811;
    }

    public static void onStaticShock(class_1309 source, int amplifier, @Nullable class_1309 attacker) {
        class_3218 world;
        int damage = 1 + amplifier;
        class_1937 world2 = source.method_37908();
        if (world2.method_8407() == class_1267.field_5801) {
            --damage;
        } else if (world2.method_8407() == class_1267.field_5805) {
            damage = (int)Math.min((float)damage / 2.0f + 1.0f, (float)damage);
        } else if (world2.method_8407() == class_1267.field_5807) {
            damage = (int)((float)damage * 3.0f / 2.0f);
        }
        if (world2 instanceof class_3218 && source.method_5643(Utils.damageSource((class_1937)(world = (class_3218)world2), Resonance.SPARKING_DAMAGE), (float)damage)) {
            world2.method_8396(null, source.method_24515(), (class_3414)Resonance.ELECTRIC_SPARK_SOUND.comp_349(), class_3419.field_15254, 1.0f, world2.method_8409().method_43057() * 0.4f + 0.8f);
            if (attacker != null) {
                source.method_6005(0.2 * (double)(amplifier + 1), attacker.method_23317() - source.method_23317(), attacker.method_23321() - source.method_23321());
            }
            world.method_14199((class_2394)ModParticles.SPARK_PARTICLE, source.method_23317(), source.method_23318() + (double)(source.method_17682() / 2.0f), source.method_23321(), 20, 0.0, 0.0, 0.0, 1.0);
            int duration = source.method_6112(Resonance.SPARKING).method_5584();
            if (amplifier > 0) {
                Utils.decrementStatusEffectAmplifiers(source, Resonance.SPARKING, null);
                List<class_1297> list = Utils.entitiesInRadius((class_1937)world, source.method_19538(), (class_1297)source, 2.0f, 2.0f, class_1297::method_5805);
                for (class_1297 entity2 : list) {
                    if (!(entity2 instanceof class_1309)) continue;
                    class_1309 entity1 = (class_1309)entity2;
                    if (world.field_9229.method_43048(4 / Math.min(amplifier + 1, 4)) != 0) continue;
                    world.method_14199((class_2394)ModParticles.SPARK_PARTICLE, entity2.method_23317(), entity2.method_23318() + (double)(entity2.method_17682() / 2.0f), entity2.method_23321(), 20, 0.0, 0.0, 0.0, 1.0);
                    entity2.method_5643(Utils.damageSource((class_1937)world, Resonance.SPARKING_DAMAGE), (float)damage);
                    entity1.method_6005(0.2 * (double)(amplifier + 1), source.method_23317() - entity1.method_23317(), source.method_23321() - entity1.method_23321());
                    Utils.sumStatusEffectAmplifiers(entity1, new class_1293(Resonance.SPARKING, duration, amplifier - 1), 4);
                }
            } else {
                source.method_6016(Resonance.SPARKING);
                if (duration > 100) {
                    source.method_6092(new class_1293(Resonance.SPARKING, duration - 100, amplifier));
                }
            }
        }
    }

    public static class_1269 onCrit(class_1657 attacker, class_1297 victim, int critCount, class_1268 hand, class_1799 weapon) {
        class_1792 class_17922 = weapon.method_7909();
        if (class_17922 instanceof CritStoringInterface) {
            CritStoringInterface interface1 = (CritStoringInterface)class_17922;
            interface1.critStreak(weapon, critCount);
        }
        Resonance.CRIT_CRITERION.trigger((class_3222)attacker, critCount);
        return class_1269.field_5811;
    }

    public static class_1269 onCritDeath(class_1657 attacker, class_1297 victim, int critCount, class_1268 hand, class_1799 weapon) {
        class_1792 class_17922 = weapon.method_7909();
        if (class_17922 instanceof CritStoringInterface) {
            CritStoringInterface interface1 = (CritStoringInterface)class_17922;
            interface1.critDeath(weapon, critCount);
        }
        return class_1269.field_5811;
    }

    public static void registerEvents() {
        ReverberateEvent.registerEvents();
        ShieldEvents.registerEvents();
        StaticShockEvent.registerEvents();
        PlayerCritEvent.registerEvents();
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> ModEvents.onEntityInteract(player, world, hand, entity, hitResult));
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> ModEvents.onBlockInteract(player, world, hand, hitResult));
        UseItemCallback.EVENT.register((player, world, hand) -> ModEvents.onItemUse(player, world, hand));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> ModEvents.onServerStart(server));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> LocateUniqueStructureCommand.register((CommandDispatcher<class_2168>)dispatcher, false));
        ReverberateEvent.REVERBERATE.register((world, pos, angle, immuneEntity, sourceEntity, strength, windCharged) -> ModEvents.onReverberate(world, pos, angle, immuneEntity, sourceEntity, strength, windCharged));
        ShieldEvents.SHIELD_BLOCK.register((defender, amount, hand, shield) -> class_1269.field_5811);
        ShieldEvents.SHIELD_DISABLE.register((defender, hand, shield) -> class_1269.field_5811);
        ShieldEvents.SHIELD_PARRY.register((defender, source, amount, hand, shield) -> ModEvents.onParry(defender, source, amount, hand, shield));
        StaticShockEvent.STATIC_SHOCK.register((source, amplifier, attacker) -> ModEvents.onStaticShock(source, amplifier, attacker));
        PlayerCritEvent.CRIT_EVENT.register((attacker, victim, critCount, hand, weapon) -> ModEvents.onCrit(attacker, victim, critCount, hand, weapon));
        PlayerCritEvent.CRIT_DEATH_EVENT.register((attacker, victim, critCount, hand, weapon) -> ModEvents.onCritDeath(attacker, victim, critCount, hand, weapon));
    }
}

