/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.mixin;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3483;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8111;
import net.minecraft.class_9236;
import net.moss.resonance.Resonance;
import net.moss.resonance.entity.LostSoulEntity;
import net.moss.resonance.entity.ModEntities;
import net.moss.resonance.event.ReverberateEvent;
import net.moss.resonance.event.ShieldEvents;
import net.moss.resonance.event.StaticShockEvent;
import net.moss.resonance.item.CustomShield;
import net.moss.resonance.util.EnchantUtils;
import net.moss.resonance.util.Utils;
import net.moss.resonance.util.interfaces.PlayerEntityInterface;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    private boolean echoScarfDamageHalf = false;

    @Inject(at={@At(value="HEAD")}, method={"getPreferredEquipmentSlot"}, cancellable=true)
    private void getPreferredEquipmentSlot(class_1799 stack, CallbackInfoReturnable<class_1304> callbackinfo) {
        if (stack.method_7909() instanceof CustomShield) {
            callbackinfo.setReturnValue((Object)class_1304.field_6171);
        }
    }

    @ModifyConstant(method={"isBlocking"}, constant={@Constant(intValue=5)})
    private int isBlocking(int value) {
        return 0;
    }

    @Inject(method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damageShield(F)V", shift=At.Shift.AFTER)})
    private void parry(class_1282 source, float amount, CallbackInfoReturnable<Boolean> ret) {
        class_1309 defender = (class_1309)this;
        class_1268 hand = defender.method_6058();
        class_1799 activeItem = defender.method_6030();
        if (defender.method_6014() >= activeItem.method_7909().method_7881(activeItem, defender) - 8) {
            ((ShieldEvents.ShieldParry)ShieldEvents.SHIELD_PARRY.invoker()).parry(defender, source, amount, hand, activeItem);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"damage"})
    private void damage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> ret) {
        class_1309 entity = (class_1309)this;
        class_5819 random = entity.method_59922();
        class_1937 world = entity.method_37908();
        class_1309 attacker = null;
        boolean getAttacker = true;
        List<class_1799> allEquippedHands = Utils.getAllEquipped(entity, true);
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            attacker = livingEntity;
        } else {
            class_1676 projectileEntity;
            class_12972 = source.method_5529();
            if (class_12972 instanceof class_1676 && (class_12972 = (projectileEntity = (class_1676)class_12972).method_24921()) instanceof class_1309) {
                class_1309 ownerEntity;
                attacker = ownerEntity = (class_1309)class_12972;
            } else {
                getAttacker = false;
            }
        }
        if (getAttacker) {
            for (class_1799 itemStack : Utils.getAllEquipped(entity, false)) {
                EnchantUtils.recoilCheck(entity, null, itemStack, 0.3f, Float.valueOf(0.8f), false);
            }
        }
        if (source.method_49708(class_8111.field_42357)) {
            entity.method_6092(new class_1293(Resonance.CRUSHING_WEIGHT, 30, 2));
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (entity.method_6059(class_1294.field_50118) && world.field_9229.method_43048(1 + entity.method_6112(class_1294.field_50118).method_5578()) != 0) {
                double d = entity.method_23317();
                double e = entity.method_23318() + (double)(entity.method_17682() / 2.0f);
                double f = entity.method_23321();
                float g = 3.0f + random.method_43057() * 2.0f;
                serverWorld.method_8454((class_1297)entity, null, class_9236.field_50137, d, e, f, g, false, class_1937.class_7867.field_51779, (class_2394)class_2398.field_49139, (class_2394)class_2398.field_49140, (class_6880)class_3417.field_49049);
            }
        }
        if (entity.method_6059(Resonance.SPARKING) && !source.method_49708(Resonance.SPARKING_DAMAGE)) {
            world.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), (class_3414)Resonance.ELECTRIC_SPARK_SOUND.comp_349(), class_3419.field_15245, 0.1f, 1.0f);
            for (class_1799 itemStack : allEquippedHands) {
                if (!itemStack.method_31573(Resonance.CONDUCTIVE_ITEMS_TAG) && !entity.method_25936().method_26164(Resonance.CONDUCTIVE_BLOCKS_TAG) && !entity.method_55667().method_26164(Resonance.CONDUCTIVE_BLOCKS_TAG) && !entity.method_6030().method_31573(Resonance.CONDUCTIVE_ITEMS_TAG)) continue;
                int amplifier = entity.method_6112(Resonance.SPARKING).method_5578();
                ((StaticShockEvent.StaitcShock)StaticShockEvent.STATIC_SHOCK.invoker()).staticShock(entity, amplifier, attacker);
                break;
            }
            if (getAttacker) {
                for (class_1799 itemStack : attacker.method_5877()) {
                    if (!itemStack.method_31573(Resonance.CONDUCTIVE_ITEMS_TAG)) continue;
                    int amplifier = entity.method_6112(Resonance.SPARKING).method_5578();
                    ((StaticShockEvent.StaitcShock)StaticShockEvent.STATIC_SHOCK.invoker()).staticShock(entity, amplifier, attacker);
                    break;
                }
            }
        }
    }

    @ModifyVariable(method={"damage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isInvulnerableTo(Lnet/minecraft/entity/damage/DamageSource;)Z"), argsOnly=true)
    private class_1282 modifyDamageSource(class_1282 source) {
        this.echoScarfDamageHalf = source.method_49708(Resonance.REVERBERATION_DAMAGE) || source.method_5529() != null && source.method_5529().method_5864().method_20210(Resonance.SOUND_SENSITIVE_TAG);
        return source;
    }

    @ModifyVariable(method={"damage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isInvulnerableTo(Lnet/minecraft/entity/damage/DamageSource;)Z"), argsOnly=true)
    private float modifyDamage(float amount) {
        class_1309 entity = (class_1309)this;
        if (Utils.isItemEquipped(entity, Resonance.ECHO_SCARF, false)) {
            ((ReverberateEvent.Reverberate)ReverberateEvent.REVERBERATE.invoker()).onResonate(entity.method_37908(), entity.method_33571(), new Vector3f(0.0f, (float)((double)(entity.method_5791() / 180.0f) * Math.PI), 0.0f), (class_1297)entity, (class_1297)entity, 1.5f, false);
            if (this.echoScarfDamageHalf) {
                amount = (float)((double)amount / 1.5);
                return amount;
            }
        }
        if (Utils.isItemEquipped(entity, Resonance.SPIRIT_SCARF, false)) {
            float health = entity.method_6032();
            return health - amount > 1.0f || amount > health * 5.0f ? amount : (float)org.joml.Math.clamp((int)1, (int)((int)health - 1), (int)((int)amount));
        }
        return amount;
    }

    @Inject(at={@At(value="HEAD")}, method={"fall"}, cancellable=true)
    private void staticShockFall(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition, CallbackInfo ret) {
        class_1657 player;
        class_1309 entity = (class_1309)this;
        class_1937 world = entity.method_37908();
        if (!world.field_9236 && onGround && entity.field_6017 > 0.0f && entity.method_6059(Resonance.SPARKING)) {
            for (class_1799 itemStack : Utils.getAllEquipped(entity, true)) {
                if (!itemStack.method_31573(Resonance.CONDUCTIVE_ITEMS_TAG)) continue;
                int amplifier = entity.method_6112(Resonance.SPARKING).method_5578();
                ((StaticShockEvent.StaitcShock)StaticShockEvent.STATIC_SHOCK.invoker()).staticShock(entity, amplifier, null);
                return;
            }
        }
        if (entity instanceof class_1657 && (player = (class_1657)entity).method_24828() && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            ((PlayerEntityInterface)player).endGroundPound(serverWorld, player, null);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canFreeze"}, cancellable=true)
    private void canFreeze(CallbackInfoReturnable<Boolean> cir) {
        if (Utils.isItemEquipped((class_1309)this, Resonance.SCARF, false)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getArmorVisibility"}, cancellable=true)
    private void getArmorVisibility(CallbackInfoReturnable<Float> cir) {
        class_1309 entity = (class_1309)this;
        if (Utils.isItemEquipped(entity, Resonance.PHANTOM_SCARF, false) && entity.method_6059(class_1294.field_5905)) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getJumpBoostVelocityModifier"}, cancellable=true)
    protected void getJumpBoostVelocityModifier(CallbackInfoReturnable<Float> cir) {
        class_1309 entity = (class_1309)this;
        if (entity.method_6059(Resonance.STRONG_DOUBLE_JUMP)) {
            cir.setReturnValue((Object)Float.valueOf(0.3f));
        } else if (entity.method_6059(Resonance.NORMAL_DOUBLE_JUMP)) {
            cir.setReturnValue((Object)Float.valueOf(0.1f));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;Lnet/minecraft/entity/Entity;)Z"}, cancellable=true)
    private void addStatusEffect(class_1293 effect, @Nullable class_1297 source, CallbackInfoReturnable<Void> ret) {
        if (source instanceof class_1657) {
            class_1657 player = (class_1657)source;
            Resonance.INFLICT_POTION_EFFECT_CRITERION.trigger((class_3222)player, (class_1297)((class_1309)this), effect);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onDeath"}, cancellable=true)
    protected void onDeath(class_1282 damageSource, CallbackInfo info) {
        class_1309 entity = (class_1309)this;
        if (entity.method_5864().method_20210(class_3483.field_15507) && (entity.method_6059(Resonance.SOUL_FATIGUE) || entity instanceof class_1639)) {
            class_1937 world = entity.method_37908();
            if (entity.method_59922().method_43048(5) - world.method_8407().method_5461() <= 0) {
                LostSoulEntity lostSoulEntity = new LostSoulEntity(ModEntities.LOST_SOUL, world);
                lostSoulEntity.method_33574(entity.method_33571());
                lostSoulEntity.method_18800(0.0, 0.1, 0.0);
                world.method_8649((class_1297)lostSoulEntity);
            }
        }
    }
}

