/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.util;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_47;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8111;
import net.minecraft.class_8567;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9698;
import net.minecraft.class_9699;
import net.minecraft.class_9703;
import net.minecraft.class_9710;
import net.moss.resonance.Resonance;
import net.moss.resonance.util.Utils;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;

public class EnchantUtils {
    public static void recoilCheck(class_1309 entity, @Nullable class_1282 damageSource, class_1799 stack, float strength, @Nullable Float clamp, boolean modifyCheck) {
        class_1937 class_19372;
        if (class_1890.method_60142((class_1799)stack, Resonance.HAS_RECOIL) && (class_19372 = entity.method_37908()) instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            class_243 source = entity.method_33571().method_1019(entity.method_5828(1.0f));
            if (damageSource == null) {
                damageSource = Utils.damageSource((class_1937)world, (class_5321<class_8110>)class_8111.field_42329);
            }
            if (modifyCheck) {
                strength += 0.2f * class_1890.method_60175((class_3218)world, (class_1799)stack, (class_1297)entity, (class_1282)damageSource, (float)((float)entity.method_45326(class_5134.field_23722)));
            }
            Utils.customKnockbackClamp(entity, source, strength, clamp);
        }
    }

    public static void setCooldownTime(class_1799 stack, class_1657 user, float baseCooldown) {
        MutableFloat mutableFloat = new MutableFloat(baseCooldown);
        EnchantUtils.forEachEnchantment((class_1309)user, (enchantment, level, context) -> EnchantUtils.modifyCooldownDuration((class_1887)enchantment.comp_349(), user.method_59922(), level, mutableFloat));
        user.method_7357().method_7906(stack.method_7909(), class_3532.method_15375((float)(Math.max(0.0f, mutableFloat.floatValue()) * 20.0f)));
    }

    public static float getWeightValue(class_1799 stack, class_1657 user, float baseWeight) {
        MutableFloat mutableFloat = new MutableFloat(baseWeight);
        EnchantUtils.forEachEnchantment((class_1309)user, (enchantment, level, context) -> EnchantUtils.modifyWeight((class_1887)enchantment.comp_349(), user.method_59922(), level, mutableFloat));
        return Math.max(0.0f, mutableFloat.floatValue());
    }

    public static void onTargetCritDamaged(class_3218 world, class_1297 target, class_1282 damageSource, @Nullable class_1799 weapon) {
        class_1297 class_12972;
        class_1309 livingEntity;
        if (target instanceof class_1309) {
            livingEntity = (class_1309)target;
            EnchantUtils.forEachEnchantment(livingEntity, (enchantment, level, context) -> EnchantUtils.postCrit((class_1887)enchantment.comp_349(), world, level, context, class_9703.field_51685, target, damageSource));
        }
        if (weapon != null && (class_12972 = damageSource.method_5529()) instanceof class_1309) {
            livingEntity = (class_1309)class_12972;
            EnchantUtils.forEachEnchantment(weapon, class_1304.field_6173, livingEntity, (enchantment, level, context) -> EnchantUtils.postCrit((class_1887)enchantment.comp_349(), world, level, context, class_9703.field_51683, target, damageSource));
        }
    }

    public static void onStackUsed(class_3218 world, class_1799 stack, class_1309 user, class_1304 slot, Consumer<class_1792> onBreak) {
        class_9699 enchantmentEffectContext = new class_9699(stack, slot, user, onBreak);
        EnchantUtils.forEachEnchantment(stack, class_1304.field_6173, user, (enchantment, level, context) -> EnchantUtils.postUse((class_1887)enchantment.comp_349(), world, level, enchantmentEffectContext, (class_1297)user));
    }

    @Deprecated
    public static class_6880<class_1887> getEnchant(class_1937 world, class_5321<class_1887> enchant) {
        class_7871 registryEntryLookup = world.method_30349().method_46758().method_46751(class_7924.field_41265);
        return registryEntryLookup.method_46747(enchant);
    }

    private static void forEachEnchantment(class_1309 entity, ContextAwareConsumer contextAwareConsumer) {
        for (class_1304 equipmentSlot : class_1304.values()) {
            EnchantUtils.forEachEnchantment(entity.method_6118(equipmentSlot), equipmentSlot, entity, contextAwareConsumer);
        }
    }

    private static void forEachEnchantment(class_1799 stack, class_1304 slot, class_1309 entity, ContextAwareConsumer contextAwareConsumer) {
        if (stack.method_7960()) {
            return;
        }
        class_9304 itemEnchantmentsComponent = (class_9304)stack.method_57824(class_9334.field_49633);
        if (itemEnchantmentsComponent == null || itemEnchantmentsComponent.method_57543()) {
            return;
        }
        class_9699 enchantmentEffectContext = new class_9699(stack, slot, entity);
        for (Object2IntMap.Entry entry : itemEnchantmentsComponent.method_57539()) {
            class_6880 registryEntry = (class_6880)entry.getKey();
            if (!((class_1887)registryEntry.comp_349()).method_60026(slot)) continue;
            contextAwareConsumer.accept((class_6880<class_1887>)registryEntry, entry.getIntValue(), enchantmentEffectContext);
        }
    }

    private static void postCrit(class_1887 enchantment, class_3218 world, int level, class_9699 context, class_9703 target, class_1297 user, class_1282 damageSource) {
        for (class_9710 targetedEnchantmentEffect : enchantment.method_60034(Resonance.POST_CRIT)) {
            if (target != targetedEnchantmentEffect.comp_2700()) continue;
            class_1887.method_60031((class_9710)targetedEnchantmentEffect, (class_3218)world, (int)level, (class_9699)context, (class_1297)user, (class_1282)damageSource);
        }
    }

    private static void postUse(class_1887 enchantment, class_3218 world, int level, class_9699 context, class_1297 user) {
        EnchantUtils.applyEffects(enchantment.method_60034(Resonance.POST_USE), EnchantUtils.createEnchantedEntityLootContext(world, level, user, user.method_19538()), effect -> effect.method_60220(world, level, context, user, user.method_19538()));
    }

    private static void modifyCooldownDuration(class_1887 enchantment, class_5819 random, int level, MutableFloat baseCooldown) {
        enchantment.method_60506(Resonance.COOLDOWN_TIME, random, level, baseCooldown);
    }

    private static void modifyWeight(class_1887 enchantment, class_5819 random, int level, MutableFloat baseCooldown) {
        enchantment.method_60506(Resonance.WEIGHT_VALUE, random, level, baseCooldown);
    }

    private static <T> void applyEffects(List<class_9698<T>> entries, class_47 lootContext, Consumer<T> effectConsumer) {
        for (class_9698<T> enchantmentEffectEntry : entries) {
            if (!enchantmentEffectEntry.method_60006(lootContext)) continue;
            effectConsumer.accept(enchantmentEffectEntry.comp_2680());
        }
    }

    private static class_47 createEnchantedEntityLootContext(class_3218 world, int level, class_1297 entity, class_243 pos) {
        class_8567 lootContextParameterSet = new class_8567.class_8568(world).method_51874(class_181.field_1226, (Object)entity).method_51874(class_181.field_51805, (Object)level).method_51874(class_181.field_24424, (Object)pos).method_51875(class_173.field_51804);
        return new class_47.class_48(lootContextParameterSet).method_309(Optional.empty());
    }

    @FunctionalInterface
    static interface ContextAwareConsumer {
        public void accept(class_6880<class_1887> var1, int var2, class_9699 var3);
    }
}

