/*
 * Decompiled with CFR 0.152.
 */
package net.moss.resonance.block;

import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_5955;
import net.minecraft.class_6880;
import net.minecraft.class_9062;
import net.moss.resonance.Resonance;
import net.moss.resonance.block.VentFluidBlock;
import net.moss.resonance.particle.VentSmoke;
import net.moss.resonance.util.Utils;
import net.moss.resonance.util.VentThickness;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BathyalVent
extends class_2248
implements class_3737 {
    public static final class_2754<VentThickness> THICKNESS = class_2754.method_11850((String)"thickness", VentThickness.class);
    public static final class_2754<class_1767> COLOR = class_2754.method_11850((String)"color", class_1767.class);
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2758 AGE = class_2741.field_12482;
    public static final class_2746 LIT = class_2741.field_12548;
    private static final class_265 UP_TIP_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final class_265 BASE_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final class_265 FRUSTUM_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_265 MIDDLE_SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public BathyalVent(class_4970.class_2251 settings) {
        super(settings.method_49229(class_4970.class_2250.field_10657).method_9631(state -> (Boolean)state.method_11654((class_2769)LIT) != false ? 7 - (Integer)state.method_11654((class_2769)AGE) : 0));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(THICKNESS, (Comparable)((Object)VentThickness.TIP))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657(COLOR, (Comparable)class_1767.field_7944));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{THICKNESS, WATERLOGGED, AGE, LIT, COLOR});
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        world.method_39279(pos, (class_2248)this, 1);
        if (direction == class_2350.field_11036) {
            class_2680 blockState = world.method_8320(pos.method_10084());
            VentThickness thickness = BathyalVent.getThickness((class_4538)world, pos);
            class_1767 color = (class_1767)state.method_11654(COLOR);
            if (blockState.method_27852(Resonance.BATHYAL_VENT)) {
                color = (class_1767)blockState.method_11654(COLOR);
            }
            return (class_2680)((class_2680)((class_2680)state.method_11657(THICKNESS, (Comparable)((Object)thickness))).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf((Boolean)state.method_11654((class_2769)LIT) != false && thickness == VentThickness.TIP))).method_11657(COLOR, (Comparable)color);
        }
        return state;
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!this.method_9558(state, (class_4538)world, pos)) {
            world.method_22352(pos, true);
        } else if (state.method_11654(THICKNESS) == VentThickness.TIP && ((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            for (class_2350 direction : class_2350.values()) {
                if (!world.method_8320(pos.method_10093(direction)).method_27852(class_2246.field_10382)) continue;
                VentFluidBlock.update((class_1936)world, pos.method_10093(direction), state);
            }
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2338 blockPos;
        class_1937 worldAccess = ctx.method_8045();
        VentThickness thickness = BathyalVent.getThickness((class_4538)worldAccess, blockPos = ctx.method_8037());
        return thickness == null ? null : (class_2680)((class_2680)this.method_9564().method_11657(THICKNESS, (Comparable)((Object)thickness))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(worldAccess.method_8316(blockPos).method_15772() == class_3612.field_15910));
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 blockPos = pos.method_10074();
        class_2680 blockState = world.method_8320(blockPos);
        return blockState.method_26206((class_1922)world, blockPos, class_2350.field_11036) || blockState.method_27852(Resonance.BATHYAL_VENT);
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    protected boolean method_37403(class_2680 state, class_1922 world, class_2338 pos) {
        return false;
    }

    protected float method_32913() {
        return 0.125f;
    }

    protected boolean method_9542(class_2680 state) {
        return state.method_11654(THICKNESS) == VentThickness.TIP;
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected class_265 method_9571(class_2680 state, class_1922 world, class_2338 pos) {
        return class_259.method_1073();
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        VentThickness thickness = (VentThickness)((Object)state.method_11654(THICKNESS));
        class_265 voxelShape = thickness == VentThickness.TIP ? UP_TIP_SHAPE : (thickness == VentThickness.FRUSTUM ? BASE_SHAPE : (thickness == VentThickness.MIDDLE ? FRUSTUM_SHAPE : MIDDLE_SHAPE));
        class_243 vec3d = state.method_26226(world, pos);
        return voxelShape.method_1096(vec3d.field_1352, 0.0, vec3d.field_1350);
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (state.method_11654(THICKNESS) == VentThickness.TIP) {
            Optional<class_2338> supportingPos;
            class_1769 dyeItem;
            class_1792 item = stack.method_7909();
            if (item instanceof class_1769 && (dyeItem = (class_1769)item).method_7802() != state.method_11654(COLOR)) {
                stack.method_57008(1, (class_1309)player);
                player.method_7259(class_3468.field_15372.method_14956((Object)dyeItem));
                world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
                world.method_8652(pos, (class_2680)state.method_11657(COLOR, (Comparable)dyeItem.method_7802()), 3);
                world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_28391, class_3419.field_15254, 0.2f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f));
                return class_9062.method_55644((boolean)world.field_9236);
            }
            if (stack.method_31573(Resonance.VENT_IGNITERS_TAG) && (supportingPos = BathyalVent.getSupportingPos(world, pos, state, 11)).isPresent()) {
                class_2338 blockPos = supportingPos.get();
                boolean heatSource = false;
                for (int i = 1; i < 5; ++i) {
                    if (!world.method_8320(blockPos.method_10087(i)).method_26164(Resonance.VENT_HEAT_SOURCE_BLOCKS_TAG)) continue;
                    heatSource = true;
                    break;
                }
                if (heatSource == (Boolean)state.method_11654((class_2769)LIT)) {
                    return super.method_55765(stack, state, world, pos, player, hand, hit);
                }
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(heatSource)), 3);
                if (heatSource) {
                    world.method_43128(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15013, class_3419.field_15254, 0.2f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f));
                    world.method_39279(pos, (class_2248)this, 1);
                } else {
                    world.method_60511(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), Resonance.BATHYAL_VENT_EXTINGUISH_SOUND, class_3419.field_15254, 1.0f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f));
                    if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
                        Vector3f colour = class_243.method_24457((int)((class_1767)state.method_11654(COLOR)).method_7790()).method_46409();
                        class_5819 random = world.method_8409();
                        class_243 vec3d = state.method_26226((class_1922)world, pos);
                        for (int i = 0; i < 5; ++i) {
                            world.method_17452((class_2394)new VentSmoke(colour, 1.0f + random.method_43057() * 2.0f, false), true, (double)pos.method_10263() + 0.5 + vec3d.field_1352 + (random.method_43058() - 0.5) / 5.0, (double)pos.method_10264() + 0.25 + random.method_43058(), (double)pos.method_10260() + 0.5 + vec3d.field_1350 + (random.method_43058() - 0.5) / 5.0, 0.01 * (double)random.method_39332(-1, 1), 0.01 * ((double)random.method_43048(3) - 1.5), 0.01 * (double)random.method_39332(-1, 1));
                        }
                    }
                }
                stack.method_57008(1, (class_1309)player);
                player.method_7259(class_3468.field_15372.method_14956((Object)item));
                world.method_33596((class_1297)player, (class_6880)class_5712.field_28174, pos);
                return class_9062.method_55644((boolean)world.field_9236);
            }
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2680 upState;
        class_2248 class_22482;
        super.method_9514(state, world, pos, random);
        Boolean light = random.method_43048(20) == 1;
        Boolean grow = (Boolean)state.method_11654((class_2769)WATERLOGGED) != false && (Integer)state.method_11654((class_2769)AGE) < 5 && random.method_43048(50) == 2;
        if (random.method_43048(5) != 1 && ((Boolean)state.method_11654((class_2769)LIT)).booleanValue() && (class_22482 = (upState = world.method_8320(pos.method_10084())).method_26204()) instanceof class_5955) {
            class_5955 oxidizable = (class_5955)class_22482;
            oxidizable.method_54765(upState, world, pos.method_10084(), random).ifPresent(degraded -> world.method_8501(pos.method_10084(), degraded));
        }
        if (!light.booleanValue() && !grow.booleanValue()) {
            return;
        }
        Optional<class_2338> supportingPos = BathyalVent.getSupportingPos((class_1937)world, pos, state, 11);
        if (supportingPos.isPresent()) {
            class_2338 blockPos = supportingPos.get();
            boolean heatSource = false;
            for (int i = 1; i < 5; ++i) {
                if (!world.method_8320(blockPos.method_10087(i)).method_26164(Resonance.VENT_HEAT_SOURCE_BLOCKS_TAG)) continue;
                heatSource = true;
                break;
            }
            if (light.booleanValue()) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(heatSource)), 3);
                if (heatSource) {
                    world.method_39279(pos, (class_2248)this, 1);
                }
            } else if (grow.booleanValue() && heatSource && VentFluidBlock.isStillWater(world.method_8320(pos.method_10084()))) {
                class_2874 dim = world.method_8597();
                int age = Math.min((Integer)state.method_11654((class_2769)AGE) + random.method_39332(1, 3 + (pos.method_10264() + dim.comp_651()) / (dim.comp_652() + dim.comp_651()) * 3), 5);
                world.method_8652(pos.method_10084(), (class_2680)((class_2680)((class_2680)Resonance.BATHYAL_VENT.method_9564().method_11657(THICKNESS, (Comparable)((Object)VentThickness.TIP))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(pos).method_15772() == class_3612.field_15910)), 3);
            }
        }
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (((Boolean)state.method_11654((class_2769)LIT)).booleanValue() && ((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() && entity instanceof class_1309) {
            entity.method_5643(Utils.damageSource(world, Resonance.VENT_PLUME_DAMAGE), 1.0f);
        }
        super.method_9548(state, world, pos, entity);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);
        if (((Boolean)state.method_11654((class_2769)LIT)).booleanValue() && ((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            if (random.method_43048(50) == 1) {
                world.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_3414)Resonance.BATHYAL_VENT_AMBIENT_SOUND.comp_349(), class_3419.field_15256, 0.5f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f), false);
            }
            class_243 vec3d = state.method_26226((class_1922)world, pos);
            Vector3f colour = class_243.method_24457((int)((class_1767)state.method_11654(COLOR)).method_7790()).method_46409();
            for (int i = 0; i < random.method_43048(3) + 1; ++i) {
                world.method_17452((class_2394)new VentSmoke(colour, 1.0f + random.method_43057() * 2.0f, false), true, (double)pos.method_10263() + 0.5 + vec3d.field_1352 + (random.method_43058() - 0.5) / 5.0, (double)pos.method_10264() + 0.25 + random.method_43058(), (double)pos.method_10260() + 0.5 + vec3d.field_1350 + (random.method_43058() - 0.5) / 5.0, 0.001 * (double)random.method_39332(-1, 1), 0.01 * (double)(random.method_43048(3) + 1), 0.001 * (double)random.method_39332(-1, 1));
            }
        }
    }

    private static VentThickness getThickness(class_4538 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos.method_10084());
        if (blockState.method_27852(Resonance.BATHYAL_VENT)) {
            VentThickness thickness = (VentThickness)((Object)blockState.method_11654(THICKNESS));
            if (thickness != VentThickness.TIP) {
                return !world.method_8320(pos.method_10074()).method_27852(Resonance.BATHYAL_VENT) ? VentThickness.BASE : VentThickness.MIDDLE;
            }
            return VentThickness.FRUSTUM;
        }
        return VentThickness.TIP;
    }

    private static Optional<class_2338> getSupportingPos(class_1937 world, class_2338 pos, class_2680 state, int range) {
        BiPredicate<class_2338, class_2680> biPredicate = (posx, statex) -> statex.method_27852(Resonance.BATHYAL_VENT);
        return BathyalVent.searchInDirection((class_1936)world, pos, class_2350.field_11033.method_10171(), biPredicate, statex -> !statex.method_27852(Resonance.BATHYAL_VENT), range);
    }

    private static Optional<class_2338> searchInDirection(class_1936 world, class_2338 pos, class_2350.class_2352 direction, BiPredicate<class_2338, class_2680> continuePredicate, Predicate<class_2680> stopPredicate, int range) {
        class_2350 direction2 = class_2350.method_10156((class_2350.class_2352)direction, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_2338.class_2339 mutable = pos.method_25503();
        for (int i = 1; i < range; ++i) {
            mutable.method_10098(direction2);
            class_2680 blockState = world.method_8320((class_2338)mutable);
            if (stopPredicate.test(blockState)) {
                return Optional.of(mutable.method_10062());
            }
            if (!world.method_31601(mutable.method_10264()) && continuePredicate.test((class_2338)mutable, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }
}

